/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.Contract;

public class DatePickerFormatter
extends JFormattedTextField.AbstractFormatter {
    private static final Logger LOG = Logger.getLogger(DatePickerFormatter.class.getName());
    private DateFormat[] _formats = null;

    public DatePickerFormatter() {
        this(null, null);
    }

    public DatePickerFormatter(DateFormat[] formats) {
        this(formats, null);
    }

    public DatePickerFormatter(Locale locale) {
        this(null, locale);
    }

    public DatePickerFormatter(DateFormat[] formats, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (formats == null) {
            formats = this.createDefaultFormats(locale);
        }
        Contract.asNotNull(formats, "The array of DateFormats must not contain null formats");
        this._formats = formats;
    }

    public DateFormat[] getFormats() {
        DateFormat[] results = new DateFormat[this._formats.length];
        System.arraycopy(this._formats, 0, results, 0, results.length);
        return results;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        Date result = null;
        ParseException pex = null;
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        for (DateFormat _format : this._formats) {
            try {
                result = _format.parse(text);
                pex = null;
                break;
            }
            catch (ParseException ex) {
                pex = ex;
            }
        }
        if (pex != null) {
            throw pex;
        }
        return result;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value != null && this._formats.length > 0) {
            return this._formats[0].format(value);
        }
        return null;
    }

    protected DateFormat[] createDefaultFormats(Locale locale) {
        ArrayList<DateFormat> f2 = new ArrayList<DateFormat>();
        this.addFormat(f2, "JXDatePicker.longFormat", locale);
        this.addFormat(f2, "JXDatePicker.mediumFormat", locale);
        this.addFormat(f2, "JXDatePicker.shortFormat", locale);
        if (f2.size() == 0) {
            this.addSystemDefaultFormat(f2, locale);
        }
        return f2.toArray(new DateFormat[f2.size()]);
    }

    private void addSystemDefaultFormat(List<DateFormat> f2, Locale locale) {
        f2.add(DateFormat.getDateInstance(3, locale));
    }

    private void addFormat(List<DateFormat> f2, String key, Locale locale) {
        String pattern = UIManagerExt.getString(key, locale);
        if (pattern == null) {
            return;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
            f2.add(format);
        }
        catch (RuntimeException e2) {
            LOG.finer("creating date format failed for key/pattern: " + key + "/" + pattern);
        }
    }

    public static class DatePickerFormatterUIResource
    extends DatePickerFormatter
    implements UIResource {
        public DatePickerFormatterUIResource(Locale locale) {
            super(locale);
        }

        public DatePickerFormatterUIResource() {
            this((Locale)null);
        }

        public DatePickerFormatterUIResource(DateFormat[] formats, Locale locale) {
            super(formats, locale);
        }
    }
}

