/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.error;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class ErrorInfo {
    private String title;
    private String basicErrorMessage;
    private String detailedErrorMessage;
    private String category;
    private Throwable errorException;
    private Level errorLevel;
    private Map<String, String> state;

    public ErrorInfo(String title, String basicErrorMessage, String detailedErrorMessage, String category, Throwable errorException, Level errorLevel, Map<String, String> state) {
        this.title = title;
        this.basicErrorMessage = basicErrorMessage;
        this.detailedErrorMessage = detailedErrorMessage;
        this.category = category;
        this.errorException = errorException;
        this.errorLevel = errorLevel == null ? Level.SEVERE : errorLevel;
        this.state = new HashMap<String, String>();
        try {
            Properties props = System.getProperties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String val;
                String key = entry.getKey() == null ? null : entry.getKey().toString();
                String string = val = entry.getKey() == null ? null : entry.getValue().toString();
                if (key == null) continue;
                this.state.put(key, val);
            }
        }
        catch (SecurityException e2) {
            // empty catch block
        }
        this.state.put("System.currentTimeMillis", "" + System.currentTimeMillis());
        this.state.put("isOnEDT", "" + SwingUtilities.isEventDispatchThread());
        if (state != null) {
            for (Map.Entry<String, String> entry : state.entrySet()) {
                this.state.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getBasicErrorMessage() {
        return this.basicErrorMessage;
    }

    public String getDetailedErrorMessage() {
        return this.detailedErrorMessage;
    }

    public String getCategory() {
        return this.category;
    }

    public Throwable getErrorException() {
        return this.errorException;
    }

    public Level getErrorLevel() {
        return this.errorLevel;
    }

    public Map<String, String> getState() {
        return new HashMap<String, String>(this.state);
    }
}

