/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;

public class TreeExpansionBroadcaster
implements TreeExpansionListener {
    private Object source;
    private EventListenerList listeners;

    public TreeExpansionBroadcaster(Object source) {
        this.source = source;
    }

    public void addTreeExpansionListener(TreeExpansionListener l2) {
        this.getEventListenerList().add(TreeExpansionListener.class, l2);
    }

    public void removeTreeExpansionListener(TreeExpansionListener l2) {
        if (!this.hasListeners()) {
            return;
        }
        this.listeners.remove(TreeExpansionListener.class, l2);
    }

    private EventListenerList getEventListenerList() {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        return this.listeners;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        this.fireTreeExpanded(this.retarget(event));
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        this.fireTreeCollapsed(this.retarget(event));
    }

    private void fireTreeExpanded(TreeExpansionEvent event) {
        TreeExpansionListener[] ls = (TreeExpansionListener[])this.listeners.getListeners(TreeExpansionListener.class);
        for (int i2 = ls.length - 1; i2 >= 0; --i2) {
            ls[i2].treeExpanded(event);
        }
    }

    private void fireTreeCollapsed(TreeExpansionEvent event) {
        TreeExpansionListener[] ls = (TreeExpansionListener[])this.listeners.getListeners(TreeExpansionListener.class);
        for (int i2 = ls.length - 1; i2 >= 0; --i2) {
            ls[i2].treeCollapsed(event);
        }
    }

    private TreeExpansionEvent retarget(TreeExpansionEvent event) {
        return new TreeExpansionEvent(this.source, event.getPath());
    }

    private boolean hasListeners() {
        return this.listeners != null && this.listeners.getListenerCount() > 0;
    }
}

