/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.Color;

public class ColorUtilities {
    private ColorUtilities() {
    }

    public static float[] RGBtoHSL(Color color) {
        return ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    public static float[] RGBtoHSL(Color color, float[] hsl) {
        return ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), hsl);
    }

    public static float[] RGBtoHSL(int r2, int g2, int b2) {
        return ColorUtilities.RGBtoHSL(r2, g2, b2, null);
    }

    public static float[] RGBtoHSL(int r2, int g2, int b2, float[] hsl) {
        float S;
        float H;
        float var_Max;
        float var_Min;
        if (hsl == null) {
            hsl = new float[3];
        } else if (hsl.length < 3) {
            throw new IllegalArgumentException("hsl array must have a length of at least 3");
        }
        if (r2 < 0) {
            r2 = 0;
        } else if (r2 > 255) {
            r2 = 255;
        }
        if (g2 < 0) {
            g2 = 0;
        } else if (g2 > 255) {
            g2 = 255;
        }
        if (b2 < 0) {
            b2 = 0;
        } else if (b2 > 255) {
            b2 = 255;
        }
        float var_R = (float)r2 / 255.0f;
        float var_G = (float)g2 / 255.0f;
        float var_B = (float)b2 / 255.0f;
        if (var_R > var_G) {
            var_Min = var_G;
            var_Max = var_R;
        } else {
            var_Min = var_R;
            var_Max = var_G;
        }
        if (var_B > var_Max) {
            var_Max = var_B;
        }
        if (var_B < var_Min) {
            var_Min = var_B;
        }
        float del_Max = var_Max - var_Min;
        float L = (var_Max + var_Min) / 2.0f;
        if (del_Max - 0.01f <= 0.0f) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = L < 0.5f ? del_Max / (var_Max + var_Min) : del_Max / (2.0f - var_Max - var_Min);
            float del_R = ((var_Max - var_R) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_G = ((var_Max - var_G) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_B = ((var_Max - var_B) / 6.0f + del_Max / 2.0f) / del_Max;
            H = var_R == var_Max ? del_B - del_G : (var_G == var_Max ? 0.33333334f + del_R - del_B : 0.6666667f + del_G - del_R);
            if (H < 0.0f) {
                H += 1.0f;
            }
            if (H > 1.0f) {
                H -= 1.0f;
            }
        }
        hsl[0] = H;
        hsl[1] = S;
        hsl[2] = L;
        return hsl;
    }

    public static Color HSLtoRGB(float h2, float s2, float l2) {
        int[] rgb = ColorUtilities.HSLtoRGB(h2, s2, l2, null);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static int[] HSLtoRGB(float h2, float s2, float l2, int[] rgb) {
        int B;
        int G;
        int R2;
        if (rgb == null) {
            rgb = new int[3];
        } else if (rgb.length < 3) {
            throw new IllegalArgumentException("rgb array must have a length of at least 3");
        }
        if (h2 < 0.0f) {
            h2 = 0.0f;
        } else if (h2 > 1.0f) {
            h2 = 1.0f;
        }
        if (s2 < 0.0f) {
            s2 = 0.0f;
        } else if (s2 > 1.0f) {
            s2 = 1.0f;
        }
        if (l2 < 0.0f) {
            l2 = 0.0f;
        } else if (l2 > 1.0f) {
            l2 = 1.0f;
        }
        if (s2 - 0.01f <= 0.0f) {
            R2 = (int)(l2 * 255.0f);
            G = (int)(l2 * 255.0f);
            B = (int)(l2 * 255.0f);
        } else {
            float var_2 = l2 < 0.5f ? l2 * (1.0f + s2) : l2 + s2 - s2 * l2;
            float var_1 = 2.0f * l2 - var_2;
            R2 = (int)(255.0f * ColorUtilities.hue2RGB(var_1, var_2, h2 + 0.33333334f));
            G = (int)(255.0f * ColorUtilities.hue2RGB(var_1, var_2, h2));
            B = (int)(255.0f * ColorUtilities.hue2RGB(var_1, var_2, h2 - 0.33333334f));
        }
        rgb[0] = R2;
        rgb[1] = G;
        rgb[2] = B;
        return rgb;
    }

    private static float hue2RGB(float v1, float v2, float vH) {
        if (vH < 0.0f) {
            vH += 1.0f;
        }
        if (vH > 1.0f) {
            vH -= 1.0f;
        }
        if (6.0f * vH < 1.0f) {
            return v1 + (v2 - v1) * 6.0f * vH;
        }
        if (2.0f * vH < 1.0f) {
            return v2;
        }
        if (3.0f * vH < 2.0f) {
            return v1 + (v2 - v1) * (0.6666667f - vH) * 6.0f;
        }
        return v1;
    }
}

