/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.image.BufferedImage;
import org.jdesktop.swingx.image.AbstractFilter;
import org.jdesktop.swingx.util.GraphicsUtilities;

public class GaussianBlurFilter
extends AbstractFilter {
    private final int radius;

    public GaussianBlurFilter() {
        this(3);
    }

    public GaussianBlurFilter(int radius) {
        if (radius < 1) {
            radius = 1;
        }
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        float[] kernel = GaussianBlurFilter.createGaussianKernel(this.radius);
        GraphicsUtilities.getPixels(src, 0, 0, width, height, srcPixels);
        GaussianBlurFilter.blur(srcPixels, dstPixels, width, height, kernel, this.radius);
        GaussianBlurFilter.blur(dstPixels, srcPixels, height, width, kernel, this.radius);
        GraphicsUtilities.setPixels(dst, 0, 0, width, height, srcPixels);
        return dst;
    }

    static void blur(int[] srcPixels, int[] dstPixels, int width, int height, float[] kernel, int radius) {
        for (int y2 = 0; y2 < height; ++y2) {
            int index = y2;
            int offset = y2 * width;
            for (int x2 = 0; x2 < width; ++x2) {
                float b2 = 0.0f;
                float g2 = 0.0f;
                float r2 = 0.0f;
                float a2 = 0.0f;
                for (int i2 = -radius; i2 <= radius; ++i2) {
                    int subOffset = x2 + i2;
                    if (subOffset < 0 || subOffset >= width) {
                        subOffset = (x2 + width) % width;
                    }
                    int pixel = srcPixels[offset + subOffset];
                    float blurFactor = kernel[radius + i2];
                    a2 += blurFactor * (float)(pixel >> 24 & 0xFF);
                    r2 += blurFactor * (float)(pixel >> 16 & 0xFF);
                    g2 += blurFactor * (float)(pixel >> 8 & 0xFF);
                    b2 += blurFactor * (float)(pixel & 0xFF);
                }
                int ca = (int)(a2 + 0.5f);
                int cr = (int)(r2 + 0.5f);
                int cg = (int)(g2 + 0.5f);
                int cb = (int)(b2 + 0.5f);
                dstPixels[index] = (ca > 255 ? 255 : ca) << 24 | (cr > 255 ? 255 : cr) << 16 | (cg > 255 ? 255 : cg) << 8 | (cb > 255 ? 255 : cb);
                index += height;
            }
        }
    }

    static float[] createGaussianKernel(int radius) {
        int i2;
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        float[] data = new float[radius * 2 + 1];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i2 = -radius; i2 <= radius; ++i2) {
            float distance = i2 * i2;
            int index = i2 + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
        }
        i2 = 0;
        while (i2 < data.length) {
            int n2 = i2++;
            data[n2] = data[n2] / total;
        }
        return data;
    }
}

