/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.util.PaintUtils;

public class BusyPainter
extends AbstractPainter<Object> {
    private int frame = -1;
    private int points = 8;
    private Color baseColor = new Color(200, 200, 200);
    private Color highlightColor = Color.BLACK;
    private int trailLength = 4;
    private Shape pointShape;
    private Shape trajectory;
    private Direction direction = Direction.RIGHT;
    private boolean paintCentered;

    public BusyPainter() {
        this(26);
    }

    public BusyPainter(int height) {
        this(BusyPainter.getScaledDefaultPoint(height), BusyPainter.getScaledDefaultTrajectory(height));
    }

    public BusyPainter(Shape point, Shape trajectory) {
        this.init(point, trajectory, Color.LIGHT_GRAY, Color.BLACK);
    }

    protected static Shape getScaledDefaultTrajectory(int height) {
        return new Ellipse2D.Float(height * 8 / 26 / 2, height * 8 / 26 / 2, height - height * 8 / 26, height - height * 8 / 26);
    }

    protected static Shape getScaledDefaultPoint(int height) {
        return new RoundRectangle2D.Float(0.0f, 0.0f, height * 8 / 26, 4.0f, 4.0f, 4.0f);
    }

    protected void init(Shape point, Shape trajectory, Color baseColor, Color highlightColor) {
        this.baseColor = baseColor;
        this.highlightColor = highlightColor;
        this.pointShape = point;
        this.trajectory = trajectory;
    }

    @Override
    protected void doPaint(Graphics2D g2, Object t2, int width, int height) {
        int i2;
        Rectangle r2 = this.getTrajectory().getBounds();
        int tw = width - r2.width - 2 * r2.x;
        int th = height - r2.height - 2 * r2.y;
        if (this.isPaintCentered()) {
            g2.translate(tw / 2, th / 2);
        }
        PathIterator pi = this.trajectory.getPathIterator(null);
        float[] coords = new float[6];
        Point2D.Float cp = new Point2D.Float();
        Point2D.Float sp = new Point2D.Float();
        float totalDist = 0.0f;
        ArrayList<float[]> segStack = new ArrayList<float[]>();
        do {
            float c2;
            int ret;
            try {
                ret = pi.currentSegment(coords);
            }
            catch (NoSuchElementException e2) {
                return;
            }
            if (ret == 1 || ret == 4 && (sp.x != cp.x || sp.y != cp.y)) {
                c2 = this.calcLine(coords, cp);
                totalDist += c2;
                segStack.add(new float[]{c2, 0.0f, 0.0f, 0.0f, 0.0f, coords[0], coords[1], ret});
                cp.x = coords[0];
                cp.y = coords[1];
            }
            if (ret == 0) {
                sp.x = cp.x = coords[0];
                sp.y = cp.y = coords[1];
            }
            if (ret == 3) {
                c2 = this.calcCube(coords, cp);
                totalDist += c2;
                segStack.add(new float[]{c2, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], ret});
                cp.x = coords[4];
                cp.y = coords[5];
            }
            if (ret == 2) {
                c2 = this.calcLengthOfQuad(coords, cp);
                totalDist += c2;
                segStack.add(new float[]{c2, coords[0], coords[1], 0.0f, 0.0f, coords[2], coords[3], ret});
                cp.x = coords[2];
                cp.y = coords[3];
            }
            pi.next();
        } while (!pi.isDone());
        float nxtP = totalDist / (float)this.getPoints();
        ArrayList<Point2D.Float> pList = new ArrayList<Point2D.Float>();
        pList.add(new Point2D.Float(sp.x, sp.y));
        int sgIdx = 0;
        float[] sgmt = (float[])segStack.get(sgIdx);
        float len = sgmt[0];
        float travDist = nxtP;
        Point2D.Float center = new Point2D.Float(sp.x, sp.y);
        for (i2 = 1; i2 < this.getPoints(); ++i2) {
            while (len < nxtP) {
                sp.x = sgmt[5];
                sp.y = sgmt[6];
                sgmt = (float[])segStack.get(++sgIdx);
                travDist = nxtP - len;
                len += sgmt[0];
            }
            len -= nxtP;
            Point2D.Float p2 = this.calcPoint(travDist, sp, sgmt, width, height);
            pList.add(p2);
            center.x += p2.x;
            center.y += p2.y;
            travDist += nxtP;
        }
        center.x = (float)width / 2.0f;
        center.y = (float)height / 2.0f;
        i2 = 0;
        g2.translate(center.x, center.y);
        for (Point2D.Float p3 : pList) {
            this.drawAt(g2, i2++, p3, center);
        }
        g2.translate(-center.x, -center.y);
        if (this.isPaintCentered()) {
            g2.translate(-tw / 2, -th / 2);
        }
    }

    public boolean isPaintCentered() {
        return this.paintCentered;
    }

    public void setPaintCentered(boolean paintCentered) {
        boolean old = this.isPaintCentered();
        this.paintCentered = paintCentered;
        this.firePropertyChange("paintCentered", old, this.isPaintCentered());
    }

    private void drawAt(Graphics2D g2, int i2, Point2D.Float p2, Point2D.Float c2) {
        g2.setColor(this.calcFrameColor(i2));
        this.paintRotatedCenteredShapeAtPoint(p2, c2, g2);
    }

    private void paintRotatedCenteredShapeAtPoint(Point2D.Float p2, Point2D.Float c2, Graphics2D g2) {
        Shape s2 = this.getPointShape();
        double hh = s2.getBounds().getHeight() / 2.0;
        double wh = s2.getBounds().getWidth() / 2.0;
        double a2 = c2.y - p2.y;
        double b2 = p2.x - c2.x;
        double sa = Math.signum(a2);
        double sb = Math.signum(b2);
        sa = sa == 0.0 ? 1.0 : sa;
        sb = sb == 0.0 ? 1.0 : sb;
        a2 = Math.abs(a2);
        b2 = Math.abs(b2);
        double t2 = Math.atan(a2 / b2);
        t2 = sa > 0.0 ? (sb > 0.0 ? -t2 : -Math.PI + t2) : (sb > 0.0 ? t2 : Math.PI - t2);
        double x2 = Math.sqrt(a2 * a2 + b2 * b2) - wh;
        double y2 = -hh;
        g2.rotate(t2);
        g2.translate(x2, y2);
        g2.fill(s2);
        g2.translate(-x2, -y2);
        g2.rotate(-t2);
    }

    private Point2D.Float calcPoint(float dist2go, Point2D.Float startPoint, float[] sgmt, int w2, int h2) {
        Point2D.Float f2 = new Point2D.Float();
        if (sgmt[7] == 1.0f) {
            float a2 = sgmt[5] - startPoint.x;
            float b2 = sgmt[6] - startPoint.y;
            float pathLen = sgmt[0];
            f2.x = startPoint.x + a2 * dist2go / pathLen;
            f2.y = startPoint.y + b2 * dist2go / pathLen;
        } else if (sgmt[7] == 2.0f) {
            Point2D.Float ctrl = new Point2D.Float(sgmt[1] / (float)w2, sgmt[2] / (float)h2);
            Point2D.Float end = new Point2D.Float(sgmt[5] / (float)w2, sgmt[6] / (float)h2);
            Point2D.Float start = new Point2D.Float(startPoint.x / (float)w2, startPoint.y / (float)h2);
            f2 = BusyPainter.getXY(dist2go / sgmt[0], start, ctrl, end);
            f2.x *= (float)w2;
            f2.y *= (float)h2;
        } else if (sgmt[7] == 3.0f) {
            float x2 = Math.abs(startPoint.x - sgmt[5]);
            float y2 = Math.abs(startPoint.y - sgmt[6]);
            float c1rx = Math.abs(startPoint.x - sgmt[1]) / x2;
            float c1ry = Math.abs(startPoint.y - sgmt[2]) / y2;
            float c2rx = Math.abs(startPoint.x - sgmt[3]) / x2;
            float c2ry = Math.abs(startPoint.y - sgmt[4]) / y2;
            f2 = this.getXY(dist2go / sgmt[0], c1rx, c1ry, c2rx, c2ry);
            float a3 = startPoint.x - sgmt[5];
            float b3 = startPoint.y - sgmt[6];
            f2.x = startPoint.x - f2.x * a3;
            f2.y = startPoint.y - f2.y * b3;
        }
        return f2;
    }

    private float calcLine(float[] coords, Point2D.Float cp) {
        float a2 = cp.x - coords[0];
        float b2 = cp.y - coords[1];
        float c2 = (float)Math.sqrt(a2 * a2 + b2 * b2);
        return c2;
    }

    private float calcCube(float[] coords, Point2D.Float cp) {
        float x2 = Math.abs(cp.x - coords[4]);
        float y2 = Math.abs(cp.y - coords[5]);
        float c1rx = Math.abs(cp.x - coords[0]) / x2;
        float c1ry = Math.abs(cp.y - coords[1]) / y2;
        float c2rx = Math.abs(cp.x - coords[2]) / x2;
        float c2ry = Math.abs(cp.y - coords[3]) / y2;
        float prevLength = 0.0f;
        float prevX = 0.0f;
        float prevY = 0.0f;
        for (float t2 = 0.01f; t2 <= 1.0f; t2 += 0.01f) {
            Point2D.Float xy = this.getXY(t2, c1rx, c1ry, c2rx, c2ry);
            prevLength += (float)Math.sqrt((xy.x - prevX) * (xy.x - prevX) + (xy.y - prevY) * (xy.y - prevY));
            prevX = xy.x;
            prevY = xy.y;
        }
        float z2 = (Math.abs(x2) + Math.abs(y2)) / 2.0f * prevLength;
        return z2;
    }

    private float calcLengthOfQuad(float[] coords, Point2D.Float cp) {
        Point2D.Float ctrl = new Point2D.Float(coords[0], coords[1]);
        Point2D.Float end = new Point2D.Float(coords[2], coords[3]);
        float c1ax = Math.abs(cp.x - ctrl.x);
        float c1ay = Math.abs(cp.y - ctrl.y);
        float e1ax = Math.abs(cp.x - end.x);
        float e1ay = Math.abs(cp.y - end.y);
        float maxX = Math.max(c1ax, e1ax);
        float maxY = Math.max(c1ay, e1ay);
        ctrl.x = c1ax / maxX;
        ctrl.y = c1ay / maxY;
        end.x = e1ax / maxX;
        end.y = e1ay / maxY;
        float prevLength = 0.0f;
        float prevX = 0.0f;
        float prevY = 0.0f;
        for (float t2 = 0.01f; t2 <= 1.0f; t2 += 0.01f) {
            Point2D.Float xy = BusyPainter.getXY(t2, new Point2D.Float(0.0f, 0.0f), ctrl, end);
            prevLength += (float)Math.sqrt((xy.x - prevX) * (xy.x - prevX) + (xy.y - prevY) * (xy.y - prevY));
            prevX = xy.x;
            prevY = xy.y;
        }
        float a2 = Math.abs(coords[2] - cp.x);
        float b2 = Math.abs(coords[3] - cp.y);
        float dist = (float)Math.sqrt(a2 * a2 + b2 * b2);
        return prevLength * dist;
    }

    private Point2D.Float getXY(float t2, float x1, float y1, float x2, float y2) {
        float invT = 1.0f - t2;
        float b1 = 3.0f * t2 * (invT * invT);
        float b2 = 3.0f * (t2 * t2) * invT;
        float b3 = t2 * t2 * t2;
        Point2D.Float xy = new Point2D.Float(b1 * x1 + b2 * x2 + b3, b1 * y1 + b2 * y2 + b3);
        return xy;
    }

    public static Point2D.Float getXY(float t2, Point2D.Float begin, Point2D.Float ctrl, Point2D.Float end) {
        float invT = 1.0f - t2;
        float b0 = invT * invT;
        float b1 = 2.0f * t2 * invT;
        float b2 = t2 * t2;
        Point2D.Float xy = new Point2D.Float(b0 * begin.x + b1 * ctrl.x + b2 * end.x, b0 * begin.y + b1 * ctrl.y + b2 * end.y);
        return xy;
    }

    private Color calcFrameColor(int i2) {
        if (this.frame == -1) {
            return this.getBaseColor();
        }
        for (int t2 = 0; t2 < this.getTrailLength(); ++t2) {
            if (this.direction == Direction.RIGHT && i2 == (this.frame - t2 + this.getPoints()) % this.getPoints()) {
                float terp = 1.0f - (float)(this.getTrailLength() - t2) / (float)this.getTrailLength();
                return PaintUtils.interpolate(this.getBaseColor(), this.getHighlightColor(), terp);
            }
            if (this.direction != Direction.LEFT || i2 != (this.frame + t2) % this.getPoints()) continue;
            float terp = (float)t2 / (float)this.getTrailLength();
            return PaintUtils.interpolate(this.getBaseColor(), this.getHighlightColor(), terp);
        }
        return this.getBaseColor();
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        int old = this.getFrame();
        this.frame = frame;
        this.firePropertyChange("frame", old, this.getFrame());
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color baseColor) {
        Color old = this.getBaseColor();
        this.baseColor = baseColor;
        this.firePropertyChange("baseColor", old, this.getBaseColor());
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        Color old = this.getHighlightColor();
        this.highlightColor = highlightColor;
        this.firePropertyChange("highlightColor", old, this.getHighlightColor());
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        int old = this.getPoints();
        this.points = points;
        this.firePropertyChange("points", old, this.getPoints());
    }

    public int getTrailLength() {
        return this.trailLength;
    }

    public void setTrailLength(int trailLength) {
        int old = this.getTrailLength();
        this.trailLength = trailLength;
        this.firePropertyChange("trailLength", old, this.getTrailLength());
    }

    public final Shape getPointShape() {
        return this.pointShape;
    }

    public final void setPointShape(Shape pointShape) {
        Shape old = this.getPointShape();
        this.pointShape = pointShape;
        this.firePropertyChange("pointShape", old, this.getPointShape());
    }

    public final Shape getTrajectory() {
        return this.trajectory;
    }

    public final void setTrajectory(Shape trajectory) {
        Shape old = this.getTrajectory();
        this.trajectory = trajectory;
        this.firePropertyChange("trajectory", old, this.getTrajectory());
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction dir) {
        Direction old = this.getDirection();
        this.direction = dir;
        this.firePropertyChange("direction", (Object)old, (Object)this.getDirection());
    }

    public static enum Direction {
        RIGHT,
        LEFT;

    }
}

