/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.PainterUtils;
import org.jdesktop.swingx.util.PaintUtils;

public class CheckerboardPainter
extends AbstractPainter<Object> {
    private transient Paint checkerPaint;
    private Paint darkPaint = new Color(204, 204, 204);
    private Paint lightPaint = Color.WHITE;
    private double squareSize = 8.0;

    public CheckerboardPainter() {
    }

    public CheckerboardPainter(Paint darkPaint, Paint lightPaint) {
        this(darkPaint, lightPaint, 8.0);
    }

    public CheckerboardPainter(Paint darkPaint, Paint lightPaint, double squareSize) {
        this.darkPaint = darkPaint;
        this.lightPaint = lightPaint;
        this.squareSize = squareSize;
    }

    public void setSquareSize(double squareSize) {
        if (squareSize <= 0.0) {
            throw new IllegalArgumentException("Length must be > 0");
        }
        double old = this.getSquareSize();
        this.squareSize = squareSize;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("squareSize", old, this.getSquareSize());
    }

    public double getSquareSize() {
        return this.squareSize;
    }

    public void setDarkPaint(Paint color) {
        Paint old = this.getDarkPaint();
        this.darkPaint = color;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("darkPaint", old, this.getDarkPaint());
    }

    public Paint getDarkPaint() {
        return this.darkPaint;
    }

    public void setLightPaint(Paint color) {
        Paint old = this.getLightPaint();
        this.lightPaint = color;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("lightPaint", old, this.getLightPaint());
    }

    public Paint getLightPaint() {
        return this.lightPaint;
    }

    private Paint getCheckerPaint(Object c2) {
        if (this.checkerPaint == null) {
            Paint p1 = PainterUtils.getForegroundPaint(this.getLightPaint(), c2);
            Paint p2 = PainterUtils.getBackgroundPaint(this.getDarkPaint(), c2);
            this.checkerPaint = PaintUtils.getCheckerPaint(p1, p2, (int)(this.getSquareSize() * 2.0));
        }
        return this.checkerPaint;
    }

    @Override
    protected void doPaint(Graphics2D g2, Object t2, int width, int height) {
        g2.setPaint(this.getCheckerPaint(t2));
        g2.fillRect(0, 0, width, height);
    }
}

