/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.PainterUtils;

public class PinstripePainter
extends AbstractPainter<Object> {
    private double angle;
    private double spacing;
    private double stripeWidth;
    private Paint paint;

    public PinstripePainter() {
        this(null);
    }

    public PinstripePainter(Paint paint) {
        this(paint, 45.0);
    }

    public PinstripePainter(double angle) {
        this(null, angle);
    }

    public PinstripePainter(Paint paint, double angle) {
        this(paint, angle, 1.0, 8.0);
    }

    public PinstripePainter(Paint paint, double angle, double stripeWidth, double spacing) {
        this.paint = paint;
        this.angle = angle;
        this.stripeWidth = stripeWidth;
        this.spacing = spacing;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint p2) {
        Paint old = this.getPaint();
        this.paint = p2;
        this.firePropertyChange("paint", old, this.getPaint());
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        if (angle > 360.0) {
            angle %= 360.0;
        }
        if (angle < 0.0) {
            angle = 360.0 - angle * -1.0 % 360.0;
        }
        double old = this.getAngle();
        this.angle = angle;
        this.firePropertyChange("angle", old, this.getAngle());
    }

    public double getStripeWidth() {
        return this.stripeWidth;
    }

    public void setStripeWidth(double stripeWidth) {
        double oldSripeWidth = this.getStripeWidth();
        this.stripeWidth = stripeWidth;
        this.firePropertyChange("stripeWidth", oldSripeWidth, this.getStripeWidth());
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(double spacing) {
        double old = this.getSpacing();
        this.spacing = spacing;
        this.firePropertyChange("spacing", old, this.getSpacing());
    }

    @Override
    protected void doPaint(Graphics2D g2, Object component, int width, int height) {
        Shape newClip;
        Shape oldClip = g2.getClip();
        if (oldClip == null) {
            newClip = new Rectangle(width, height);
        } else {
            Rectangle r2 = oldClip.getBounds();
            r2.width = width;
            r2.height = height;
            Area a2 = new Area(r2);
            a2.intersect(new Area(oldClip));
            newClip = a2;
        }
        int startX = newClip.getBounds().x;
        int startY = newClip.getBounds().y;
        g2.setClip(newClip);
        g2.setPaint(PainterUtils.getForegroundPaint(this.getPaint(), component));
        g2.setStroke(new BasicStroke((float)this.getStripeWidth()));
        g2.rotate(Math.toRadians(this.getAngle()));
        double hypLength = Math.hypot(width, height);
        double gap = this.getSpacing() + this.getStripeWidth();
        int numLines = (int)Math.round(hypLength / gap);
        for (int i2 = 0; i2 < numLines; ++i2) {
            double x2 = (double)i2 * gap;
            g2.draw(new Line2D.Double((double)startX + x2, (double)startY - hypLength, (double)startX + x2, (double)startY + hypLength));
        }
        g2.setClip(oldClip);
    }
}

