/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.plaf.PromptTextUI;
import org.jdesktop.swingx.search.NativeSearchFieldSupport;
import org.jdesktop.swingx.util.OS;

public class PromptTextFieldUI
extends PromptTextUI {
    public PromptTextFieldUI(TextUI delegate) {
        super(delegate);
    }

    @Override
    public JTextComponent getPromptComponent(JTextComponent txt) {
        LabelField lbl = (LabelField)super.getPromptComponent(txt);
        JTextField txtField = (JTextField)txt;
        lbl.setHorizontalAlignment(txtField.getHorizontalAlignment());
        lbl.setColumns(txtField.getColumns());
        lbl.hasFocus = txtField.hasFocus() && NativeSearchFieldSupport.isNativeSearchField(txtField);
        NativeSearchFieldSupport.setSearchField(lbl, NativeSearchFieldSupport.isSearchField(txtField));
        NativeSearchFieldSupport.setFindPopupMenu(lbl, NativeSearchFieldSupport.getFindPopupMenu(txtField));
        Border b2 = txt.getBorder();
        if (b2 == null) {
            lbl.setBorder(txt.getBorder());
        } else {
            Insets insets = b2.getBorderInsets(txt);
            lbl.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        }
        return lbl;
    }

    @Override
    protected JTextComponent createPromptComponent() {
        return new LabelField();
    }

    private static final class LabelField
    extends JTextField {
        boolean hasFocus;

        private LabelField() {
        }

        @Override
        public boolean hasFocus() {
            return this.hasFocus;
        }

        @Override
        public void setToolTipText(String text) {
            this.putClientProperty("ToolTipText", text);
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x2, int y2, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r2) {
        }

        @Override
        public void repaint() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (OS.isMacOSX()) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            } else if ("document".equals(propertyName)) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            if (OS.isMacOSX()) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }
    }
}

