/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.SwingXUtilities;

public class BasicHyperlinkUI
extends BasicButtonUI {
    private static final Logger LOG = Logger.getLogger(BasicHyperlinkUI.class.getName());
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    private Color focusColor;
    private View ulv;
    private PropertyChangeListener pcListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BasicHyperlinkUI.this.ulv = null;
        }
    };

    public static ComponentUI createUI(JComponent c2) {
        return new BasicHyperlinkUI();
    }

    @Override
    protected void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        JXHyperlink link = (JXHyperlink)b2;
        LookAndFeel.installProperty(b2, "opaque", false);
        if (SwingXUtilities.isUIInstallable(link.getUnclickedColor())) {
            link.setUnclickedColor(UIManager.getColor("Hyperlink.linkColor"));
        }
        if (SwingXUtilities.isUIInstallable(link.getClickedColor())) {
            link.setClickedColor(UIManager.getColor("Hyperlink.visitedColor"));
        }
        b2.setBorderPainted(false);
        b2.setRolloverEnabled(true);
        if (SwingXUtilities.isUIInstallable(b2.getBorder())) {
            b2.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder(0, 1, 0, 0)));
        }
        this.dashedRectGapX = UIManager.getInt("ButtonUI.dashedRectGapX");
        this.dashedRectGapY = UIManager.getInt("ButtonUI.dashedRectGapY");
        this.dashedRectGapWidth = UIManager.getInt("ButtonUI.dashedRectGapWidth");
        this.dashedRectGapHeight = UIManager.getInt("ButtonUI.dashedRectGapHeight");
        this.focusColor = UIManager.getColor("ButtonUI.focus");
        b2.setHorizontalAlignment(10);
    }

    @Override
    protected void installListeners(AbstractButton b2) {
        super.installListeners(b2);
        b2.addPropertyChangeListener(this.pcListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b2) {
        super.uninstallListeners(b2);
        b2.removePropertyChangeListener(this.pcListener);
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        ButtonModel model = b2.getModel();
        FontMetrics fm = g2.getFontMetrics();
        Insets i2 = c2.getInsets();
        BasicHyperlinkUI.viewRect.x = i2.left;
        BasicHyperlinkUI.viewRect.y = i2.top;
        BasicHyperlinkUI.viewRect.width = b2.getWidth() - (i2.right + BasicHyperlinkUI.viewRect.x);
        BasicHyperlinkUI.viewRect.height = b2.getHeight() - (i2.bottom + BasicHyperlinkUI.viewRect.y);
        BasicHyperlinkUI.textRect.height = 0;
        BasicHyperlinkUI.textRect.width = 0;
        BasicHyperlinkUI.textRect.y = 0;
        BasicHyperlinkUI.textRect.x = 0;
        BasicHyperlinkUI.iconRect.height = 0;
        BasicHyperlinkUI.iconRect.width = 0;
        BasicHyperlinkUI.iconRect.y = 0;
        BasicHyperlinkUI.iconRect.x = 0;
        Font f2 = c2.getFont();
        g2.setFont(f2);
        String text = SwingUtilities.layoutCompoundLabel(c2, fm, b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : b2.getIconTextGap());
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g2, b2);
        }
        if (b2.getIcon() != null) {
            this.paintIcon(g2, c2, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v2 = (View)c2.getClientProperty("html");
            if (v2 != null) {
                this.paintHTMLText(g2, b2, textRect, text, v2);
            } else {
                this.paintText(g2, b2, textRect, text);
            }
        }
        if (b2.isFocusPainted() && b2.hasFocus()) {
            this.paintFocus(g2, b2, viewRect, textRect, iconRect);
        }
    }

    protected void paintHTMLText(Graphics g2, AbstractButton b2, Rectangle textRect, String text, View v2) {
        textRect.x += this.getTextShiftOffset();
        textRect.y += this.getTextShiftOffset();
        if (b2.getModel().isRollover()) {
            if (this.ulv == null) {
                this.ulv = ULHtml.createHTMLView(b2, text);
            }
            this.ulv.paint(g2, textRect);
        } else {
            v2.paint(g2, textRect);
        }
        textRect.x -= this.getTextShiftOffset();
        textRect.y -= this.getTextShiftOffset();
    }

    @Override
    protected void paintText(Graphics g2, AbstractButton b2, Rectangle textRect, String text) {
        if (!b2.getModel().isEnabled()) {
            ++textRect.x;
        }
        super.paintText(g2, b2, textRect, text);
        if (b2.getModel().isRollover()) {
            this.paintUnderline(g2, b2, textRect, text);
        }
    }

    private void paintUnderline(Graphics g2, AbstractButton b2, Rectangle rect, String text) {
        FontMetrics fm = g2.getFontMetrics();
        int descent = fm.getDescent();
        g2.drawLine(rect.x + this.getTextShiftOffset(), rect.y + rect.height - descent + 1 + this.getTextShiftOffset(), rect.x + rect.width + this.getTextShiftOffset(), rect.y + rect.height - descent + 1 + this.getTextShiftOffset());
    }

    @Override
    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b2.getParent() instanceof JToolBar) {
            return;
        }
        g2.setColor(this.getFocusColor());
        Rectangle iconTextRect = this.getIconTextRect(b2);
        BasicGraphicsUtils.drawDashedRect(g2, iconTextRect.x, iconTextRect.y, iconTextRect.width, iconTextRect.height);
    }

    @Override
    protected void paintButtonPressed(Graphics g2, AbstractButton b2) {
        this.setTextShiftOffset();
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b2) {
        return new BasicHyperlinkListener(b2);
    }

    @Override
    public boolean contains(JComponent c2, int x2, int y2) {
        AbstractButton button = (AbstractButton)c2;
        return this.isInside(this.getIconTextRect(button), x2, y2);
    }

    private boolean isInside(Rectangle iconTextRect, int x2, int y2) {
        if (iconTextRect == null) {
            return false;
        }
        return iconTextRect.contains(x2, y2);
    }

    protected Rectangle getIconTextRect(AbstractButton b2) {
        if (b2.getComponentCount() > 0) {
            return null;
        }
        Icon icon = b2.getIcon();
        String text = b2.getText();
        Font font = b2.getFont();
        FontMetrics fm = b2.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(b2.getSize());
        SwingUtilities.layoutCompoundLabel(b2, fm, text, icon, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : b2.getIconTextGap());
        Rectangle r2 = iconR.union(textR);
        Insets insets = b2.getInsets();
        r2.width += insets.left + insets.right;
        r2.height += insets.top + insets.bottom;
        r2.y -= insets.top;
        return r2;
    }

    static class ULHtml
    extends BasicHTML {
        private static BasicEditorKit basicHTMLFactory;
        private static ViewFactory basicHTMLViewFactory;
        private static final String styleChanges = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }font {text-decoration: underline}";

        ULHtml() {
        }

        public static View createHTMLView(JComponent c2, String html) {
            BasicEditorKit kit = ULHtml.getFactory();
            Document doc = kit.createDefaultDocument(c2.getFont(), c2.getForeground());
            Object base = c2.getClientProperty("html.base");
            if (base instanceof URL) {
                ((HTMLDocument)doc).setBase((URL)base);
            }
            StringReader r2 = new StringReader(html);
            try {
                kit.read(r2, doc, 0);
            }
            catch (Throwable e2) {
                // empty catch block
            }
            ViewFactory f2 = kit.getViewFactory();
            View hview = f2.create(doc.getDefaultRootElement());
            Renderer v2 = new Renderer(c2, f2, hview);
            return v2;
        }

        static BasicEditorKit getFactory() {
            if (basicHTMLFactory == null) {
                basicHTMLViewFactory = new BasicHTMLViewFactory();
                basicHTMLFactory = new BasicEditorKit();
            }
            return basicHTMLFactory;
        }

        static class Renderer
        extends View {
            private int width;
            private View view;
            private ViewFactory factory;
            private JComponent host;

            Renderer(JComponent c2, ViewFactory f2, View v2) {
                super(null);
                this.host = c2;
                this.factory = f2;
                this.view = v2;
                this.view.setParent(this);
                this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
            }

            @Override
            public AttributeSet getAttributes() {
                return null;
            }

            @Override
            public float getPreferredSpan(int axis) {
                if (axis == 0) {
                    return this.width;
                }
                return this.view.getPreferredSpan(axis);
            }

            @Override
            public float getMinimumSpan(int axis) {
                return this.view.getMinimumSpan(axis);
            }

            @Override
            public float getMaximumSpan(int axis) {
                return 2.1474836E9f;
            }

            @Override
            public void preferenceChanged(View child, boolean width, boolean height) {
                this.host.revalidate();
                this.host.repaint();
            }

            @Override
            public float getAlignment(int axis) {
                return this.view.getAlignment(axis);
            }

            @Override
            public void paint(Graphics g2, Shape allocation) {
                Rectangle alloc = allocation.getBounds();
                this.view.setSize(alloc.width, alloc.height);
                this.view.paint(g2, allocation);
            }

            @Override
            public void setParent(View parent) {
                throw new Error("Can't set parent on root view");
            }

            @Override
            public int getViewCount() {
                return 1;
            }

            @Override
            public View getView(int n2) {
                return this.view;
            }

            @Override
            public Shape modelToView(int pos, Shape a2, Position.Bias b2) throws BadLocationException {
                return this.view.modelToView(pos, a2, b2);
            }

            @Override
            public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a2) throws BadLocationException {
                return this.view.modelToView(p0, b0, p1, b1, a2);
            }

            @Override
            public int viewToModel(float x2, float y2, Shape a2, Position.Bias[] bias) {
                return this.view.viewToModel(x2, y2, a2, bias);
            }

            @Override
            public Document getDocument() {
                return this.view.getDocument();
            }

            @Override
            public int getStartOffset() {
                return this.view.getStartOffset();
            }

            @Override
            public int getEndOffset() {
                return this.view.getEndOffset();
            }

            @Override
            public Element getElement() {
                return this.view.getElement();
            }

            @Override
            public void setSize(float width, float height) {
                this.width = (int)width;
                this.view.setSize(width, height);
            }

            @Override
            public Container getContainer() {
                return this.host;
            }

            @Override
            public ViewFactory getViewFactory() {
                return this.factory;
            }
        }

        static class BasicDocument
        extends HTMLDocument {
            private static Class<?> clz;
            private static Method displayPropertiesToCSS;

            private static String displayPropertiesToCSS(Font f2, Color c2) {
                try {
                    return (String)displayPropertiesToCSS.invoke(null, f2, c2);
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }

            BasicDocument(StyleSheet s2, Font defaultFont, Color foreground) {
                super(s2);
                this.setPreservesUnknownTags(false);
                this.setFontAndColor(defaultFont, foreground);
            }

            private void setFontAndColor(Font font, Color fg) {
                this.getStyleSheet().addRule(BasicDocument.displayPropertiesToCSS(font, fg));
            }

            static {
                String j5 = "com.sun.java.swing.SwingUtilities2";
                String j6 = "sun.swing.SwingUtilities2";
                try {
                    clz = Class.forName(j6);
                }
                catch (ClassNotFoundException e2) {
                    try {
                        clz = Class.forName(j5);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new RuntimeException("Failed to find SwingUtilities2. Check the classpath.");
                    }
                }
                try {
                    displayPropertiesToCSS = clz.getMethod("displayPropertiesToCSS", Font.class, Color.class);
                }
                catch (Exception e3) {
                    throw new RuntimeException("Failed to use SwingUtilities2. Check the permissions and class version.");
                }
            }
        }

        static class BasicHTMLViewFactory
        extends HTMLEditorKit.HTMLFactory {
            BasicHTMLViewFactory() {
            }

            @Override
            public View create(Element elem) {
                View view = super.create(elem);
                if (view instanceof ImageView) {
                    ((ImageView)view).setLoadsSynchronously(true);
                }
                return view;
            }
        }

        static class BasicEditorKit
        extends HTMLEditorKit {
            private static StyleSheet defaultStyles;

            BasicEditorKit() {
            }

            @Override
            public StyleSheet getStyleSheet() {
                if (defaultStyles == null) {
                    defaultStyles = new StyleSheet();
                    StringReader r2 = new StringReader(ULHtml.styleChanges);
                    try {
                        defaultStyles.loadRules(r2, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    r2.close();
                    defaultStyles.addStyleSheet(super.getStyleSheet());
                }
                return defaultStyles;
            }

            public Document createDefaultDocument(Font defaultFont, Color foreground) {
                StyleSheet styles = this.getStyleSheet();
                StyleSheet ss = new StyleSheet();
                ss.addStyleSheet(styles);
                BasicDocument doc = new BasicDocument(ss, defaultFont, foreground);
                doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
                doc.setPreservesUnknownTags(false);
                return doc;
            }

            @Override
            public ViewFactory getViewFactory() {
                return basicHTMLViewFactory;
            }
        }
    }

    public static class BasicHyperlinkListener
    extends BasicButtonListener {
        public BasicHyperlinkListener(AbstractButton b2) {
            super(b2);
        }

        @Override
        public void stateChanged(ChangeEvent e2) {
            AbstractButton button = (AbstractButton)e2.getSource();
            if (button.isRolloverEnabled()) {
                button.setCursor(button.getModel().isRollover() ? Cursor.getPredefinedCursor(12) : null);
            }
            super.stateChanged(e2);
        }
    }
}

