/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.plaf.TitledPanelUI;

public class BasicTitledPanelUI
extends TitledPanelUI {
    private static final Logger LOG = Logger.getLogger(BasicTitledPanelUI.class.getName());
    protected JLabel caption;
    protected JXPanel topPanel;
    protected PropertyChangeListener titleChangeListener;
    protected JComponent left;
    protected JComponent right;

    public static ComponentUI createUI(JComponent c2) {
        return new BasicTitledPanelUI();
    }

    @Override
    public void installUI(JComponent c2) {
        assert (c2 instanceof JXTitledPanel);
        JXTitledPanel titledPanel = (JXTitledPanel)c2;
        this.installDefaults(titledPanel);
        this.caption = this.createAndConfigureCaption(titledPanel);
        this.topPanel = this.createAndConfigureTopPanel(titledPanel);
        this.installComponents(titledPanel);
        this.installListeners(titledPanel);
    }

    protected void installDefaults(JXTitledPanel titledPanel) {
        this.installProperty(titledPanel, "titlePainter", UIManager.get("JXTitledPanel.titlePainter"));
        this.installProperty(titledPanel, "titleForeground", UIManager.getColor("JXTitledPanel.titleForeground"));
        this.installProperty(titledPanel, "titleFont", UIManager.getFont("JXTitledPanel.titleFont"));
        LookAndFeel.installProperty(titledPanel, "opaque", false);
    }

    protected void uninstallDefaults(JXTitledPanel titledPanel) {
    }

    protected void installComponents(JXTitledPanel titledPanel) {
        this.topPanel.add((Component)this.caption, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, this.getCaptionInsets(), 0, 0));
        if (titledPanel.getClientProperty("JXTitledPanel.rightDecoration") instanceof JComponent) {
            this.setRightDecoration((JComponent)titledPanel.getClientProperty("JXTitledPanel.rightDecoration"));
        }
        if (titledPanel.getClientProperty("JXTitledPanel.leftDecoration") instanceof JComponent) {
            this.setLeftDecoration((JComponent)titledPanel.getClientProperty("JXTitledPanel.leftDecoration"));
        }
        if (!(titledPanel.getLayout() instanceof BorderLayout)) {
            titledPanel.setLayout(new BorderLayout());
        }
        titledPanel.add((Component)this.topPanel, "North");
        if (SwingXUtilities.isUIInstallable(titledPanel.getBorder())) {
            titledPanel.setBorder(BorderUIResource.getRaisedBevelBorderUIResource());
        }
    }

    protected void uninstallComponents(JXTitledPanel titledPanel) {
        titledPanel.remove(this.topPanel);
    }

    protected Insets getCaptionInsets() {
        return UIManager.getInsets("JXTitledPanel.captionInsets");
    }

    protected JXPanel createAndConfigureTopPanel(JXTitledPanel titledPanel) {
        JXPanel topPanel = new JXPanel();
        topPanel.setBackgroundPainter(titledPanel.getTitlePainter());
        topPanel.setBorder(BorderFactory.createEmptyBorder());
        topPanel.setLayout(new GridBagLayout());
        topPanel.setOpaque(false);
        return topPanel;
    }

    protected JLabel createAndConfigureCaption(final JXTitledPanel titledPanel) {
        JLabel caption = new JLabel(titledPanel.getTitle()){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setForeground(titledPanel.getTitleForeground());
                this.setFont(titledPanel.getTitleFont());
            }
        };
        caption.setFont(titledPanel.getTitleFont());
        caption.setForeground(titledPanel.getTitleForeground());
        return caption;
    }

    @Override
    public void uninstallUI(JComponent c2) {
        assert (c2 instanceof JXTitledPanel);
        JXTitledPanel titledPanel = (JXTitledPanel)c2;
        this.uninstallListeners(titledPanel);
        this.topPanel.removeAll();
        titledPanel.remove(this.topPanel);
        titledPanel.putClientProperty("JXTitledPanel.leftDecoration", this.left);
        titledPanel.putClientProperty("JXTitledPanel.rightDecoration", this.right);
        this.caption = null;
        this.topPanel = null;
        titledPanel = null;
        this.left = null;
        this.right = null;
    }

    protected void installListeners(final JXTitledPanel titledPanel) {
        this.titleChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("title")) {
                    BasicTitledPanelUI.this.caption.setText((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("titleForeground")) {
                    BasicTitledPanelUI.this.caption.setForeground((Color)evt.getNewValue());
                } else if (evt.getPropertyName().equals("titleFont")) {
                    BasicTitledPanelUI.this.caption.setFont((Font)evt.getNewValue());
                } else if ("titlePainter".equals(evt.getPropertyName())) {
                    BasicTitledPanelUI.this.topPanel.setBackgroundPainter(titledPanel.getTitlePainter());
                    BasicTitledPanelUI.this.topPanel.repaint();
                }
            }
        };
        titledPanel.addPropertyChangeListener(this.titleChangeListener);
    }

    protected void uninstallListeners(JXTitledPanel titledPanel) {
        titledPanel.removePropertyChangeListener(this.titleChangeListener);
    }

    protected void installProperty(JComponent c2, String propName, Object value) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(c2.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                Method m4;
                Object oldVal;
                if (!pd.getName().equals(propName) || (oldVal = (m4 = pd.getReadMethod()).invoke((Object)c2, new Object[0])) != null && !(oldVal instanceof UIResource)) continue;
                m4 = pd.getWriteMethod();
                m4.invoke((Object)c2, value);
            }
        }
        catch (Exception e2) {
            LOG.log(Level.FINE, "Failed to install property " + propName, e2);
        }
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        super.paint(g2, c2);
    }

    @Override
    public void setRightDecoration(JComponent decoration) {
        if (this.right != null) {
            this.topPanel.remove(this.right);
        }
        this.right = decoration;
        if (this.right != null) {
            this.topPanel.add((Component)decoration, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, UIManager.getInsets("JXTitledPanel.rightDecorationInsets"), 0, 0));
        }
    }

    @Override
    public JComponent getRightDecoration() {
        return this.right;
    }

    @Override
    public void setLeftDecoration(JComponent decoration) {
        if (this.left != null) {
            this.topPanel.remove(this.left);
        }
        this.left = decoration;
        if (this.left != null) {
            this.topPanel.add((Component)this.left, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, UIManager.getInsets("JXTitledPanel.leftDecorationInsets"), 0, 0));
        }
    }

    @Override
    public JComponent getLeftDecoration() {
        return this.left;
    }

    @Override
    public Container getTitleBar() {
        return this.topPanel;
    }
}

