/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic.core;

import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.util.Contract;

public final class ListSortUI {
    private RowSorter<? extends ListModel> sorter;
    private JXList list;
    private ListSelectionModel modelSelection;
    private int modelLeadIndex;
    private boolean syncingSelection;
    private int[] lastModelSelection;
    private boolean sorterChanged;
    private boolean ignoreSortChange;
    private RowSorterListener sorterListener;

    public ListSortUI(JXList list, RowSorter<? extends ListModel> sorter) {
        this.sorter = Contract.asNotNull(sorter, "RowSorter must not be null");
        this.list = Contract.asNotNull(list, "list must not be null");
        if (sorter != list.getRowSorter()) {
            throw new IllegalStateException("sorter must be same as the one on list");
        }
        this.sorterListener = this.createRowSorterListener();
        sorter.addRowSorterListener(this.sorterListener);
    }

    public void dispose() {
        if (this.sorter != null) {
            this.sorter.removeRowSorterListener(this.sorterListener);
        }
        this.sorter = null;
        this.list = null;
    }

    public void modelChanged(ListDataEvent e2) {
        ModelChange change = new ModelChange(e2);
        this.prepareForChange(change);
        this.notifySorter(change);
        if (change.type != 0) {
            this.sorterChanged = true;
        }
        this.processChange(change);
    }

    public void viewSelectionChanged(ListSelectionEvent e2) {
        if (!this.syncingSelection && this.modelSelection != null) {
            this.modelSelection = null;
        }
    }

    protected void sortedChanged(RowSorterEvent e2) {
        this.sorterChanged = true;
        if (!this.ignoreSortChange) {
            this.prepareForChange(e2);
            this.processChange(null);
            this.list.invalidateCellSizeCache();
        }
    }

    private void prepareForChange(RowSorterEvent sortEvent) {
        Contract.asNotNull(sortEvent, "sorter event not null");
        if (this.modelSelection == null && this.sorter.getViewRowCount() != this.sorter.getModelRowCount()) {
            int modelIndex;
            this.modelSelection = new DefaultListSelectionModel();
            ListSelectionModel viewSelection = this.getViewSelectionModel();
            int min2 = viewSelection.getMinSelectionIndex();
            int max = viewSelection.getMaxSelectionIndex();
            for (int viewIndex = min2; viewIndex <= max; ++viewIndex) {
                if (!viewSelection.isSelectedIndex(viewIndex) || (modelIndex = this.convertRowIndexToModel(sortEvent, viewIndex)) == -1) continue;
                this.modelSelection.addSelectionInterval(modelIndex, modelIndex);
            }
            modelIndex = this.convertRowIndexToModel(sortEvent, viewSelection.getLeadSelectionIndex());
            SwingXUtilities.setLeadAnchorWithoutSelection(this.modelSelection, modelIndex, modelIndex);
        } else if (this.modelSelection == null) {
            this.cacheModelSelection(sortEvent);
        }
    }

    private void prepareForChange(ModelChange change) {
        Contract.asNotNull(change, "table event not null");
        if (change.allRowsChanged) {
            this.modelSelection = null;
        } else if (this.modelSelection != null) {
            switch (change.type) {
                case 2: {
                    this.modelSelection.removeIndexInterval(change.startModelIndex, change.endModelIndex);
                    break;
                }
                case 1: {
                    this.modelSelection.insertIndexInterval(change.startModelIndex, change.length, true);
                    break;
                }
            }
        } else {
            this.cacheModelSelection(null);
        }
    }

    private void cacheModelSelection(RowSorterEvent sortEvent) {
        this.lastModelSelection = this.convertSelectionToModel(sortEvent);
        this.modelLeadIndex = this.convertRowIndexToModel(sortEvent, this.getViewSelectionModel().getLeadSelectionIndex());
    }

    private void processChange(ModelChange change) {
        if (change != null && change.allRowsChanged) {
            this.allChanged();
            this.getViewSelectionModel().clearSelection();
        } else if (this.sorterChanged) {
            this.restoreSelection(change);
        }
    }

    private void restoreSelection(ModelChange change) {
        this.syncingSelection = true;
        if (this.lastModelSelection != null) {
            this.restoreSortingSelection(this.lastModelSelection, this.modelLeadIndex, change);
            this.lastModelSelection = null;
        } else if (this.modelSelection != null) {
            ListSelectionModel viewSelection = this.getViewSelectionModel();
            viewSelection.setValueIsAdjusting(true);
            viewSelection.clearSelection();
            int min2 = this.modelSelection.getMinSelectionIndex();
            int max = this.modelSelection.getMaxSelectionIndex();
            for (int modelIndex = min2; modelIndex <= max; ++modelIndex) {
                int viewIndex;
                if (!this.modelSelection.isSelectedIndex(modelIndex) || (viewIndex = this.sorter.convertRowIndexToView(modelIndex)) == -1) continue;
                viewSelection.addSelectionInterval(viewIndex, viewIndex);
            }
            int viewLeadIndex = this.modelSelection.getLeadSelectionIndex();
            if (viewLeadIndex != -1) {
                viewLeadIndex = this.sorter.convertRowIndexToView(viewLeadIndex);
            }
            SwingXUtilities.setLeadAnchorWithoutSelection(viewSelection, viewLeadIndex, viewLeadIndex);
            viewSelection.setValueIsAdjusting(false);
        }
        this.syncingSelection = false;
    }

    private void restoreSortingSelection(int[] selection, int lead, ModelChange change) {
        for (int i2 = selection.length - 1; i2 >= 0; --i2) {
            selection[i2] = this.convertRowIndexToView(change, selection[i2]);
        }
        lead = this.convertRowIndexToView(change, lead);
        if (selection.length == 0 || selection.length == 1 && selection[0] == this.list.getSelectedIndex()) {
            return;
        }
        ListSelectionModel selectionModel = this.getViewSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        for (int i3 = selection.length - 1; i3 >= 0; --i3) {
            if (selection[i3] == -1) continue;
            selectionModel.addSelectionInterval(selection[i3], selection[i3]);
        }
        SwingXUtilities.setLeadAnchorWithoutSelection(selectionModel, lead, lead);
        selectionModel.setValueIsAdjusting(false);
    }

    private int convertRowIndexToView(ModelChange change, int modelIndex) {
        if (modelIndex < 0) {
            return -1;
        }
        if (change != null && modelIndex >= change.startModelIndex) {
            if (change.type == 1) {
                if (modelIndex + change.length >= change.modelRowCount) {
                    return -1;
                }
                return this.sorter.convertRowIndexToView(modelIndex + change.length);
            }
            if (change.type == 2) {
                if (modelIndex <= change.endModelIndex) {
                    return -1;
                }
                if (modelIndex - change.length >= change.modelRowCount) {
                    return -1;
                }
                return this.sorter.convertRowIndexToView(modelIndex - change.length);
            }
        }
        if (modelIndex >= this.sorter.getModelRowCount()) {
            return -1;
        }
        return this.sorter.convertRowIndexToView(modelIndex);
    }

    private int convertRowIndexToModel(RowSorterEvent e2, int viewIndex) {
        if (e2 != null) {
            if (e2.getPreviousRowCount() == 0) {
                return viewIndex;
            }
            return e2.convertPreviousRowIndexToModel(viewIndex);
        }
        if (viewIndex < 0 || viewIndex >= this.sorter.getViewRowCount()) {
            return -1;
        }
        return this.sorter.convertRowIndexToModel(viewIndex);
    }

    private int[] convertSelectionToModel(RowSorterEvent e2) {
        int[] selection = this.list.getSelectedIndices();
        for (int i2 = selection.length - 1; i2 >= 0; --i2) {
            selection[i2] = this.convertRowIndexToModel(e2, selection[i2]);
        }
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifySorter(ModelChange change) {
        try {
            this.ignoreSortChange = true;
            this.sorterChanged = false;
            if (change.allRowsChanged) {
                this.sorter.allRowsChanged();
                return;
            }
            switch (change.type) {
                case 0: {
                    this.sorter.rowsUpdated(change.startModelIndex, change.endModelIndex);
                    return;
                }
                case 1: {
                    this.sorter.rowsInserted(change.startModelIndex, change.endModelIndex);
                    return;
                }
                case 2: {
                    this.sorter.rowsDeleted(change.startModelIndex, change.endModelIndex);
                    return;
                }
            }
            return;
        }
        finally {
            this.ignoreSortChange = false;
        }
    }

    private ListSelectionModel getViewSelectionModel() {
        return this.list.getSelectionModel();
    }

    private void allChanged() {
        this.modelLeadIndex = -1;
        this.modelSelection = null;
    }

    protected RowSorterListener createRowSorterListener() {
        RowSorterListener l2 = new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e2) {
                if (e2.getType() == RowSorterEvent.Type.SORTED) {
                    ListSortUI.this.sortedChanged(e2);
                }
            }
        };
        return l2;
    }

    static final class ModelChange {
        int startModelIndex;
        int endModelIndex;
        int length;
        int type;
        int modelRowCount;
        boolean allRowsChanged;

        public ModelChange(ListDataEvent e2) {
            this.type = e2.getType();
            this.modelRowCount = ((ListModel)e2.getSource()).getSize();
            this.startModelIndex = e2.getIndex0();
            this.endModelIndex = e2.getIndex1();
            this.allRowsChanged = this.startModelIndex < 0;
            this.length = this.allRowsChanged ? -1 : this.endModelIndex - this.startModelIndex + 1;
        }
    }
}

