/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import org.jdesktop.swingx.plaf.synth.SynthUI;

class SynthBorder
extends AbstractBorder
implements UIResource {
    private SynthUI ui;
    private Insets insets;

    SynthBorder(SynthUI ui, Insets insets) {
        this.ui = ui;
        this.insets = insets;
    }

    SynthBorder(SynthUI ui) {
        this(ui, null);
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        JComponent jc = (JComponent)c2;
        SynthContext context = this.ui.getContext(jc);
        SynthStyle style = context.getStyle();
        if (style == null) {
            assert (false) : "SynthBorder is being used outside after the UI has been uninstalled";
            return;
        }
        this.ui.paintBorder(context, g2, x2, y2, width, height);
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return this.getBorderInsets(c2, null);
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets insets) {
        if (this.insets != null) {
            if (insets == null) {
                insets = new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            } else {
                insets.top = this.insets.top;
                insets.bottom = this.insets.bottom;
                insets.left = this.insets.left;
                insets.right = this.insets.right;
            }
        } else if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 0;
            insets.top = 0;
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

