/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.TableUtilities;

public class TableRowHeightController {
    private JTable table;
    private TableModelListener tableModelListener;
    private PropertyChangeListener tablePropertyListener;
    private static final Logger LOG = Logger.getLogger(TableRowHeightController.class.getName());

    public TableRowHeightController() {
        this(null);
    }

    public TableRowHeightController(JTable table) {
        this.install(table);
    }

    public void install(JTable table) {
        this.release();
        if (table != null) {
            this.table = table;
            this.installListeners();
            this.updatePreferredRowHeights();
        }
    }

    public void release() {
        if (this.table == null) {
            return;
        }
        this.uninstallListeners();
        this.table = null;
    }

    protected void updatePreferredRowHeights(int firstRow, int lastRow) {
        for (int row = firstRow; row <= lastRow; ++row) {
            int viewRow = this.table.convertRowIndexToView(row);
            if (viewRow < 0) continue;
            TableUtilities.setPreferredRowHeight(this.table, viewRow);
        }
    }

    protected void updatePreferredRowHeights() {
        if (this.table.getRowCount() == 0) {
            return;
        }
        this.updatePreferredRowHeights(0, this.table.getModel().getRowCount() - 1);
    }

    protected void updateModel(TableModel oldValue) {
        if (oldValue != null) {
            oldValue.removeTableModelListener(this.getTableModelListener());
        }
        this.table.getModel().addTableModelListener(this.getTableModelListener());
        this.updatePreferredRowHeights();
    }

    protected PropertyChangeListener createTablePropertyListener() {
        PropertyChangeListener l2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.invokedPropertyChanged(evt);
            }

            private void invokedPropertyChanged(final PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if ("model".equals(evt.getPropertyName())) {
                            TableRowHeightController.this.updateModel((TableModel)evt.getOldValue());
                        }
                    }
                });
            }
        };
        return l2;
    }

    protected TableModelListener createTableModelListener() {
        TableModelListener l2 = new TableModelListener(){

            @Override
            public void tableChanged(final TableModelEvent e2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.invokedTableChanged(e2);
                    }
                });
            }

            private void invokedTableChanged(TableModelEvent e2) {
                if (TableUtilities.isStructureChanged(e2) || TableUtilities.isDataChanged(e2)) {
                    TableRowHeightController.this.updatePreferredRowHeights();
                } else if (TableUtilities.isUpdate(e2) || TableUtilities.isInsert(e2)) {
                    TableRowHeightController.this.updatePreferredRowHeights(e2.getFirstRow(), e2.getLastRow());
                }
            }
        };
        return l2;
    }

    private void uninstallListeners() {
        this.table.removePropertyChangeListener(this.getPropertyChangeListener());
        this.table.getModel().removeTableModelListener(this.getTableModelListener());
    }

    private void installListeners() {
        this.table.addPropertyChangeListener(this.getPropertyChangeListener());
        this.table.getModel().addTableModelListener(this.getTableModelListener());
    }

    protected TableModelListener getTableModelListener() {
        if (this.tableModelListener == null) {
            this.tableModelListener = this.createTableModelListener();
        }
        return this.tableModelListener;
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        if (this.tablePropertyListener == null) {
            this.tablePropertyListener = this.createTablePropertyListener();
        }
        return this.tablePropertyListener;
    }
}

