/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class WindowUtils {
    private WindowUtils() {
    }

    private static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static boolean isUnowned(Window window) {
        return window.getOwner() == null || window instanceof JDialog && JOptionPane.getRootFrame().equals(window.getOwner());
    }

    private static Rectangle getUsableDeviceBounds(GraphicsConfiguration gc) {
        Rectangle bounds = gc.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    public static Point getPointForCentering(Window window) {
        Window w2 = window.isShowing() || WindowUtils.isUnowned(window) ? window : window.getOwner();
        GraphicsConfiguration gc = w2.getGraphicsConfiguration();
        Rectangle usableBounds = WindowUtils.getUsableDeviceBounds(gc);
        int screenWidth = usableBounds.width;
        int screenHeight = usableBounds.height;
        int width = window.getWidth();
        int height = window.getHeight();
        return new Point((screenWidth - width) / 2 + usableBounds.x, (screenHeight - height) / 2 + usableBounds.y);
    }

    public static Point getPointForCentering(JInternalFrame window) {
        Window w2 = SwingUtilities.getWindowAncestor(window);
        GraphicsConfiguration gc = w2 == null ? WindowUtils.getDefaultGraphicsConfiguration() : w2.getGraphicsConfiguration();
        Rectangle usableBounds = WindowUtils.getUsableDeviceBounds(gc);
        int screenWidth = usableBounds.width;
        int screenHeight = usableBounds.height;
        int width = window.getWidth();
        int height = window.getHeight();
        return new Point((screenWidth - width) / 2 + usableBounds.x, (screenHeight - height) / 2 + usableBounds.y);
    }

    public static Point getPointForStaggering(Window originWindow) {
        Point origin = originWindow.getLocation();
        Insets insets = originWindow.getInsets();
        origin.x += insets.top;
        origin.y += insets.top;
        return origin;
    }

    public static Window findWindow(Component c2) {
        if (c2 == null) {
            return JOptionPane.getRootFrame();
        }
        if (c2 instanceof Window) {
            return (Window)c2;
        }
        return WindowUtils.findWindow(c2.getParent());
    }

    public static List<Component> getAllComponents(Container c2) {
        Component[] comps = c2.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component comp : comps) {
            compList.add(comp);
            if (!(comp instanceof Container)) continue;
            compList.addAll(WindowUtils.getAllComponents((Container)comp));
        }
        return compList;
    }
}

