/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.anchor;

import java.awt.Image;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.AnchorShapeLocationResolver;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.anchor.ArrowAnchorShape;
import org.netbeans.modules.visual.anchor.AttachableAnchorShape;
import org.netbeans.modules.visual.anchor.DefaultAnchorShapeResolver;
import org.netbeans.modules.visual.anchor.ImageAnchorShape;
import org.netbeans.modules.visual.anchor.TriangleAnchorShape;

public class AnchorShapeFactory {
    private AnchorShapeFactory() {
    }

    public static AnchorShape createImageAnchorShape(Image image) {
        return AnchorShapeFactory.createImageAnchorShape(image, false);
    }

    public static AnchorShape createImageAnchorShape(Image image, boolean lineOriented) {
        return new ImageAnchorShape(image, lineOriented);
    }

    public static AnchorShape createTriangleAnchorShape(int size, boolean filled, boolean output) {
        return new TriangleAnchorShape(size, filled, output, false, 0.0);
    }

    public static AnchorShape createTriangleAnchorShape(int size, boolean filled, boolean output, int cutDistance) {
        return new TriangleAnchorShape(size, filled, output, false, cutDistance);
    }

    public static AnchorShape createArrowAnchorShape(int degrees2, int size) {
        return new ArrowAnchorShape(degrees2, size);
    }

    public static AnchorShape createAdjustableAnchorShape(AnchorShape shape, ConnectionWidget owner, ConnectionEnd referencingEnd, Widget attachedWidget) {
        AnchorShapeLocationResolver resolver = AnchorShapeFactory.createWidgetResolver(owner, referencingEnd, attachedWidget);
        return AnchorShapeFactory.createAdjustableAnchorShape(shape, resolver);
    }

    public static AnchorShape createAdjustableAnchorShape(AnchorShape shape, AnchorShapeLocationResolver resolver) {
        return new AttachableAnchorShape(shape, resolver);
    }

    public static AnchorShapeLocationResolver createWidgetResolver(ConnectionWidget owner, ConnectionEnd referencingEnd, Widget attachedWidget) {
        return new DefaultAnchorShapeResolver(owner, referencingEnd, attachedWidget);
    }

    public static enum ConnectionEnd {
        SOURCE,
        TARGET;

    }
}

