/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.animator;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.animator.Animator;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.animator.ColorAnimator;
import org.netbeans.modules.visual.animator.PreferredBoundsAnimator;
import org.netbeans.modules.visual.animator.PreferredLocationAnimator;
import org.netbeans.modules.visual.animator.ZoomAnimator;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

public final class SceneAnimator {
    private static final long TIME_PERIOD = 500L;
    private static final int SLEEP = 16;
    private Scene scene;
    private final HashMap<Animator, Long> animators = new HashMap();
    private HashMap<Animator, Double> cache;
    private final Runnable task = new UpdateTask();
    private volatile boolean taskAlive;
    private PreferredLocationAnimator preferredLocationAnimator = new PreferredLocationAnimator(this);
    private PreferredBoundsAnimator preferredBoundsAnimator = new PreferredBoundsAnimator(this);
    private ZoomAnimator zoomAnimator = new ZoomAnimator(this);
    private ColorAnimator colorAnimator = new ColorAnimator(this);
    private static final RequestProcessor RP = new RequestProcessor(SceneAnimator.class.toString(), 50);

    public SceneAnimator(Scene scene) {
        this.scene = scene;
    }

    public Scene getScene() {
        return this.scene;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(Animator animator) {
        HashMap<Animator, Long> hashMap = this.animators;
        synchronized (hashMap) {
            this.animators.put(animator, System.currentTimeMillis());
            animator.reset();
            if (!this.taskAlive) {
                this.taskAlive = true;
                RP.post(this.task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRunning(Animator animator) {
        HashMap<Animator, Long> hashMap = this.animators;
        synchronized (hashMap) {
            if (this.animators.containsKey(animator)) {
                return true;
            }
            if (this.cache != null && this.cache.containsKey(animator)) {
                return true;
            }
        }
        return false;
    }

    public boolean isAnimatingPreferredLocation(Widget widget) {
        return this.isRunning(this.preferredLocationAnimator);
    }

    public void animatePreferredLocation(Widget widget, Point targetPreferredLocation) {
        this.preferredLocationAnimator.setPreferredLocation(widget, targetPreferredLocation);
    }

    public boolean isAnimatingPreferredBounds(Widget widget) {
        return this.isRunning(this.preferredBoundsAnimator);
    }

    public void animatePreferredBounds(Widget widget, Rectangle targetPreferredBounds) {
        this.preferredBoundsAnimator.setPreferredBounds(widget, targetPreferredBounds);
    }

    public boolean isAnimatingZoomFactor() {
        return this.isRunning(this.zoomAnimator);
    }

    public double getTargetZoomFactor() {
        return this.zoomAnimator.getTargetZoom();
    }

    public void animateZoomFactor(double targetZoomFactor) {
        this.zoomAnimator.setZoomFactor(targetZoomFactor);
    }

    public boolean isAnimatingBackgroundColor(Widget widget) {
        return this.isRunning(this.colorAnimator);
    }

    public void animateBackgroundColor(Widget widget, Color targetBackgroundColor) {
        this.colorAnimator.setBackgroundColor(widget, targetBackgroundColor);
    }

    public boolean isAnimatingForegroundColor(Widget widget) {
        return this.isRunning(this.colorAnimator);
    }

    public void animateForegroundColor(Widget widget, Color targetForegroundColor) {
        this.colorAnimator.setForegroundColor(widget, targetForegroundColor);
    }

    public Animator getPreferredLocationAnimator() {
        return this.preferredLocationAnimator;
    }

    public Animator getPreferredBoundsAnimator() {
        return this.preferredBoundsAnimator;
    }

    public Animator getZoomAnimator() {
        return this.zoomAnimator;
    }

    public Animator getColorAnimator() {
        return this.colorAnimator;
    }

    private class UpdateTask
    implements Runnable {
        private UpdateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap hashMap = SceneAnimator.this.animators;
            synchronized (hashMap) {
                long currentTime = System.currentTimeMillis();
                Set entries = SceneAnimator.this.animators.entrySet();
                SceneAnimator.this.cache = new HashMap();
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    double progress;
                    Map.Entry entry = iterator.next();
                    long diff = currentTime - (Long)entry.getValue();
                    if (diff < 0L || diff > 500L) {
                        iterator.remove();
                        progress = 1.0;
                    } else {
                        progress = (double)diff / 500.0;
                    }
                    SceneAnimator.this.cache.put((Animator)entry.getKey(), progress);
                }
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (Map.Entry entry : SceneAnimator.this.cache.entrySet()) {
                            ((Animator)entry.getKey()).performTick((Double)entry.getValue());
                        }
                        SceneAnimator.this.scene.validate();
                    }
                });
            }
            catch (InterruptedException e2) {
                ErrorManager.getDefault().notify(e2);
            }
            catch (InvocationTargetException e3) {
                ErrorManager.getDefault().notify(e3);
            }
            hashMap = SceneAnimator.this.animators;
            synchronized (hashMap) {
                SceneAnimator.this.cache = null;
                SceneAnimator.this.taskAlive = SceneAnimator.this.animators.size() > 0;
                if (SceneAnimator.this.taskAlive) {
                    RP.post(SceneAnimator.this.task, 16);
                }
            }
        }
    }
}

