/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;

public final class GridGraphLayout<N, E>
extends GraphLayout<N, E> {
    private boolean checker = false;
    private int horizontalGap = 64;
    private int verticalGap = 64;

    public GridGraphLayout<N, E> setChecker(boolean checker) {
        this.checker = checker;
        return this;
    }

    public GridGraphLayout<N, E> setGaps(int horizontalGap, int verticalGap) {
        this.horizontalGap = horizontalGap;
        this.verticalGap = verticalGap;
        return this;
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> graph) {
        int i2;
        Collection<N> allNodes = graph.getNodes();
        HashSet<N> unresolvedNodes = new HashSet<N>(allNodes);
        final HashMap node2connected = new HashMap();
        for (N node : unresolvedNodes) {
            N n2;
            HashSet<N> connected = new HashSet<N>();
            for (E edge : graph.findNodeEdges(node, true, false)) {
                n2 = graph.getEdgeTarget(edge);
                if (n2 == null) continue;
                connected.add(n2);
            }
            for (E edge : graph.findNodeEdges(node, false, true)) {
                n2 = graph.getEdgeSource(edge);
                if (n2 == null) continue;
                connected.add(n2);
            }
            node2connected.put(node, connected);
        }
        LinkedList queue = new LinkedList();
        HashMap node2grid = new HashMap();
        Rectangle gridBounds = new Rectangle();
        block3: while (true) {
            Object node;
            Object object = node = queue.isEmpty() ? GridGraphLayout.findNodeWithMaxEdges(unresolvedNodes, node2connected) : queue.poll();
            if (node == null) break;
            unresolvedNodes.remove(node);
            Point center = (Point)node2grid.get(node);
            if (center == null) {
                center = this.findCenter(node2grid);
                node2grid.put(node, center);
                gridBounds.add(center);
            }
            Point index = new Point();
            ArrayList connected = new ArrayList((Collection)node2connected.get(node));
            Collections.sort(connected, new Comparator<N>(){

                @Override
                public int compare(N node1, N node2) {
                    return ((Collection)node2connected.get(node1)).size() - ((Collection)node2connected.get(node2)).size();
                }
            });
            Iterator iterator = connected.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block3;
                Object conn = iterator.next();
                if (unresolvedNodes.contains(conn)) {
                    queue.offer(conn);
                }
                if (node2grid.containsKey(conn)) continue;
                Point grid = this.resolvePoint(node2grid, center, index);
                node2grid.put(conn, grid);
                gridBounds.add(grid);
            }
            break;
        }
        ObjectScene scene = graph.getScene();
        int[] xAxis = new int[gridBounds.width + 1];
        int[] yAxis = new int[gridBounds.height + 1];
        for (N node : allNodes) {
            Rectangle bounds;
            Widget widget = scene.findWidget(node);
            if (widget == null || (bounds = widget.getBounds()) == null) continue;
            Point grid = (Point)node2grid.get(node);
            xAxis[grid.x - gridBounds.x] = Math.max(xAxis[grid.x - gridBounds.x], bounds.width);
            yAxis[grid.y - gridBounds.y] = Math.max(yAxis[grid.y - gridBounds.y], bounds.height);
        }
        int pos = this.horizontalGap / 2;
        for (i2 = 0; i2 < xAxis.length; ++i2) {
            int add = xAxis[i2];
            xAxis[i2] = pos;
            pos += add + this.horizontalGap;
        }
        pos = this.verticalGap / 2;
        for (i2 = 0; i2 < yAxis.length; ++i2) {
            int add = yAxis[i2];
            yAxis[i2] = pos;
            pos += add + this.verticalGap;
        }
        for (N node : allNodes) {
            Rectangle bounds;
            Widget widget = scene.findWidget(node);
            if (widget == null || (bounds = widget.getBounds()) == null) continue;
            Point grid = (Point)node2grid.get(node);
            this.setResolvedNodeLocation(graph, node, new Point(xAxis[grid.x - gridBounds.x] - bounds.x, yAxis[grid.y - gridBounds.y]));
        }
    }

    private <N> Point resolvePoint(HashMap<N, Point> node2grid, Point center, Point index) {
        Point point;
        do {
            int max = 8 * index.y;
            ++index.x;
            if (index.x >= max) {
                ++index.y;
                index.x -= max;
            }
            point = GridGraphLayout.index2point(index);
            point.x += center.x;
            point.y += center.y;
        } while (this.checker && (point.x + point.y & 1) != 0 || GridGraphLayout.isOccupied(node2grid, point));
        return point;
    }

    private <N> Point findCenter(HashMap<N, Point> node2grid) {
        int add = this.checker ? 2 : 1;
        int x2 = 0;
        Point point;
        while (GridGraphLayout.isOccupied(node2grid, point = new Point(x2, 0))) {
            x2 += add;
        }
        return point;
    }

    private static Point index2point(Point index) {
        int indexPos = index.x;
        int indexLevel = index.y;
        if (indexPos < indexLevel) {
            return new Point(indexLevel, indexPos);
        }
        if (indexPos < 3 * indexLevel) {
            return new Point(indexLevel - (indexPos - indexLevel), indexLevel);
        }
        if (indexPos < 5 * indexLevel) {
            return new Point(-indexLevel, indexLevel - (indexPos - 3 * indexLevel));
        }
        if (indexPos < 7 * indexLevel) {
            return new Point(indexPos - 5 * indexLevel - indexLevel, -indexLevel);
        }
        if (indexPos < 8 * indexLevel) {
            return new Point(indexLevel, indexPos - 7 * indexLevel - indexLevel);
        }
        throw new InternalError("Index: " + indexPos);
    }

    private static <N> boolean isOccupied(HashMap<N, Point> node2grid, Point point) {
        for (Point p2 : node2grid.values()) {
            if (point.x != p2.x || point.y != p2.y) continue;
            return true;
        }
        return false;
    }

    private static <N> N findNodeWithMaxEdges(HashSet<N> unresolvedNodes, HashMap<N, Collection<N>> node2connected) {
        N bestNode = null;
        int bestCount = Integer.MIN_VALUE;
        for (N node : unresolvedNodes) {
            int i2 = node2connected.get(node).size();
            if (i2 <= bestCount) continue;
            bestNode = node;
            bestCount = i2;
        }
        return bestNode;
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> graph, Collection<N> nodes) {
        throw new UnsupportedOperationException();
    }
}

