/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.print;

import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.print.PageableScene;

public final class ScenePrinter {
    private ScenePrinter() {
    }

    public static void print(Scene scene) {
        ScenePrinter.print(scene, null, ScaleStrategy.NO_SCALING);
    }

    public static void print(Scene scene, PageFormat format) {
        ScenePrinter.print(scene, format, ScaleStrategy.NO_SCALING);
    }

    public static void print(Scene scene, ScaleStrategy scaleStrategy) {
        ScenePrinter.print(scene, null, scaleStrategy);
    }

    public static void print(Scene scene, double scaleX, double scaleY) {
        ScenePrinter.print(scene, null, ScaleStrategy.SCALE_PERCENT, scaleX, scaleY, false, false, null, null);
    }

    public static void print(Scene scene, PageFormat format, ScaleStrategy scaleStrategy) {
        ScenePrinter.print(scene, format, scaleStrategy, 1.0, 1.0, false, false, null, null);
    }

    public static void print(Scene scene, PageFormat format, Rectangle region) {
        ScenePrinter.print(scene, format, ScaleStrategy.NO_SCALING, 1.0, 1.0, false, false, region, null);
    }

    public static void print(Scene scene, PageFormat format, ScaleStrategy scaleStrategy, double scaleX, double scaleY, boolean selectedOnly, boolean visibleOnly, Rectangle region, List<LayerWidget> hiddenLayers) {
        if (scene == null) {
            return;
        }
        if (scaleStrategy == null) {
            scaleStrategy = ScaleStrategy.NO_SCALING;
        }
        PageableScene ps = new PageableScene(scene, format, scaleStrategy, scaleX, scaleY, selectedOnly, visibleOnly, region);
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable(ps);
        if (printJob.printDialog()) {
            try {
                ArrayList<Widget> hiddenWidgets = new ArrayList<Widget>();
                if (hiddenLayers != null && hiddenLayers.size() > 0) {
                    for (Widget widget : hiddenLayers) {
                        widget.setVisible(false);
                        hiddenWidgets.add(widget);
                    }
                }
                if (selectedOnly && scene instanceof ObjectScene) {
                    ObjectScene gScene = (ObjectScene)scene;
                    HashSet hashSet = new HashSet();
                    hashSet.addAll(gScene.getObjects());
                    Set<?> selectedObjects = gScene.getSelectedObjects();
                    hashSet.removeAll(selectedObjects);
                    for (Object o2 : hashSet) {
                        Widget widget = gScene.findWidget(o2);
                        if (widget == null || !widget.isVisible()) continue;
                        widget.setVisible(false);
                        hiddenWidgets.add(widget);
                    }
                }
                if (visibleOnly || region != null) {
                    if (region == null) {
                        region = scene.getView().getVisibleRect();
                    }
                    ArrayList<Widget> allWidgets = new ArrayList<Widget>();
                    for (Widget widget : scene.getChildren()) {
                        allWidgets.addAll(ScenePrinter.getAllNodeWidgets(widget, null));
                    }
                    for (Widget widget : allWidgets) {
                        Rectangle widgetInSceneCoordinates = widget.convertLocalToScene(widget.getBounds());
                        boolean included = region.contains(widgetInSceneCoordinates);
                        if (included || !widget.isVisible()) continue;
                        widget.setVisible(false);
                        hiddenWidgets.add(widget);
                    }
                }
                printJob.print();
                for (Widget widget : hiddenWidgets) {
                    widget.setVisible(true);
                }
                scene.validate();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    private static List<Widget> getAllNodeWidgets(Widget widget, List<Widget> widgetList) {
        if (widgetList == null) {
            widgetList = new ArrayList<Widget>();
        }
        if (widget instanceof LayerWidget && widget.getChildren().size() > 0) {
            widgetList.addAll(widget.getChildren());
            for (Widget child : widget.getChildren()) {
                ScenePrinter.getAllNodeWidgets(child, widgetList);
            }
        }
        return widgetList;
    }

    public static enum ScaleStrategy {
        SCALE_CURRENT_ZOOM,
        SCALE_PERCENT,
        SCALE_TO_FIT,
        SCALE_TO_FIT_X,
        SCALE_TO_FIT_Y,
        NO_SCALING;

    }
}

