/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ComponentWidget
extends Widget {
    private ComponentWrapper componentWrapper;
    private Component component;
    private boolean componentAdded;
    private boolean widgetAdded;
    private double zoomFactor = Double.MIN_VALUE;
    private ComponentSceneListener validateListener;
    private ComponentComponentListener componentListener;
    private boolean componentVisible = false;

    public ComponentWidget(Scene scene, Component component) {
        super(scene);
        this.componentWrapper = new ComponentWrapper();
        this.componentWrapper.setLayout(new BorderLayout(0, 0));
        this.componentWrapper.add(component);
        this.component = component;
        this.validateListener = null;
        this.componentListener = new ComponentComponentListener();
        this.setComponentVisible(true);
    }

    public final Component getComponent() {
        return this.component;
    }

    public final boolean isComponentVisible() {
        return this.componentVisible;
    }

    public final void setComponentVisible(boolean componentVisible) {
        if (this.componentVisible == componentVisible) {
            return;
        }
        this.componentVisible = componentVisible;
        this.attach();
        this.revalidate();
    }

    @Override
    protected final void notifyAdded() {
        this.widgetAdded = true;
        this.attach();
    }

    @Override
    protected final void notifyRemoved() {
        this.widgetAdded = false;
    }

    private void attach() {
        if (this.validateListener != null) {
            return;
        }
        this.validateListener = new ComponentSceneListener();
        this.getScene().addSceneListener(this.validateListener);
    }

    private void detach() {
        if (this.validateListener == null) {
            return;
        }
        this.getScene().removeSceneListener(this.validateListener);
        this.validateListener = null;
    }

    @Override
    protected final Rectangle calculateClientArea() {
        Dimension preferredSize = this.component.getPreferredSize();
        this.zoomFactor = this.getScene().getZoomFactor();
        preferredSize.width = (int)Math.floor((double)preferredSize.width / this.zoomFactor);
        preferredSize.height = (int)Math.floor((double)preferredSize.height / this.zoomFactor);
        return new Rectangle(preferredSize);
    }

    private void addComponent() {
        Scene scene = this.getScene();
        if (!this.componentAdded) {
            scene.getView().add(this.componentWrapper);
            scene.getView().revalidate();
            this.component.addComponentListener(this.componentListener);
            this.componentAdded = true;
        }
        this.component.removeComponentListener(this.componentListener);
        this.componentWrapper.setBounds(scene.convertSceneToView(this.convertLocalToScene(this.getClientArea())));
        this.component.addComponentListener(this.componentListener);
        this.component.repaint();
    }

    private void removeComponent() {
        Scene scene = this.getScene();
        if (this.componentAdded) {
            this.component.removeComponentListener(this.componentListener);
            scene.getView().remove(this.componentWrapper);
            scene.getView().revalidate();
            this.componentAdded = false;
        }
    }

    @Override
    protected final void paintWidget() {
        boolean isDoubleBuffered;
        RepaintManager rm = RepaintManager.currentManager(null);
        boolean bl = isDoubleBuffered = this.component instanceof JComponent && rm.isDoubleBufferingEnabled();
        if (isDoubleBuffered) {
            rm.setDoubleBufferingEnabled(false);
        }
        Graphics2D graphics = this.getGraphics();
        Rectangle bounds = this.getClientArea();
        AffineTransform previousTransform = graphics.getTransform();
        graphics.translate(bounds.x, bounds.y);
        double zoomFactor = this.getScene().getZoomFactor();
        graphics.scale(1.0 / zoomFactor, 1.0 / zoomFactor);
        if (this.componentVisible) {
            this.componentWrapper.doPaint(graphics);
        } else {
            this.component.paint(graphics);
        }
        graphics.setTransform(previousTransform);
        if (isDoubleBuffered) {
            rm.setDoubleBufferingEnabled(true);
        }
    }

    private final class ComponentComponentListener
    implements ComponentListener {
        private ComponentComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e2) {
            ComponentWidget.this.revalidate();
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
            ComponentWidget.this.revalidate();
        }

        @Override
        public void componentShown(ComponentEvent e2) {
        }

        @Override
        public void componentHidden(ComponentEvent e2) {
        }
    }

    private final class ComponentSceneListener
    implements Scene.SceneListener {
        private ComponentSceneListener() {
        }

        @Override
        public void sceneRepaint() {
        }

        @Override
        public void sceneValidating() {
            double newZoomFactor = ComponentWidget.this.getScene().getZoomFactor();
            if (Math.abs(newZoomFactor - ComponentWidget.this.zoomFactor) != 0.0) {
                ComponentWidget.this.revalidate();
                ComponentWidget.this.zoomFactor = newZoomFactor;
            }
        }

        @Override
        public void sceneValidated() {
            if (ComponentWidget.this.widgetAdded && ComponentWidget.this.componentVisible) {
                ComponentWidget.this.addComponent();
            } else {
                ComponentWidget.this.removeComponent();
                ComponentWidget.this.detach();
            }
        }
    }

    private static class ComponentWrapper
    extends JComponent {
        private ComponentWrapper() {
        }

        @Override
        public void paint(Graphics g2) {
        }

        void doPaint(Graphics g2) {
            super.paint(g2);
        }
    }
}

