/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.widget.ComponentWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class SwingScrollWidget
extends Widget {
    private static final int BAR_VERTICAL_SIZE = 16;
    private static final int BAR_HORIZONTAL_SIZE = 16;
    private Widget viewport;
    private Widget view;
    private ComponentWidget verticalWidget;
    private ComponentWidget horizontalWidget;
    private JScrollBar verticalScroll;
    private JScrollBar horizontalScroll;
    private AdjustmentListener verticalListener = new MyAdjustmentListener(true);
    private AdjustmentListener horizontalListener = new MyAdjustmentListener(false);

    public SwingScrollWidget(Scene scene) {
        super(scene);
        this.setLayout(new ScrollLayout());
        this.setCheckClipping(true);
        this.viewport = new Widget(scene);
        this.viewport.setCheckClipping(true);
        this.addChild(this.viewport);
        this.verticalScroll = new JScrollBar(1);
        this.verticalScroll.setUnitIncrement(16);
        this.verticalScroll.setBlockIncrement(64);
        this.verticalWidget = new ComponentWidget(scene, this.verticalScroll);
        this.horizontalScroll = new JScrollBar(0);
        this.horizontalScroll.setUnitIncrement(16);
        this.horizontalScroll.setBlockIncrement(64);
        this.horizontalWidget = new ComponentWidget(scene, this.horizontalScroll);
    }

    public SwingScrollWidget(Scene scene, Widget view) {
        this(scene);
        this.setView(view);
    }

    public final Widget getView() {
        return this.view;
    }

    public final void setView(Widget view) {
        if (this.view != null) {
            this.viewport.removeChild(this.view);
        }
        this.view = view;
        if (this.view != null) {
            this.viewport.addChild(this.view);
        }
    }

    @Override
    protected Rectangle calculateClientArea() {
        return new Rectangle(this.calculateSize());
    }

    private Dimension calculateSize() {
        Dimension maximumSize;
        if (this.isPreferredBoundsSet()) {
            Rectangle preferredBounds = this.getPreferredBounds();
            Insets insets = this.getBorder().getInsets();
            return new Dimension(preferredBounds.width - insets.left - insets.right, preferredBounds.height - insets.top - insets.bottom);
        }
        Dimension size = this.view.getBounds().getSize();
        Dimension minimumSize = this.getMinimumSize();
        if (minimumSize != null) {
            if (size.width < minimumSize.width) {
                size.width = minimumSize.width;
            }
            if (size.height < minimumSize.height) {
                size.height = minimumSize.height;
            }
        }
        if ((maximumSize = this.getMaximumSize()) != null) {
            if (size.width > maximumSize.width) {
                size.width = maximumSize.width;
            }
            if (size.height > maximumSize.height) {
                size.height = maximumSize.height;
            }
        }
        return size;
    }

    private class MyAdjustmentListener
    implements AdjustmentListener {
        private boolean vertical;

        private MyAdjustmentListener(boolean vertical) {
            this.vertical = vertical;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e2) {
            Point location = SwingScrollWidget.this.view.getLocation();
            if (this.vertical) {
                location.y = -SwingScrollWidget.this.verticalScroll.getValue();
            } else {
                location.x = -SwingScrollWidget.this.horizontalScroll.getValue();
            }
            SwingScrollWidget.this.view.setPreferredLocation(location);
            SwingScrollWidget.this.getScene().validate();
        }
    }

    private final class ScrollLayout
    implements Layout {
        private ScrollLayout() {
        }

        @Override
        public void layout(Widget widget) {
            Point scrollWidgetClientAreaLocation;
            if (SwingScrollWidget.this.isPreferredBoundsSet()) {
                scrollWidgetClientAreaLocation = SwingScrollWidget.this.getPreferredBounds().getLocation();
                Insets insets = SwingScrollWidget.this.getBorder().getInsets();
                scrollWidgetClientAreaLocation.translate(insets.left, insets.top);
            } else {
                scrollWidgetClientAreaLocation = new Point();
            }
            Rectangle viewBounds = SwingScrollWidget.this.view != null ? SwingScrollWidget.this.view.getPreferredBounds() : new Rectangle();
            Rectangle viewportBounds = SwingScrollWidget.this.view != null ? new Rectangle(SwingScrollWidget.this.view.getLocation(), SwingScrollWidget.this.calculateSize()) : new Rectangle();
            boolean showVertical = this.checkVertical(viewBounds, viewportBounds);
            boolean showHorizontal = this.checkHorizontal(viewBounds, viewportBounds);
            if (showVertical) {
                viewportBounds.width -= 16;
                showHorizontal = this.checkHorizontal(viewBounds, viewportBounds);
            }
            if (showHorizontal) {
                viewportBounds.height -= 16;
                if (!showVertical && (showVertical = this.checkVertical(viewBounds, viewportBounds))) {
                    viewportBounds.width -= 16;
                }
            }
            SwingScrollWidget.this.viewport.resolveBounds(scrollWidgetClientAreaLocation, new Rectangle(viewportBounds.getSize()));
            int x1 = scrollWidgetClientAreaLocation.x;
            int x2 = scrollWidgetClientAreaLocation.x + viewportBounds.width;
            int y1 = scrollWidgetClientAreaLocation.y;
            int y2 = scrollWidgetClientAreaLocation.y + viewportBounds.height;
            if (showVertical) {
                if (SwingScrollWidget.this.verticalWidget.getParentWidget() == null) {
                    SwingScrollWidget.this.addChild(SwingScrollWidget.this.verticalWidget);
                }
                SwingScrollWidget.this.verticalWidget.resolveBounds(new Point(x2, y1), new Rectangle(16, viewportBounds.height));
            } else if (SwingScrollWidget.this.verticalWidget.getParentWidget() != null) {
                SwingScrollWidget.this.removeChild(SwingScrollWidget.this.verticalWidget);
            }
            if (showHorizontal) {
                if (SwingScrollWidget.this.horizontalWidget.getParentWidget() == null) {
                    SwingScrollWidget.this.addChild(SwingScrollWidget.this.horizontalWidget);
                }
                SwingScrollWidget.this.horizontalWidget.resolveBounds(new Point(x1, y2), new Rectangle(viewportBounds.width, 16));
            } else if (SwingScrollWidget.this.horizontalWidget.getParentWidget() != null) {
                SwingScrollWidget.this.removeChild(SwingScrollWidget.this.horizontalWidget);
            }
            SwingScrollWidget.this.verticalScroll.removeAdjustmentListener(SwingScrollWidget.this.verticalListener);
            SwingScrollWidget.this.verticalScroll.setValues(-viewportBounds.y, viewportBounds.height, viewBounds.y, viewBounds.y + viewBounds.height);
            SwingScrollWidget.this.verticalScroll.addAdjustmentListener(SwingScrollWidget.this.verticalListener);
            SwingScrollWidget.this.horizontalScroll.removeAdjustmentListener(SwingScrollWidget.this.horizontalListener);
            SwingScrollWidget.this.horizontalScroll.setValues(-viewportBounds.x, viewportBounds.width, viewBounds.x, viewBounds.x + viewBounds.width);
            SwingScrollWidget.this.horizontalScroll.addAdjustmentListener(SwingScrollWidget.this.horizontalListener);
        }

        @Override
        public boolean requiresJustification(Widget widget) {
            return false;
        }

        @Override
        public void justify(Widget widget) {
        }

        private boolean checkHorizontal(Rectangle viewBounds, Rectangle viewportBounds) {
            return (viewBounds.x < viewportBounds.x || viewBounds.x + viewBounds.width > viewportBounds.x + viewportBounds.width) && viewportBounds.width > 48;
        }

        private boolean checkVertical(Rectangle viewBounds, Rectangle viewportBounds) {
            return (viewBounds.y < viewportBounds.y || viewBounds.y + viewBounds.height > viewportBounds.y + viewportBounds.height) && viewportBounds.height > 48;
        }
    }
}

