/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

abstract class DefaultParser
extends DefaultHandler {
    protected FileObject fo;
    private Locator locator = null;
    protected short state = 0;
    protected static final short PARSED = 1000;
    protected static final short ERROR = -1;
    protected static final short INIT = 0;
    protected static final short LOAD = 1;
    private static final Logger LOG = Logger.getLogger(DefaultParser.class.getName());
    private static boolean xercesErrorInfoLogged = false;

    protected DefaultParser() {
    }

    protected DefaultParser(FileObject fo) {
        this.fo = fo;
    }

    protected XMLReader createXMLReader() throws IOException, SAXException {
        return XMLUtil.createXMLReader(false);
    }

    protected boolean isStopException(Throwable e2) {
        return false;
    }

    protected short getState() {
        return this.state;
    }

    protected final Locator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void parse(FileObject fo) {
        this.state = 0;
        InputStream is = null;
        this.fo = fo;
        try {
            XMLReader parser = this.createXMLReader();
            parser.setEntityResolver(this);
            parser.setErrorHandler(this);
            parser.setContentHandler(this);
            try {
                parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                parser.setProperty("http://apache.org/xml/properties/input-buffer-size", new Integer(2048));
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            InputSource in = new InputSource();
            is = fo.getInputStream();
            in.setByteStream(is);
            in.setSystemId(fo.toURL().toExternalForm());
            this.customizeInputSource(in);
            parser.parse(in);
        }
        catch (IOException io) {
            if (!this.isStopException(io) && fo.isValid() && fo.canRead()) {
                Exceptions.attachMessage(io, "While parsing: " + fo);
                LOG.log(Level.INFO, null, io);
                this.state = (short)-1;
            }
        }
        catch (SAXException sex) {
            if (!this.isStopException(sex)) {
                Exceptions.attachMessage(sex, "While parsing: " + fo);
                LOG.log(Level.INFO, null, sex);
                this.state = (short)-1;
            }
        }
        catch (InternalError ie) {
            if (!this.isStopException(ie)) {
                this.state = (short)-1;
            }
        }
        catch (NullPointerException npe) {
            if (!this.isStopException(npe)) {
                this.state = (short)-1;
                this.logNPE(npe, fo);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException io) {}
            }
        }
    }

    private void logNPE(NullPointerException npe, FileObject fo) {
        StackTraceElement[] elements = npe.getStackTrace();
        if (elements.length > 0 && elements[0].getClassName().startsWith("com.sun.org.apache.xerces.internal.impl")) {
            if (!xercesErrorInfoLogged && !LOG.isLoggable(Level.FINE)) {
                xercesErrorInfoLogged = true;
                LOG.log(Level.INFO, "Some problem occurred during parsing. Please set logging level for {0} to FINE for more details.", LOG.getName());
            }
            LOG.log(Level.FINE, "While parsing: {0}", fo);
            LOG.log(Level.FINE, null, npe);
        } else {
            Exceptions.attachMessage(npe, "While parsing: " + fo);
            LOG.log(Level.INFO, null, npe);
        }
    }

    protected void customizeInputSource(InputSource in) {
    }

    protected final void parse() {
        if (this.fo == null) {
            throw new NullPointerException();
        }
        this.parse(this.fo);
    }

    protected void error() throws SAXException {
        String reason = NbBundle.getMessage(DefaultParser.class, "Invalid_XML_document");
        this.error(reason);
    }

    protected void error(String reason) throws SAXException {
        StringBuffer buf = new StringBuffer(reason).append(": ").append(this.fo.toString());
        if (this.locator != null) {
            buf.append(" line: ").append(this.locator.getLineNumber());
            buf.append(" column: ").append(this.locator.getColumnNumber());
        }
        String msg = buf.toString();
        SAXException sex = new SAXException(msg);
        throw sex;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void endDocument() throws SAXException {
        this.state = (short)1000;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public InputSource resolveEntity(String publicID, String systemID) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }
}

