/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

public class MIMEResolverProcessor
extends LayerGeneratingProcessor {
    private static final String SUFFIX = ".xml";

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(MIMEResolver.Registration.class.getCanonicalName());
        set.add(MIMEResolver.ExtensionRegistration.class.getCanonicalName());
        set.add(MIMEResolver.NamespaceRegistration.class.getCanonicalName());
        return set;
    }

    @Override
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        Annotation r2;
        for (Element element : roundEnv.getElementsAnnotatedWith(MIMEResolver.Registration.class)) {
            MIMEResolver.Registration r22 = element.getAnnotation(MIMEResolver.Registration.class);
            this.registerDefinition(element, r22.resource(), r22);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(MIMEResolver.ExtensionRegistration.class)) {
            r2 = element.getAnnotation(MIMEResolver.ExtensionRegistration.class);
            this.registerExt(element, (MIMEResolver.ExtensionRegistration)r2);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(MIMEResolver.NamespaceRegistration.class)) {
            r2 = element.getAnnotation(MIMEResolver.NamespaceRegistration.class);
            this.registerNamespace(element, (MIMEResolver.NamespaceRegistration)r2);
        }
        return true;
    }

    private void registerExt(Element e2, MIMEResolver.ExtensionRegistration r2) throws LayerGenerationException {
        LayerBuilder b2 = this.layer(e2);
        LayerBuilder.File f2 = b2.file("Services/MIMEResolver/" + this.getName(e2).replace('.', '-') + "-Extension" + SUFFIX);
        f2.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        f2.stringvalue("instanceClass", MIMEResolver.class.getName());
        f2.stringvalue("mimeType", r2.mimeType());
        int cnt = 0;
        for (String ext : r2.extension()) {
            f2.stringvalue("ext." + cnt++, ext);
        }
        f2.position(r2.position());
        int ccnt = 0;
        for (String chooser : r2.showInFileChooser()) {
            f2.bundlevalue("fileChooser." + ccnt++, chooser);
        }
        f2.bundlevalue("displayName", r2.displayName());
        f2.write();
    }

    private void registerDefinition(Element e2, String relRes, MIMEResolver.Registration r2) throws LayerGenerationException {
        String absRes = LayerBuilder.absolutizeResource(e2, relRes);
        LayerBuilder b2 = this.layer(e2);
        javax.tools.FileObject fo = b2.validateResource(absRes, e2, r2, null, false);
        LayerBuilder.File f2 = b2.file("Services/MIMEResolver/" + this.getName(e2).replace('.', '-') + "-Registration" + SUFFIX);
        f2.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        f2.stringvalue("instanceClass", MIMEResolver.class.getName());
        f2.serialvalue("bytes", this.generateInstanceResolver(fo, e2, f2, r2));
        f2.position(r2.position());
        int ccnt = 0;
        for (String chooser : r2.showInFileChooser()) {
            f2.bundlevalue("fileChooser." + ccnt++, chooser);
        }
        f2.bundlevalue("displayName", r2.displayName());
        f2.write();
    }

    private byte[] generateInstanceResolver(javax.tools.FileObject fo, Element e2, LayerBuilder.File f2, MIMEResolver.Registration r2) throws LayerGenerationException {
        try {
            int ch;
            InputStream is = fo.openInputStream();
            FileObject tmp = FileUtil.createMemoryFileSystem().getRoot().createData("resolver.xml");
            OutputStream os = tmp.getOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            os.close();
            is.close();
            MIMEResolver resolver = MIMEResolverImpl.forDescriptor(tmp, false);
            this.setFileChooserRelatedAttributes(r2, resolver, f2);
            byte[] almostResult = MIMEResolverImpl.toStream(resolver);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(almostResult);
            oos.close();
            return out.toByteArray();
        }
        catch (IOException ex) {
            LayerGenerationException le = new LayerGenerationException("Cannot process " + fo, e2);
            le.initCause(ex);
            throw le;
        }
    }

    private void registerNamespace(Element e2, MIMEResolver.NamespaceRegistration r2) throws LayerGenerationException {
        LayerBuilder b2 = this.layer(e2);
        LayerBuilder.File f2 = b2.file("Services/MIMEResolver/" + this.getName(e2).replace('.', '-') + "-Namespace" + SUFFIX);
        f2.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        f2.stringvalue("instanceClass", MIMEResolver.class.getName());
        f2.stringvalue("mimeType", r2.mimeType());
        int cnt = 0;
        for (String ext : r2.doctypePublicId()) {
            f2.stringvalue("doctype." + cnt++, ext);
        }
        cnt = 0;
        for (String ext : r2.checkedExtension()) {
            f2.stringvalue("ext." + cnt++, ext);
        }
        cnt = 0;
        for (String ext : r2.acceptedExtension()) {
            f2.stringvalue("accept." + cnt++, ext);
        }
        cnt = 0;
        f2.stringvalue("element", r2.elementName());
        for (String ext : r2.elementNS()) {
            f2.stringvalue("ns." + cnt++, ext);
        }
        f2.position(r2.position());
        f2.bundlevalue("displayName", r2.displayName());
        f2.write();
    }

    private String getName(Element e2) {
        if (e2.getKind().isClass() || e2.getKind().isInterface()) {
            return this.processingEnv.getElementUtils().getBinaryName((TypeElement)e2).toString();
        }
        if (e2.getKind() == ElementKind.PACKAGE) {
            return e2.getSimpleName().toString();
        }
        return this.getName(e2.getEnclosingElement()) + '.' + e2.getSimpleName();
    }

    private Set<String> unq(String[] array) {
        return this.unq(Arrays.asList(array));
    }

    private Set<String> unq(Collection collection) {
        TreeSet<String> s2 = new TreeSet<String>();
        s2.addAll(collection);
        return s2;
    }

    /*
     * WARNING - void declaration
     */
    private void setFileChooserRelatedAttributes(MIMEResolver.Registration r2, MIMEResolver resolver, LayerBuilder.File f2) {
        if (r2.showInFileChooser().length > 0) {
            String[] types = MIMEResolverImpl.getMIMETypes(resolver);
            List<String> exts = ((FilterInfo)((Object)resolver)).getExtensions();
            int cnt = 0;
            for (String string : this.unq(exts)) {
                f2.stringvalue("ext." + cnt++, string);
            }
            int tcnt = 0;
            for (String type : this.unq(types)) {
                f2.stringvalue("mimeType." + tcnt++, type);
            }
            boolean bl = false;
            for (String name : ((FilterInfo)((Object)resolver)).getFileNames()) {
                void var8_12;
                f2.stringvalue("fileName." + (int)(++var8_12), name);
            }
        }
    }

    static interface FilterInfo {
        public List<String> getExtensions();

        public List<String> getFileNames();
    }
}

