/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.spi.MutexImplementation;

public class DefaultMutexImplementation
implements MutexImplementation {
    static int counter;
    private static final Logger LOG;
    public static boolean beStrict;
    private static final int NONE = 0;
    private static final int CHAIN = 1;
    private static final int X = 2;
    private static final int S = 3;
    private static final int MODE_COUNT = 4;
    private static final boolean[][] cmatrix;
    private int grantedMode = 0;
    private int origMode;
    private final Object LOCK;
    private final Executor wrapper;
    private final Map<Thread, ThreadInfo> registeredThreads = new HashMap<Thread, ThreadInfo>(7);
    private int readersNo = 0;
    private List<QueueCell> waiters;
    private int cnt;

    public static DefaultMutexImplementation create() {
        return new DefaultMutexImplementation();
    }

    public static DefaultMutexImplementation usingLock(Object lock) {
        return new DefaultMutexImplementation(lock);
    }

    public static DefaultMutexImplementation controlledBy(Privileged p2) {
        return new DefaultMutexImplementation(p2);
    }

    public static DefaultMutexImplementation controlledBy(Privileged p2, Executor e2) {
        return new DefaultMutexImplementation(p2, e2);
    }

    private DefaultMutexImplementation(Object lock) {
        this.LOCK = this.init(lock);
        this.wrapper = null;
    }

    private DefaultMutexImplementation() {
        this.LOCK = this.init(new InternalLock());
        this.wrapper = null;
    }

    private DefaultMutexImplementation(Privileged privileged) {
        if (privileged == null) {
            throw new IllegalArgumentException("privileged == null");
        }
        this.LOCK = this.init(new InternalLock());
        privileged.setParent(this);
        this.wrapper = null;
    }

    private DefaultMutexImplementation(Privileged privileged, Executor executor) {
        this.LOCK = new DefaultMutexImplementation(privileged);
        this.wrapper = executor;
    }

    private Object init(Object lock) {
        this.waiters = new LinkedList<QueueCell>();
        this.cnt = counter++;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "[" + this.cnt + "] created here", new Exception());
        }
        return lock;
    }

    @Override
    public void readAccess(Runnable runnable) {
        if (this.wrapper != null) {
            try {
                this.doWrapperAccess(null, runnable, true);
                return;
            }
            catch (MutexException ex) {
                throw new IllegalStateException(ex);
            }
        }
        Thread t2 = Thread.currentThread();
        this.readEnter(t2, 0L);
        try {
            runnable.run();
        }
        finally {
            this.leave(t2);
        }
    }

    @Override
    public <T> T readAccess(Mutex.ExceptionAction<T> action) throws MutexException {
        if (this.wrapper != null) {
            return this.doWrapperAccess(action, null, true);
        }
        Thread t2 = Thread.currentThread();
        this.readEnter(t2, 0L);
        try {
            T t3 = action.run();
            return t3;
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new MutexException(e3);
        }
        finally {
            this.leave(t2);
        }
    }

    @Override
    public void writeAccess(Runnable runnable) {
        if (this.wrapper != null) {
            try {
                this.doWrapperAccess(null, runnable, false);
            }
            catch (MutexException ex) {
                throw new IllegalStateException(ex);
            }
            return;
        }
        Thread t2 = Thread.currentThread();
        this.writeEnter(t2, 0L);
        try {
            runnable.run();
        }
        finally {
            this.leave(t2);
        }
    }

    @Override
    public <T> T writeAccess(Mutex.ExceptionAction<T> action) throws MutexException {
        if (this.wrapper != null) {
            return this.doWrapperAccess(action, null, false);
        }
        Thread t2 = Thread.currentThread();
        this.writeEnter(t2, 0L);
        try {
            T t3 = action.run();
            return t3;
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new MutexException(e3);
        }
        finally {
            this.leave(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadAccess() {
        if (this.wrapper != null) {
            DefaultMutexImplementation m4 = (DefaultMutexImplementation)this.LOCK;
            return m4.isReadAccess();
        }
        Thread t2 = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            ThreadInfo info = this.getThreadInfo(t2);
            if (info != null && info.counts[3] > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWriteAccess() {
        if (this.wrapper != null) {
            DefaultMutexImplementation m4 = (DefaultMutexImplementation)this.LOCK;
            return m4.isWriteAccess();
        }
        Thread t2 = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            ThreadInfo info = this.getThreadInfo(t2);
            if (info != null && info.counts[2] > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void postReadRequest(Runnable run) {
        this.postRequest(3, run, null);
    }

    @Override
    public void postWriteRequest(Runnable run) {
        this.postRequest(2, run, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder sbuff = new StringBuilder(512);
        sbuff.append("DefaultMutexImplementation").append(newline);
        Object object = this.LOCK;
        synchronized (object) {
            sbuff.append("threads: ").append(this.getRegisteredThreads()).append(newline);
            sbuff.append("readersNo: ").append(this.readersNo).append(newline);
            sbuff.append("waiters: ").append(this.waiters).append(newline);
            sbuff.append("grantedMode: ").append(this.getGrantedMode(false)).append(newline);
        }
        return sbuff.toString();
    }

    final boolean writeEnter(Thread t2, long timeout) {
        return this.enter(2, t2, timeout);
    }

    final boolean readEnter(Thread t2, long timeout) {
        return this.enter(3, t2, timeout);
    }

    private void doLog(String action, Object ... params) {
        String tid = Integer.toHexString(Thread.currentThread().hashCode());
        LOG.log(Level.FINER, "[#" + this.cnt + "@" + tid + "] " + action, params);
    }

    private boolean enter(int requested, Thread t2, long timeout) {
        boolean log = LOG.isLoggable(Level.FINER);
        if (log) {
            this.doLog("Entering {0}, {1}", requested, timeout);
        }
        boolean ret = this.enterImpl(requested, t2, timeout);
        if (log) {
            this.doLog("Entering exit: {0}", ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterImpl(int requested, Thread t2, long timeout) {
        QueueCell cell = null;
        int loopc = 0;
        while (true) {
            ++loopc;
            Object object = this.LOCK;
            synchronized (object) {
                ThreadInfo info = this.getThreadInfo(t2);
                if (info != null) {
                    IllegalStateException e2;
                    if (this.getGrantedMode(false) == 0) {
                        throw new IllegalStateException();
                    }
                    if (info.mode == 3 && this.getGrantedMode(false) == 2 || info.mode == 2 && this.getGrantedMode(false) == 3) {
                        throw new IllegalStateException();
                    }
                    if (info.mode == 2 || info.mode == requested) {
                        if (info.forced) {
                            info.forced = false;
                        } else {
                            if (requested == 2 && info.counts[3] > 0) {
                                e2 = new IllegalStateException("WARNING: Going from readAccess to writeAccess, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                                if (beStrict) {
                                    throw e2;
                                }
                                Exceptions.printStackTrace(e2);
                            }
                            int n2 = requested;
                            info.counts[n2] = info.counts[n2] + 1;
                            if (requested == 3 && info.counts[requested] == 1) {
                                ++this.readersNo;
                            }
                        }
                        return true;
                    }
                    if (this.canUpgrade(info.mode, requested)) {
                        e2 = new IllegalStateException("WARNING: Going from readAccess to writeAccess, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                        if (beStrict) {
                            throw e2;
                        }
                        Exceptions.printStackTrace(e2);
                        info.mode = 2;
                        int n3 = requested;
                        info.counts[n3] = info.counts[n3] + 1;
                        info.rsnapshot = info.counts[3];
                        if (this.getGrantedMode(false) == 3) {
                            this.setGrantedMode(2);
                        } else if (this.getGrantedMode(false) == 2) {
                            throw new IllegalStateException();
                        }
                        return true;
                    }
                    e2 = new IllegalStateException("WARNING: Going from readAccess to writeAccess through queue, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                    if (beStrict) {
                        throw e2;
                    }
                    Exceptions.printStackTrace(e2);
                } else if (this.isCompatible(requested)) {
                    this.setGrantedMode(requested);
                    info = new ThreadInfo(t2, requested);
                    this.getRegisteredThreads().put(t2, info);
                    if (requested == 3) {
                        ++this.readersNo;
                    }
                    return true;
                }
                if (timeout == -1L) {
                    return false;
                }
                this.setGrantedMode(1);
                cell = this.chain(requested, t2, 0);
            }
            cell.sleep(timeout);
            if (timeout <= 0L) continue;
            timeout = -1L;
        }
    }

    private boolean reenter(Thread t2, int mode) {
        boolean log = LOG.isLoggable(Level.FINER);
        if (log) {
            this.doLog("Re-Entering {0}", mode);
        }
        boolean ret = this.reenterImpl(t2, mode);
        if (log) {
            this.doLog("Re-Entering exit: {0}", ret);
        }
        return ret;
    }

    private boolean reenterImpl(Thread t2, int mode) {
        boolean chainFromLeaveX;
        if (mode == 3) {
            if (this.getGrantedMode(false) != 0 && this.getGrantedMode(false) != 3) {
                throw new IllegalStateException(this.toString());
            }
            this.enter(mode, t2, 0L);
            return false;
        }
        ThreadInfo tinfo = this.getThreadInfo(t2);
        boolean bl = chainFromLeaveX = this.getGrantedMode(false) == 1 && tinfo != null && tinfo.counts[2] > 0;
        if (this.getGrantedMode(false) == 2 || this.getGrantedMode(false) == 0 || chainFromLeaveX) {
            this.enter(mode, t2, 0L);
            return false;
        }
        if (this.readersNo == 0) {
            throw new IllegalStateException(this.toString());
        }
        ThreadInfo info = new ThreadInfo(t2, mode);
        this.getRegisteredThreads().put(t2, info);
        this.readersNo += 2;
        this.setGrantedMode(1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privilegedEnter(Thread t2, int mode) {
        boolean decrease = true;
        Object object = this.LOCK;
        synchronized (object) {
            this.getThreadInfo(t2);
        }
        while (true) {
            QueueCell cell;
            Object object2 = this.LOCK;
            synchronized (object2) {
                if (decrease) {
                    decrease = false;
                    this.readersNo -= 2;
                }
                this.setGrantedMode(1);
                cell = this.chain(mode, t2, Integer.MAX_VALUE);
                if (this.readersNo == 0) {
                    if (this.waiters.get(0) == cell) {
                        this.waiters.remove(0);
                        this.setGrantedMode(mode);
                        return;
                    }
                    this.setGrantedMode(0);
                    this.wakeUpOthers();
                }
            }
            cell.sleep();
        }
    }

    final void leave(Thread t2) {
        boolean log = LOG.isLoggable(Level.FINER);
        if (log) {
            this.doLog("Leaving {0}", this.getGrantedMode(true));
        }
        this.leaveImpl(t2);
        if (log) {
            this.doLog("Leaving exit: {0}", this.getGrantedMode(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveImpl(Thread t2) {
        ThreadInfo info;
        int postedMode = 0;
        boolean needLock = false;
        Object object = this.LOCK;
        synchronized (object) {
            int runsize;
            info = this.getThreadInfo(t2);
            switch (this.getGrantedMode(false)) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    if (info.counts[2] > 0) {
                        postedMode = this.leaveX(info);
                        break;
                    }
                    if (info.counts[3] > 0) {
                        postedMode = this.leaveS(info);
                        break;
                    }
                    throw new IllegalStateException();
                }
                case 2: {
                    postedMode = this.leaveX(info);
                    break;
                }
                case 3: {
                    postedMode = this.leaveS(info);
                }
            }
            if (postedMode != 0 && (runsize = info.getRunnableCount(postedMode)) != 0) {
                needLock = this.reenter(t2, postedMode);
            }
        }
        if (postedMode != 0 && info.getRunnableCount(postedMode) > 0) {
            this.doLog("Processing posted requests: {0}", postedMode);
            try {
                if (needLock) {
                    this.privilegedEnter(t2, postedMode);
                }
                List<Runnable> runnables = info.dequeue(postedMode);
                int size = runnables.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    try {
                        Runnable r2 = runnables.get(i2);
                        r2.run();
                        continue;
                    }
                    catch (Exception e2) {
                        Exceptions.printStackTrace(e2);
                        continue;
                    }
                    catch (StackOverflowError e3) {
                        e3.printStackTrace();
                        Exceptions.printStackTrace(e3);
                        continue;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Error e4) {
                        Exceptions.printStackTrace(e4);
                    }
                }
                runnables = null;
            }
            finally {
                this.leave(t2);
            }
        }
    }

    private int leaveX(ThreadInfo info) {
        if (info.counts[2] <= 0 || info.rsnapshot > info.counts[3]) {
            throw new IllegalStateException();
        }
        if (info.rsnapshot == info.counts[3]) {
            info.counts[2] = info.counts[2] - 1;
            if (info.counts[2] == 0) {
                info.rsnapshot = 0;
                if (info.counts[3] > 0) {
                    info.mode = 3;
                    this.setGrantedMode(3);
                } else {
                    info.mode = 0;
                    this.setGrantedMode(0);
                    this.getRegisteredThreads().remove(info.t);
                }
                if (info.getRunnableCount(3) > 0) {
                    this.wakeUpReaders();
                    return 3;
                }
                this.wakeUpOthers();
            }
        } else {
            if (info.counts[3] <= 0) {
                throw new IllegalStateException();
            }
            info.counts[3] = info.counts[3] - 1;
            if (info.counts[3] == 0) {
                if (this.readersNo <= 0) {
                    throw new IllegalStateException();
                }
                --this.readersNo;
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int leaveS(ThreadInfo info) {
        if (info.counts[3] <= 0 || info.counts[2] > 0) {
            throw new IllegalStateException();
        }
        info.counts[3] = info.counts[3] - 1;
        if (info.counts[3] == 0) {
            info.mode = 0;
            this.getRegisteredThreads().remove(info.t);
            if (this.readersNo <= 0) {
                throw new IllegalStateException();
            }
            --this.readersNo;
            if (this.readersNo == 0) {
                this.setGrantedMode(0);
                if (info.getRunnableCount(2) > 0) {
                    return 2;
                }
                this.wakeUpOthers();
            } else {
                if (info.getRunnableCount(2) > 0) {
                    return 2;
                }
                if (this.getGrantedMode(false) == 1 && this.readersNo == 1) {
                    for (int i2 = 0; i2 < this.waiters.size(); ++i2) {
                        QueueCell qc;
                        QueueCell queueCell = qc = this.waiters.get(i2);
                        synchronized (queueCell) {
                            if (qc.isGotOut()) {
                                this.waiters.remove(i2--);
                                continue;
                            }
                            ThreadInfo tinfo = this.getThreadInfo(qc.t);
                            if (tinfo != null && tinfo.mode == 3) {
                                if (qc.mode != 2) {
                                    throw new IllegalStateException();
                                }
                                if (this.waiters.size() == 1) {
                                    this.setGrantedMode(2);
                                }
                                tinfo.mode = 2;
                                this.waiters.remove(i2);
                                qc.wakeMeUp();
                            }
                            break;
                        }
                    }
                }
            }
        }
        return 0;
    }

    private QueueCell chain(int requested, Thread t2, int priority) {
        QueueCell qc = new QueueCell(requested, t2);
        qc.priority2 = priority;
        int size = this.waiters.size();
        if (size == 0) {
            this.waiters.add(qc);
        } else if (qc.getPriority() == Integer.MAX_VALUE) {
            this.waiters.add(0, qc);
        } else {
            int i2 = 0;
            do {
                QueueCell cursor;
                if ((cursor = this.waiters.get(i2)).getPriority() >= qc.getPriority()) continue;
                this.waiters.add(i2, qc);
                break;
            } while (++i2 < size);
            if (i2 == size) {
                this.waiters.add(qc);
            }
        }
        return qc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpOthers() {
        if (this.getGrantedMode(false) == 2 || this.getGrantedMode(false) == 1) {
            throw new IllegalStateException();
        }
        if (this.waiters.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < this.waiters.size(); ++i2) {
            QueueCell qc;
            QueueCell queueCell = qc = this.waiters.get(i2);
            synchronized (queueCell) {
                if (qc.isGotOut()) {
                    this.waiters.remove(i2--);
                    continue;
                }
                if (this.isCompatible(qc.mode)) {
                    this.waiters.remove(i2--);
                    qc.wakeMeUp();
                    this.setGrantedMode(qc.mode);
                    if (this.getThreadInfo(qc.t) == null) {
                        ThreadInfo ti = new ThreadInfo(qc.t, qc.mode);
                        ti.forced = true;
                        if (qc.mode == 3) {
                            ++this.readersNo;
                        }
                        this.getRegisteredThreads().put(qc.t, ti);
                    }
                } else {
                    this.setGrantedMode(1);
                    break;
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpReaders() {
        assert (this.getGrantedMode(false) == 0 || this.getGrantedMode(false) == 3);
        if (this.waiters.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < this.waiters.size(); ++i2) {
            QueueCell qc;
            QueueCell queueCell = qc = this.waiters.get(i2);
            synchronized (queueCell) {
                if (qc.isGotOut()) {
                    this.waiters.remove(i2--);
                    continue;
                }
                if (qc.mode == 3) {
                    this.waiters.remove(i2--);
                    qc.wakeMeUp();
                    this.setGrantedMode(3);
                    if (this.getThreadInfo(qc.t) == null) {
                        ThreadInfo ti = new ThreadInfo(qc.t, qc.mode);
                        ti.forced = true;
                        ++this.readersNo;
                        this.getRegisteredThreads().put(qc.t, ti);
                    }
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRequest(final int mutexMode, final Runnable run, Executor exec) {
        ThreadInfo info;
        if (this.wrapper != null) {
            DefaultMutexImplementation m4 = (DefaultMutexImplementation)this.LOCK;
            m4.postRequest(mutexMode, run, this.wrapper);
            return;
        }
        final Thread t2 = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            info = this.getThreadInfo(t2);
            if (info != null) {
                if (mutexMode == info.mode && info.counts[5 - mutexMode] == 0) {
                    this.enter(mutexMode, t2, 0L);
                } else {
                    info.enqueue(mutexMode, run);
                    return;
                }
            }
        }
        if (info == null) {
            if (exec != null) {
                class Exec
                implements Runnable {
                    Exec() {
                    }

                    @Override
                    public void run() {
                        DefaultMutexImplementation.this.enter(mutexMode, t2, 0L);
                        try {
                            run.run();
                        }
                        finally {
                            DefaultMutexImplementation.this.leave(t2);
                        }
                    }
                }
                exec.execute(new Exec());
                return;
            }
            this.enter(mutexMode, t2, 0L);
            try {
                run.run();
            }
            finally {
                this.leave(t2);
            }
            return;
        }
        try {
            run.run();
        }
        finally {
            this.leave(t2);
        }
    }

    private boolean isCompatible(int requested) {
        if (requested == 3 && this.getGrantedMode(false) == 1 && this.getOrigMode() == 3) {
            return true;
        }
        return cmatrix[requested][this.getGrantedMode(false)];
    }

    private ThreadInfo getThreadInfo(Thread t2) {
        return this.getRegisteredThreads().get(t2);
    }

    private boolean canUpgrade(int threadGranted, int requested) {
        return threadGranted == 3 && requested == 2 && this.readersNo == 1;
    }

    private <T> T doWrapperAccess(final Mutex.ExceptionAction<T> action, final Runnable runnable, final boolean readOnly) throws MutexException {
        class R
        implements Runnable {
            T ret;
            MutexException e;

            R() {
            }

            @Override
            public void run() {
                DefaultMutexImplementation m4 = (DefaultMutexImplementation)DefaultMutexImplementation.this.LOCK;
                try {
                    if (readOnly) {
                        if (action != null) {
                            this.ret = m4.readAccess(action);
                        } else {
                            m4.readAccess(runnable);
                        }
                    } else if (action != null) {
                        this.ret = m4.writeAccess(action);
                    } else {
                        m4.writeAccess(runnable);
                    }
                }
                catch (MutexException ex) {
                    this.e = ex;
                }
            }
        }
        R run = new R();
        DefaultMutexImplementation m4 = (DefaultMutexImplementation)this.LOCK;
        if (m4.isWriteAccess() || m4.isReadAccess()) {
            run.run();
        } else {
            this.wrapper.execute(run);
        }
        if (run.e != null) {
            throw run.e;
        }
        return run.ret;
    }

    private void setGrantedMode(int mode) {
        assert (Thread.holdsLock(this.LOCK));
        if (this.grantedMode != 1 && mode == 1) {
            this.origMode = this.grantedMode;
        }
        this.grantedMode = mode;
    }

    private int getGrantedMode(boolean skipCheck) {
        assert (skipCheck || Thread.holdsLock(this.LOCK));
        return this.grantedMode;
    }

    private int getOrigMode() {
        assert (Thread.holdsLock(this.LOCK));
        return this.origMode;
    }

    private Map<Thread, ThreadInfo> getRegisteredThreads() {
        assert (Thread.holdsLock(this.LOCK));
        return this.registeredThreads;
    }

    static {
        LOG = Logger.getLogger(DefaultMutexImplementation.class.getName());
        cmatrix = new boolean[][]{null, null, {true, false, false, false}, {true, false, false, true}};
    }

    public static class Privileged {
        private DefaultMutexImplementation parent;

        final void setParent(DefaultMutexImplementation parent) {
            this.parent = parent;
        }

        public void enterReadAccess() {
            this.parent.readEnter(Thread.currentThread(), 0L);
        }

        public boolean tryReadAccess(long timeout) {
            return this.parent.readEnter(Thread.currentThread(), timeout);
        }

        public void enterWriteAccess() {
            this.parent.writeEnter(Thread.currentThread(), 0L);
        }

        public boolean tryWriteAccess(long timeout) {
            return this.parent.writeEnter(Thread.currentThread(), timeout);
        }

        public void exitReadAccess() {
            this.parent.leave(Thread.currentThread());
        }

        public void exitWriteAccess() {
            this.parent.leave(Thread.currentThread());
        }
    }

    private static final class QueueCell {
        int mode;
        Thread t;
        boolean signal;
        boolean left;
        int priority2;

        public QueueCell(int mode, Thread t2) {
            this.mode = mode;
            this.t = t2;
            this.left = false;
            this.priority2 = 0;
        }

        public String toString() {
            return super.toString() + " mode: " + this.mode + " thread: " + this.t;
        }

        public long getPriority() {
            return this.priority2 == 0 ? this.t.getPriority() : this.priority2;
        }

        public boolean isGotOut() {
            return this.left;
        }

        public void sleep() {
            this.sleep(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void sleep(long timeout) {
            block8: {
                boolean wasInterrupted = false;
                while (true) {
                    if (this.signal) break block8;
                    try {
                        long start = System.currentTimeMillis();
                        this.wait(timeout);
                        return;
                    }
                    catch (InterruptedException e2) {
                        wasInterrupted = true;
                        LOG.log(Level.FINE, null, e2);
                    }
                }
                finally {
                    this.left = true;
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void wakeMeUp() {
            this.signal = true;
            this.notifyAll();
        }
    }

    private static final class InternalLock {
        InternalLock() {
        }
    }

    private static final class ThreadInfo {
        boolean forced;
        final Thread t;
        int mode;
        int[] counts;
        List<Runnable>[] queues;
        int rsnapshot;

        public ThreadInfo(Thread t2, int mode) {
            this.t = t2;
            this.mode = mode;
            this.counts = new int[4];
            this.queues = new List[4];
            this.counts[mode] = 1;
        }

        public String toString() {
            return super.toString() + " thread: " + this.t + " mode: " + this.mode + " X: " + this.counts[2] + " S: " + this.counts[3];
        }

        public void enqueue(int mode, Runnable run) {
            if (this.queues[mode] == null) {
                this.queues[mode] = new ArrayList<Runnable>(13);
            }
            this.queues[mode].add(run);
        }

        public List<Runnable> dequeue(int mode) {
            List<Runnable> ret = this.queues[mode];
            this.queues[mode] = null;
            return ret;
        }

        public int getRunnableCount(int mode) {
            return this.queues[mode] == null ? 0 : this.queues[mode].size();
        }
    }
}

