/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openide.util.BaseUtilities;
import org.openide.util.EditableProperties;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class NbBundleProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(NbBundle.Messages.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        HashMap<String, HashSet<Element>> annotatedElementsByPackage = new HashMap<String, HashSet<Element>>();
        for (Element element : roundEnv.getElementsAnnotatedWith(NbBundle.Messages.class)) {
            NbBundle.Messages messages = element.getAnnotation(NbBundle.Messages.class);
            if (messages == null) continue;
            String pkg = this.findPackage(element);
            HashSet<Element> annotatedElements = (HashSet<Element>)annotatedElementsByPackage.get(pkg);
            if (annotatedElements == null) {
                annotatedElements = new HashSet<Element>();
                annotatedElementsByPackage.put(pkg, annotatedElements);
            }
            annotatedElements.add(element);
        }
        block23: for (Map.Entry entry : annotatedElementsByPackage.entrySet()) {
            String pkg = (String)entry.getKey();
            Set annotatedElements = (Set)entry.getValue();
            PackageElement pkgE = this.processingEnv.getElementUtils().getPackageElement(pkg);
            if (pkgE != null) {
                HashSet<? extends Element> unscannedTopElements = new HashSet<Element>();
                unscannedTopElements.add(pkgE);
                try {
                    unscannedTopElements.addAll(pkgE.getEnclosedElements());
                }
                catch (RuntimeException x2) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "#196556: reading " + pkg + " failed with " + x2 + " in " + x2.getStackTrace()[0] + "; do a clean build!");
                }
                unscannedTopElements.removeAll(roundEnv.getRootElements());
                this.addToAnnotatedElements(unscannedTopElements, annotatedElements);
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not check for other source files in " + pkg);
            }
            HashMap<String, String> pairs = new HashMap<String, String>();
            HashMap<String, Element> identifiers = new HashMap<String, Element>();
            HashMap<String, String> compilationUnits = new HashMap<String, String>();
            HashMap<String, String[]> comments = new HashMap<String, String[]>();
            for (Element e3 : annotatedElements) {
                String simplename = this.findCompilationUnitName(e3);
                ArrayList<String> runningComments = new ArrayList<String>();
                for (String keyValue : e3.getAnnotation(NbBundle.Messages.class).value()) {
                    if (keyValue.startsWith("#")) {
                        runningComments.add(keyValue);
                        if (!keyValue.matches("# +(PART)?(NO)?I18N *")) continue;
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "#NOI18N and related keywords must not include spaces", e3);
                        continue;
                    }
                    int i2 = keyValue.indexOf(61);
                    if (i2 == -1) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Bad key=value: " + keyValue, e3);
                        continue;
                    }
                    String key = keyValue.substring(0, i2);
                    if (key.isEmpty() || !key.equals(key.trim())) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Whitespace not permitted in key: " + keyValue, e3);
                        continue;
                    }
                    Element original = identifiers.put(this.toIdentifier(key), e3);
                    if (original != null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate key: " + key, e3);
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate key: " + key, original);
                        continue block23;
                    }
                    String value = keyValue.substring(i2 + 1);
                    pairs.put(key, value);
                    compilationUnits.put(key, simplename);
                    if (runningComments.isEmpty()) continue;
                    comments.put(key, runningComments.toArray(new String[runningComments.size()]));
                    runningComments.clear();
                }
                if (runningComments.isEmpty()) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Comments must precede keys", e3);
            }
            Element[] elements = new HashSet(identifiers.values()).toArray(new Element[0]);
            try {
                EditableProperties p2 = new EditableProperties(true);
                try (InputStream is22 = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, pkg, "Bundle.properties").openInputStream();){
                    p2.load(is22);
                }
                catch (IOException is22) {
                    // empty catch block
                }
                for (String key : p2.keySet()) {
                    if (!pairs.containsKey(key)) continue;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Key " + key + " is a duplicate of one from Bundle.properties", (Element)identifiers.get(this.toIdentifier(key)));
                }
                try (InputStream is32 = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, pkg, "Bundle.properties").openInputStream();){
                    EditableProperties p22 = new EditableProperties(true);
                    p22.load(is32);
                    p2.putAll(p22);
                }
                catch (IOException is32) {
                    // empty catch block
                }
                p2.putAll(pairs);
                for (Map.Entry entry2 : comments.entrySet()) {
                    p2.setComment((String)entry2.getKey(), (String[])entry2.getValue(), false);
                }
                try (OutputStream os = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, pkg, "Bundle.properties", elements).openOutputStream();){
                    p2.store(os);
                }
                TreeMap<String, String> methods = new TreeMap<String, String>();
                for (Map.Entry entry2 : pairs.entrySet()) {
                    String key = (String)entry2.getKey();
                    String value = (String)entry2.getValue();
                    StringBuilder method = new StringBuilder();
                    method.append("    /**\n");
                    ArrayList<String> params = new ArrayList<String>();
                    int i3 = 0;
                    while (value.contains("{" + i3)) {
                        params.add("arg" + i3++);
                    }
                    String[] commentLines = (String[])comments.get(key);
                    if (commentLines != null) {
                        for (String comment : commentLines) {
                            Matcher m4 = Pattern.compile("# [{](\\d+)[}] - (.+)").matcher(comment);
                            if (!m4.matches()) continue;
                            i3 = Integer.parseInt(m4.group(1));
                            while (i3 >= params.size()) {
                                params.add("arg" + params.size());
                            }
                            String desc = m4.group(2);
                            params.set(i3, this.toIdentifier(desc));
                            method.append("     * @param ").append((String)params.get(i3)).append(" ").append(this.toJavadoc(desc)).append("\n");
                        }
                    }
                    StringBuffer annotatedValue = new StringBuffer("<i>");
                    Matcher m5 = Pattern.compile("[{](\\d+)[}]").matcher(this.toJavadoc(value));
                    while (m5.find()) {
                        i3 = Integer.parseInt(m5.group(1));
                        m5.appendReplacement(annotatedValue, i3 < params.size() ? "</i>{@code " + (String)params.get(i3) + "}<i>" : m5.group());
                    }
                    m5.appendTail(annotatedValue);
                    annotatedValue.append("</i>");
                    method.append("     * @return ").append(annotatedValue.toString().replace("<i></i>", "")).append('\n');
                    method.append("     * @see ").append((String)compilationUnits.get(key)).append('\n');
                    method.append("     */\n");
                    String name = this.toIdentifier(key);
                    method.append("    static String ").append(name).append("(");
                    boolean first = true;
                    i3 = 0;
                    for (String param : params) {
                        if (param.equals("arg" + i3)) {
                            this.warnUndocumented(i3, (Element)identifiers.get(name), key);
                        }
                        ++i3;
                        if (first) {
                            first = false;
                        } else {
                            method.append(", ");
                        }
                        method.append("Object ").append(param);
                    }
                    method.append(") {\n");
                    method.append("        return org.openide.util.NbBundle.getMessage(Bundle.class, \"").append(key).append("\"");
                    for (String param : params) {
                        method.append(", ").append(param);
                    }
                    method.append(");\n");
                    method.append("    }\n");
                    methods.put(name, method.toString());
                }
                try {
                    TreeSet<String> restored = new TreeSet<String>();
                    Matcher matcher = Pattern.compile("    /[*][*]\r?\n(?:     [*].+\r?\n)+     [*] @see (?:[\\w-]+)\r?\n     [*]/\r?\n    static String (\\w+).+\r?\n        .+\r?\n    [}]\r?\n").matcher(this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, pkg, "Bundle.java").getCharContent(false));
                    while (matcher.find()) {
                        String identifier = matcher.group(1);
                        if (methods.containsKey(identifier)) continue;
                        methods.put(identifier, matcher.group());
                        restored.add(identifier);
                    }
                }
                catch (IOException restored) {
                    // empty catch block
                }
                String fqn = pkg + ".Bundle";
                try (Writer writer = this.processingEnv.getFiler().createSourceFile(fqn, elements).openWriter();){
                    PrintWriter pw = new PrintWriter(writer);
                    pw.println("package " + pkg + ";");
                    pw.println("/** Localizable strings for {@link " + pkg + "}. */");
                    pw.println("class Bundle {");
                    for (String method : methods.values()) {
                        pw.print(method);
                    }
                    pw.println("    private Bundle() {}");
                    pw.println("}");
                    pw.flush();
                    pw.close();
                }
            }
            catch (IOException x3) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not generate files: " + x3, elements[0]);
            }
        }
        return true;
    }

    private String findPackage(Element e2) {
        switch (e2.getKind()) {
            case PACKAGE: {
                return ((PackageElement)e2).getQualifiedName().toString();
            }
        }
        return this.findPackage(e2.getEnclosingElement());
    }

    private String findCompilationUnitName(Element e2) {
        switch (e2.getKind()) {
            case PACKAGE: {
                return "package-info";
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                switch (e2.getEnclosingElement().getKind()) {
                    case PACKAGE: {
                        return e2.getSimpleName().toString();
                    }
                }
            }
        }
        return this.findCompilationUnitName(e2.getEnclosingElement());
    }

    private String toIdentifier(String key) {
        if (BaseUtilities.isJavaIdentifier(key)) {
            return key;
        }
        String i2 = key.replaceAll("[^\\p{javaJavaIdentifierPart}]+", "_");
        if (BaseUtilities.isJavaIdentifier(i2)) {
            return i2;
        }
        return "_" + i2;
    }

    private String toJavadoc(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace("*/", "&#x2A;/").replace("\n", "<br>").replace("@", "&#64;");
    }

    private void addToAnnotatedElements(Collection<? extends Element> unscannedElements, Set<Element> annotatedElements) {
        for (Element element : unscannedElements) {
            if (element.getAnnotation(NbBundle.Messages.class) != null) {
                annotatedElements.add(element);
            }
            if (element.getKind() == ElementKind.PACKAGE) continue;
            this.addToAnnotatedElements(element.getEnclosedElements(), annotatedElements);
        }
    }

    private void warnUndocumented(int i2, Element e2, String key) {
        AnnotationMirror mirror = null;
        AnnotationValue value = null;
        if (e2 != null) {
            block0: for (AnnotationMirror annotationMirror : e2.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(NbBundle.Messages.class.getCanonicalName())) continue;
                mirror = annotationMirror;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
                    Object v2 = entry.getValue().getValue();
                    if (v2 instanceof String) {
                        if (!((String)v2).startsWith(key + "=")) break block0;
                        value = entry.getValue();
                        break block0;
                    }
                    for (AnnotationValue subentry : NbCollections.checkedListByCopy((List)v2, AnnotationValue.class, true)) {
                        v2 = subentry.getValue();
                        if (!(v2 instanceof String) || !((String)v2).startsWith(key + "=")) continue;
                        value = subentry;
                        break block0;
                    }
                }
            }
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Undocumented format parameter {" + i2 + "} prepend line: # {" + i2 + "} - some text,", e2, mirror, value);
    }
}

