/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Union2;
import org.openide.util.lookup.Lookups;
import org.openide.util.spi.MutexEventProvider;
import org.openide.util.spi.MutexImplementation;

public class NbMutexEventProvider
implements MutexEventProvider {
    @Override
    public MutexImplementation createMutex() {
        return new Event();
    }

    private static final class Event
    implements MutexImplementation {
        private Event() {
        }

        @Override
        public boolean isReadAccess() {
            return SwingUtilities.isEventDispatchThread();
        }

        @Override
        public boolean isWriteAccess() {
            return SwingUtilities.isEventDispatchThread();
        }

        @Override
        public void writeAccess(Runnable runnable) {
            Event.doEvent(runnable);
        }

        @Override
        public <T> T writeAccess(Mutex.ExceptionAction<T> action) throws MutexException {
            return Event.doEventAccess(action);
        }

        @Override
        public void readAccess(Runnable runnable) {
            Event.doEvent(runnable);
        }

        @Override
        public <T> T readAccess(Mutex.ExceptionAction<T> action) throws MutexException {
            return Event.doEventAccess(action);
        }

        @Override
        public void postReadRequest(Runnable run) {
            Event.doEventRequest(run);
        }

        @Override
        public void postWriteRequest(Runnable run) {
            Event.doEventRequest(run);
        }

        public String toString() {
            return "EVENT - Full JRE";
        }

        private static void doEvent(Runnable run) {
            if (EventQueue.isDispatchThread()) {
                run.run();
            } else {
                Lookup inherit = Lookup.getDefault();
                EventQueue.invokeLater(() -> Lookups.executeWith(inherit, run));
            }
        }

        private static void doEventRequest(Runnable run) {
            Lookup inherit = Lookup.getDefault();
            EventQueue.invokeLater(() -> Lookups.executeWith(inherit, run));
        }

        private static <T> T doEventAccess(final Mutex.ExceptionAction<T> run) throws MutexException {
            if (Event.isDispatchThread()) {
                try {
                    return run.run();
                }
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new MutexException(e3);
                }
            }
            final AtomicReference res = new AtomicReference();
            final AtomicBoolean started = new AtomicBoolean();
            final AtomicBoolean finished = new AtomicBoolean();
            AtomicBoolean invoked = new AtomicBoolean();
            final Lookup inherit = Lookup.getDefault();
            try {
                class AWTWorker
                implements Runnable {
                    AWTWorker() {
                    }

                    @Override
                    public void run() {
                        started.set(true);
                        Lookups.executeWith(inherit, () -> {
                            try {
                                res.set(Union2.createFirst(run.run()));
                            }
                            catch (Exception e2) {
                                res.set(Union2.createSecond(e2));
                            }
                            catch (LinkageError e3) {
                                res.set(Union2.createSecond(e3));
                            }
                            catch (StackOverflowError e4) {
                                res.set(Union2.createSecond(e4));
                            }
                        });
                        finished.set(true);
                    }
                }
                AWTWorker w2 = new AWTWorker();
                EventQueue.invokeAndWait(w2);
                invoked.set(true);
            }
            catch (InterruptedException e4) {
                res.set(Union2.createSecond(e4));
            }
            catch (InvocationTargetException e5) {
                res.set(Union2.createSecond(e5));
            }
            Union2 _res = (Union2)res.get();
            if (_res == null) {
                throw new IllegalStateException("#210991: got neither a result nor an exception; started=" + started + " finished=" + finished + " invoked=" + invoked);
            }
            if (_res.hasFirst()) {
                return (T)_res.first();
            }
            Throwable e6 = (Throwable)_res.second();
            if (e6 instanceof RuntimeException) {
                throw (RuntimeException)e6;
            }
            throw Event.notifyException(e6);
        }

        private static boolean isDispatchThread() {
            boolean dispatch = EventQueue.isDispatchThread();
            if (!dispatch && BaseUtilities.getOperatingSystem() == 8) {
                dispatch = Thread.currentThread().getClass().getName().indexOf("EventDispatchThread") >= 0;
            }
            return dispatch;
        }

        private static MutexException notifyException(Throwable t2) {
            if (t2 instanceof InvocationTargetException) {
                t2 = Event.unfoldInvocationTargetException((InvocationTargetException)t2);
            }
            if (t2 instanceof Error) {
                Event.annotateEventStack(t2);
                throw (Error)t2;
            }
            if (t2 instanceof RuntimeException) {
                Event.annotateEventStack(t2);
                throw (RuntimeException)t2;
            }
            MutexException exc = new MutexException((Exception)t2);
            exc.initCause(t2);
            return exc;
        }

        private static void annotateEventStack(Throwable t2) {
        }

        private static Throwable unfoldInvocationTargetException(InvocationTargetException e2) {
            Throwable ret;
            while ((e2 = (ret = e2.getTargetException()) instanceof InvocationTargetException ? (InvocationTargetException)ret : null) != null) {
            }
            return ret;
        }
    }
}

