/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.util.List;
import org.netbeans.api.visual.action.ConnectDecorator;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ConnectAction
extends WidgetAction.LockedAdapter {
    private static final int MIN_DIFFERENCE = 5;
    private ConnectDecorator decorator;
    private Widget interractionLayer;
    private ConnectProvider provider;
    private ConnectionWidget connectionWidget = null;
    private Widget sourceWidget = null;
    private Widget targetWidget = null;
    private Point startingPoint = null;

    public ConnectAction(ConnectDecorator decorator, Widget interractionLayer, ConnectProvider provider) {
        this.decorator = decorator;
        this.interractionLayer = interractionLayer;
        this.provider = provider;
    }

    @Override
    protected boolean isLocked() {
        return this.sourceWidget != null;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        return this.mousePressedCore(widget, event);
    }

    protected WidgetAction.State mousePressedCore(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 1 && this.provider.isSourceWidget(widget)) {
            this.sourceWidget = widget;
            this.targetWidget = null;
            this.startingPoint = new Point(event.getPoint());
            this.connectionWidget = this.decorator.createConnectionWidget(this.interractionLayer.getScene());
            assert (this.connectionWidget != null);
            this.connectionWidget.setSourceAnchor(this.decorator.createSourceAnchor(widget));
            this.interractionLayer.addChild(this.connectionWidget);
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        Point point = event.getPoint();
        boolean state = this.move(widget, point);
        if (state) {
            if (this.targetWidget != null && (Math.abs(this.startingPoint.x - point.x) >= 5 || Math.abs(this.startingPoint.y - point.y) >= 5)) {
                this.provider.createConnection(this.sourceWidget, this.targetWidget);
            }
            this.cancel();
        }
        return state ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    private void cancel() {
        this.sourceWidget = null;
        this.targetWidget = null;
        this.startingPoint = null;
        this.connectionWidget.setSourceAnchor(null);
        this.connectionWidget.setTargetAnchor(null);
        this.interractionLayer.removeChild(this.connectionWidget);
        this.connectionWidget = null;
    }

    @Override
    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.move(widget, event.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point point) {
        if (this.sourceWidget != widget) {
            return false;
        }
        Point targetSceneLocation = widget.convertLocalToScene(point);
        this.targetWidget = this.resolveTargetWidgetCore(this.interractionLayer.getScene(), targetSceneLocation);
        Anchor targetAnchor = null;
        if (this.targetWidget != null) {
            targetAnchor = this.decorator.createTargetAnchor(this.targetWidget);
        }
        if (targetAnchor == null) {
            targetAnchor = this.decorator.createFloatAnchor(targetSceneLocation);
        }
        this.connectionWidget.setTargetAnchor(targetAnchor);
        return true;
    }

    private Widget resolveTargetWidgetCore(Scene scene, Point sceneLocation) {
        if (this.provider != null && this.provider.hasCustomTargetWidgetResolver(scene)) {
            return this.provider.resolveTargetWidget(scene, sceneLocation);
        }
        Point sceneOrigin = scene.getLocation();
        sceneLocation = new Point(sceneLocation.x + sceneOrigin.x, sceneLocation.y + sceneOrigin.y);
        Widget[] result = new Widget[]{null};
        this.resolveTargetWidgetCoreDive(result, scene, sceneLocation);
        return result[0];
    }

    private boolean resolveTargetWidgetCoreDive(Widget[] result, Widget widget, Point parentLocation) {
        if (this.interractionLayer.equals(widget)) {
            return false;
        }
        Point widgetLocation = widget.getLocation();
        Point location = new Point(parentLocation.x - widgetLocation.x, parentLocation.y - widgetLocation.y);
        if (!widget.getBounds().contains(location)) {
            return false;
        }
        List<Widget> children = widget.getChildren();
        for (int i2 = children.size() - 1; i2 >= 0; --i2) {
            if (!this.resolveTargetWidgetCoreDive(result, children.get(i2), location)) continue;
            return true;
        }
        if (!widget.isHitAt(location)) {
            return false;
        }
        ConnectorState state = this.provider.isTargetWidget(this.sourceWidget, widget);
        if (state == ConnectorState.REJECT) {
            return false;
        }
        if (state == ConnectorState.ACCEPT) {
            result[0] = widget;
        }
        return true;
    }

    @Override
    public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent event) {
        if (this.isLocked() && event.getKeyCode() == 27) {
            this.cancel();
            return WidgetAction.State.CONSUMED;
        }
        return super.keyPressed(widget, event);
    }
}

