/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EnumSet;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class TextFieldInplaceEditorProvider
implements InplaceEditorProvider<JTextField> {
    private TextFieldInplaceEditor editor;
    private EnumSet<InplaceEditorProvider.ExpansionDirection> expansionDirections;
    private KeyListener keyListener;
    private FocusListener focusListener;
    private DocumentListener documentListener;

    public TextFieldInplaceEditorProvider(TextFieldInplaceEditor editor, EnumSet<InplaceEditorProvider.ExpansionDirection> expansionDirections) {
        this.editor = editor;
        this.expansionDirections = expansionDirections;
    }

    @Override
    public JTextField createEditorComponent(InplaceEditorProvider.EditorController controller, Widget widget) {
        if (!this.editor.isEnabled(widget)) {
            return null;
        }
        JTextField field = new JTextField(this.editor.getText(widget));
        field.selectAll();
        Scene scene = widget.getScene();
        double zoomFactor = scene.getZoomFactor();
        if (zoomFactor > 1.0) {
            Font font = scene.getDefaultFont();
            font = font.deriveFont((float)((double)font.getSize2D() * zoomFactor));
            field.setFont(font);
        }
        return field;
    }

    @Override
    public void notifyOpened(final InplaceEditorProvider.EditorController controller, Widget widget, JTextField editor) {
        editor.setMinimumSize(new Dimension(64, 19));
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                switch (e2.getKeyChar()) {
                    case '\u001b': {
                        e2.consume();
                        controller.closeEditor(false);
                        break;
                    }
                    case '\n': {
                        e2.consume();
                        controller.closeEditor(true);
                    }
                }
            }
        };
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                controller.closeEditor(true);
            }
        };
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e2) {
                controller.notifyEditorComponentBoundsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e2) {
                controller.notifyEditorComponentBoundsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
                controller.notifyEditorComponentBoundsChanged();
            }
        };
        editor.addKeyListener(this.keyListener);
        editor.addFocusListener(this.focusListener);
        editor.getDocument().addDocumentListener(this.documentListener);
        editor.selectAll();
    }

    @Override
    public void notifyClosing(InplaceEditorProvider.EditorController controller, Widget widget, JTextField editor, boolean commit) {
        editor.getDocument().removeDocumentListener(this.documentListener);
        editor.removeFocusListener(this.focusListener);
        editor.removeKeyListener(this.keyListener);
        if (commit) {
            this.editor.setText(widget, editor.getText());
            if (widget != null) {
                widget.getScene().validate();
            }
        }
    }

    @Override
    public Rectangle getInitialEditorComponentBounds(InplaceEditorProvider.EditorController controller, Widget widget, JTextField editor, Rectangle viewBounds) {
        return null;
    }

    @Override
    public EnumSet<InplaceEditorProvider.ExpansionDirection> getExpansionDirections(InplaceEditorProvider.EditorController controller, Widget widget, JTextField editor) {
        return this.expansionDirections;
    }
}

