/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.border.DashedBorder;

public final class FancyDashedBorder
extends DashedBorder {
    private static int focusField = 5;
    private static int rectSize = 5;
    private static int halfRectSize = rectSize / 2;
    private static int rect15Size = rectSize + halfRectSize;

    public FancyDashedBorder(Color color, int width, int height) {
        super(color, width, (float)height);
    }

    public FancyDashedBorder(String property, Widget associated, int width, int height) {
        super(property, associated, (float)width, (float)height);
    }

    public FancyDashedBorder(String property, ResourceTable table, int width, int height) {
        super(property, table, (float)width, (float)height);
    }

    @Override
    public void paint(Graphics2D g2, Rectangle bounds) {
        int x2 = bounds.x;
        int y2 = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        bounds.x += focusField / 2;
        bounds.y += focusField / 2;
        bounds.width -= focusField;
        bounds.height -= focusField;
        super.paint(g2, bounds);
        g2.drawRect(x2, y2, rectSize, rectSize);
        g2.drawRect(x2 + width / 2 - halfRectSize, y2, rectSize, rectSize);
        g2.drawRect(x2 + width - rect15Size, y2, rectSize, rectSize);
        g2.drawRect(x2 + width - rect15Size, y2 - halfRectSize + height / 2, rectSize, rectSize);
        g2.drawRect(x2 + width - rect15Size, y2 - rect15Size + height, rectSize, rectSize);
        g2.drawRect(x2 + width / 2 - halfRectSize, y2 - rect15Size + height, rectSize, rectSize);
        g2.drawRect(x2, y2 - rect15Size + height, rectSize, rectSize);
        g2.drawRect(x2, y2 - rectSize + height / 2, rectSize, rectSize);
    }
}

