/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class HierarchicalLayout<N, E>
extends GraphLayout<N, E> {
    public static final boolean TRACE = false;
    public static final boolean CHECK = false;
    public static final int SWEEP_ITERATIONS = 3;
    public static final int CROSSING_ITERATIONS = 3;
    public static final int DUMMY_WIDTH = 1;
    public static final int X_OFFSET = 20;
    public static final int LAYER_OFFSET = 30;
    private int dummyWidth = 1;
    private int xOffset;
    private int layerOffset;
    private int layerCount;
    private UniversalGraph<N, E> graph;
    private List<LayoutNode> nodes;
    private Collection<N> nodesSubset = null;
    private HashMap<N, LayoutNode> vertexToLayoutNode;
    private Set<E> reversedLinks;
    private List<LayoutNode>[] layers;
    private boolean animate = false;
    private boolean invert = true;
    private Comparator<LayoutNode> crossingNodeComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            float f2 = n1.crossingNumber - n2.crossingNumber;
            if (f2 < 0.0f) {
                return -1;
            }
            if (f2 > 0.0f) {
                return 1;
            }
            return 0;
        }
    };
    private final Comparator<LayoutNode> nodePositionComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            int res = n1.pos - n2.pos;
            if (res == 0 && (res = n1.toString().compareTo(n1.toString())) == 0) {
                res = System.identityHashCode(n1) - System.identityHashCode(n2);
            }
            return res;
        }
    };
    private final Comparator<LayoutNode> nodeProcessingDownComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            if (n1.vertex == null && n2.vertex == null) {
                int res = n1.toString().compareTo(n1.toString());
                if (res == 0) {
                    res = System.identityHashCode(n1) - System.identityHashCode(n2);
                }
                return res;
            }
            if (n1.vertex == null) {
                return -1;
            }
            if (n2.vertex == null) {
                return 1;
            }
            int res = n1.preds.size() - n2.preds.size();
            if (res == 0 && (res = n1.toString().compareTo(n1.toString())) == 0) {
                res = System.identityHashCode(n1) - System.identityHashCode(n2);
            }
            return res;
        }
    };
    private final Comparator<LayoutNode> nodeProcessingUpComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            if (n1.vertex == null && n2.vertex == null) {
                int res = n1.toString().compareTo(n1.toString());
                if (res == 0) {
                    res = System.identityHashCode(n1) - System.identityHashCode(n2);
                }
                return res;
            }
            if (n1.vertex == null) {
                return -1;
            }
            if (n2.vertex == null) {
                return 1;
            }
            int res = n1.succs.size() - n2.succs.size();
            if (res == 0 && (res = n1.toString().compareTo(n1.toString())) == 0) {
                res = System.identityHashCode(n1) - System.identityHashCode(n2);
            }
            return res;
        }
    };

    public HierarchicalLayout(GraphScene<N, E> scene, boolean animate, boolean inverted, int xOffset, int layerOffset) {
        this.animate = animate;
        this.xOffset = xOffset > 0 ? xOffset : 20;
        this.layerOffset = layerOffset > 0 ? layerOffset : 30;
        this.invert = inverted;
    }

    public HierarchicalLayout(GraphScene<N, E> scene, boolean animate, boolean inverted) {
        this(scene, animate, inverted, 20, 30);
    }

    public HierarchicalLayout(GraphScene<N, E> scene, boolean animate) {
        this(scene, animate, false);
    }

    public HierarchicalLayout() {
        this(null, false);
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> graph) {
        this.graph = graph;
        this.vertexToLayoutNode = new HashMap();
        this.reversedLinks = new HashSet();
        this.nodes = new ArrayList<LayoutNode>();
        new BuildDatastructure().start();
        new ReverseEdges().start();
        new AssignLayers().start();
        new CreateDummyNodes().start();
        new CrossingReduction().start();
        new AssignXCoordinates().start();
        new AssignYCoordinates().start();
        new WriteResult().start();
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> arg0, Collection<N> arg1) {
        this.nodesSubset = arg1;
        this.performGraphLayout(arg0);
    }

    static /* synthetic */ List[] access$1902(HierarchicalLayout x0, List[] x1) {
        x0.layers = x1;
        return x1;
    }

    private class WriteResult
    extends AlgorithmPart {
        private int pointCount;

        private WriteResult() {
        }

        @Override
        protected void run() {
            List<Point> points;
            HashMap vertexPositions = new HashMap();
            HashMap linkPositions = new HashMap();
            for (Object v2 : HierarchicalLayout.this.graph.getNodes()) {
                LayoutNode n2 = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(v2);
                assert (!vertexPositions.containsKey(v2));
                vertexPositions.put(v2, new Point(n2.x + n2.xOffset, n2.y + n2.yOffset));
            }
            for (LayoutNode n3 : HierarchicalLayout.this.nodes) {
                for (LayoutEdge layoutEdge : n3.succs) {
                    if (layoutEdge.link == null) continue;
                    Object link = layoutEdge.link;
                    points = new ArrayList();
                    Point p2 = new Point(layoutEdge.from.x + layoutEdge.relativeFrom, layoutEdge.from.y + layoutEdge.from.height - layoutEdge.from.bottomYOffset);
                    ((ArrayList)points).add(p2);
                    LayoutNode cur = layoutEdge.to;
                    LayoutNode other = layoutEdge.from;
                    LayoutEdge curEdge = layoutEdge;
                    while (cur.vertex == null && cur.succs.size() != 0) {
                        ((ArrayList)points).add(new Point(cur.x + cur.width / 2, cur.y));
                        ((ArrayList)points).add(new Point(cur.x + cur.width / 2, cur.y + cur.height));
                        if (cur.succs.size() == 0) break;
                        assert (cur.succs.size() == 1);
                        curEdge = cur.succs.get(0);
                        cur = curEdge.to;
                    }
                    p2 = new Point(cur.x + curEdge.relativeTo, cur.y + cur.yOffset);
                    ((ArrayList)points).add(p2);
                    if (HierarchicalLayout.this.reversedLinks.contains(link)) {
                        Collections.reverse(points);
                    }
                    linkPositions.put(layoutEdge.link, points);
                    layoutEdge.link = null;
                }
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            for (Point point : vertexPositions.values()) {
                minX = Math.min(minX, point.x);
                minY = Math.min(minY, point.y);
            }
            for (List list : linkPositions.values()) {
                for (Point p4 : list) {
                    if (p4 == null) continue;
                    minX = Math.min(minX, p4.x);
                    minY = Math.min(minY, p4.y);
                }
            }
            for (Map.Entry entry : vertexPositions.entrySet()) {
                Object v3 = entry.getKey();
                Point p2 = (Point)entry.getValue();
                p2.x -= minX;
                p2.y -= minY;
                Widget w2 = HierarchicalLayout.this.graph.getScene().findWidget(v3);
                if (HierarchicalLayout.this.animate) {
                    HierarchicalLayout.this.graph.getScene().getSceneAnimator().animatePreferredLocation(w2, p2);
                    continue;
                }
                w2.setPreferredLocation(p2);
            }
            for (Map.Entry entry : linkPositions.entrySet()) {
                Widget w2;
                Object l2 = entry.getKey();
                points = (List)entry.getValue();
                for (Point p5 : points) {
                    if (p5 == null) continue;
                    p5.x -= minX;
                    p5.y -= minY;
                }
                if (HierarchicalLayout.this.invert && points.size() > 3) {
                    int numPoints = points.size();
                    ArrayList<Point> invertedPoints = new ArrayList<Point>(numPoints);
                    invertedPoints.add((Point)points.get(0));
                    for (int i2 = numPoints - 2; i2 > 0; --i2) {
                        invertedPoints.add(points.get(i2));
                    }
                    invertedPoints.add(points.get(numPoints - 1));
                    points = invertedPoints;
                }
                if (!((w2 = HierarchicalLayout.this.graph.getScene().findWidget(l2)) instanceof ConnectionWidget)) continue;
                ConnectionWidget cw = (ConnectionWidget)w2;
                cw.setControlPoints(points, true);
            }
            HierarchicalLayout.this.graph.getScene().validate();
            HierarchicalLayout.this.graph.getScene().repaint();
            HierarchicalLayout.this.graph.getScene().revalidate();
        }

        @Override
        protected void printStatistics() {
            System.out.println("Number of nodes: " + HierarchicalLayout.this.nodes.size());
            int edgeCount = 0;
            for (LayoutNode n2 : HierarchicalLayout.this.nodes) {
                edgeCount += n2.succs.size();
            }
            System.out.println("Number of edges: " + edgeCount);
            System.out.println("Number of points: " + this.pointCount);
        }
    }

    private class AssignYCoordinates
    extends AlgorithmPart {
        private AssignYCoordinates() {
        }

        @Override
        protected void run() {
            int curY = 0;
            for (int i2 = 0; i2 < HierarchicalLayout.this.layers.length; ++i2) {
                int maxHeight = 0;
                int baseLine = 0;
                int bottomBaseLine = 0;
                for (LayoutNode n2 : HierarchicalLayout.this.layers[i2]) {
                    maxHeight = Math.max(maxHeight, n2.height - n2.yOffset - n2.bottomYOffset);
                    baseLine = Math.max(baseLine, n2.yOffset);
                    bottomBaseLine = Math.max(bottomBaseLine, n2.bottomYOffset);
                }
                for (LayoutNode n2 : HierarchicalLayout.this.layers[i2]) {
                    if (n2.vertex == null) {
                        n2.y = curY;
                        n2.height = maxHeight + baseLine + bottomBaseLine;
                        continue;
                    }
                    n2.y = curY + baseLine + (maxHeight - (n2.height - n2.yOffset - n2.bottomYOffset)) / 2 - n2.yOffset;
                }
                curY += maxHeight + baseLine + bottomBaseLine;
                curY += HierarchicalLayout.this.layerOffset;
            }
        }
    }

    private class NodeRow {
        private TreeSet<LayoutNode> treeSet;
        private ArrayList<Integer> space;

        public NodeRow(ArrayList<Integer> space) {
            this.treeSet = new TreeSet(HierarchicalLayout.this.nodePositionComparator);
            this.space = space;
        }

        public int offset(LayoutNode n1, LayoutNode n2) {
            int v1 = this.space.get(n1.pos) + n1.width;
            int v2 = this.space.get(n2.pos);
            return v2 - v1;
        }

        public void insert(LayoutNode n2, int pos) {
            SortedSet<LayoutNode> headSet = this.treeSet.headSet(n2);
            SortedSet<LayoutNode> tailSet = this.treeSet.tailSet(n2);
            LayoutNode leftNeighbor = null;
            int minX = Integer.MIN_VALUE;
            if (!headSet.isEmpty()) {
                leftNeighbor = headSet.last();
                minX = leftNeighbor.x + leftNeighbor.width + this.offset(leftNeighbor, n2);
            }
            LayoutNode rightNeighbor = null;
            int maxX = Integer.MAX_VALUE;
            if (!tailSet.isEmpty()) {
                rightNeighbor = tailSet.first();
                maxX = rightNeighbor.x - this.offset(n2, rightNeighbor) - n2.width;
            }
            assert (minX <= maxX);
            if (pos >= minX && pos <= maxX) {
                n2.x = pos;
            } else if (Math.abs((long)pos - (long)minX) < Math.abs((long)pos - (long)maxX)) {
                assert (minX != Integer.MIN_VALUE);
                n2.x = minX;
            } else {
                assert (maxX != Integer.MAX_VALUE);
                n2.x = maxX;
            }
            this.treeSet.add(n2);
        }
    }

    private class AssignXCoordinates
    extends AlgorithmPart {
        private ArrayList<Integer>[] space;
        private ArrayList<LayoutNode>[] downProcessingOrder;
        private ArrayList<LayoutNode>[] upProcessingOrder;

        private AssignXCoordinates() {
        }

        private void initialPositions() {
            for (LayoutNode n2 : HierarchicalLayout.this.nodes) {
                n2.x = this.space[n2.layer].get(n2.pos);
            }
        }

        @Override
        protected void run() {
            int i2;
            ArrayList[] spaceTmp = new ArrayList[HierarchicalLayout.this.layers.length];
            this.space = spaceTmp;
            ArrayList[] downProcessingOrderTmp = new ArrayList[HierarchicalLayout.this.layers.length];
            this.downProcessingOrder = downProcessingOrderTmp;
            ArrayList[] upProcessingOrderTmp = new ArrayList[HierarchicalLayout.this.layers.length];
            this.upProcessingOrder = upProcessingOrderTmp;
            for (i2 = 0; i2 < HierarchicalLayout.this.layers.length; ++i2) {
                this.space[i2] = new ArrayList();
                this.downProcessingOrder[i2] = new ArrayList();
                this.upProcessingOrder[i2] = new ArrayList();
                int curX = 0;
                for (LayoutNode n2 : HierarchicalLayout.this.layers[i2]) {
                    this.space[i2].add(curX);
                    curX += n2.width + HierarchicalLayout.this.xOffset;
                    this.downProcessingOrder[i2].add(n2);
                    this.upProcessingOrder[i2].add(n2);
                }
                Collections.sort(this.downProcessingOrder[i2], HierarchicalLayout.this.nodeProcessingDownComparator);
                Collections.sort(this.upProcessingOrder[i2], HierarchicalLayout.this.nodeProcessingUpComparator);
            }
            this.initialPositions();
            for (i2 = 0; i2 < 3; ++i2) {
                this.sweepDown();
                this.sweepUp();
            }
            this.sweepDown();
            this.sweepUp();
        }

        private int calculateOptimalDown(LayoutNode n2) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            if (n2.preds.size() == 0) {
                return n2.x;
            }
            for (LayoutEdge e2 : n2.preds) {
                int cur = e2.from.x + e2.relativeFrom - e2.relativeTo;
                values.add(cur);
            }
            return this.median(values);
        }

        private int calculateOptimalUp(LayoutNode n2) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            if (n2.succs.size() == 0) {
                return n2.x;
            }
            for (LayoutEdge e2 : n2.succs) {
                int cur = e2.to.x + e2.relativeTo - e2.relativeFrom;
                values.add(cur);
            }
            return this.median(values);
        }

        private int median(List<Integer> values) {
            Collections.sort(values);
            if (values.size() % 2 == 0) {
                return (values.get(values.size() / 2 - 1) + values.get(values.size() / 2)) / 2;
            }
            return values.get(values.size() / 2);
        }

        private void sweepUp() {
            for (int i2 = HierarchicalLayout.this.layers.length - 2; i2 >= 0; --i2) {
                NodeRow r2 = new NodeRow(this.space[i2]);
                for (LayoutNode n2 : this.upProcessingOrder[i2]) {
                    int optimal = this.calculateOptimalUp(n2);
                    r2.insert(n2, optimal);
                }
            }
        }

        private void sweepDown() {
            for (int i2 = 1; i2 < HierarchicalLayout.this.layers.length; ++i2) {
                NodeRow r2 = new NodeRow(this.space[i2]);
                for (LayoutNode n2 : this.downProcessingOrder[i2]) {
                    int optimal = this.calculateOptimalDown(n2);
                    r2.insert(n2, optimal);
                }
            }
        }
    }

    private class CrossingReduction
    extends AlgorithmPart {
        private CrossingReduction() {
        }

        @Override
        public void preCheck() {
            for (LayoutNode n2 : HierarchicalLayout.this.nodes) {
                assert (n2.layer < HierarchicalLayout.this.layerCount);
            }
        }

        @Override
        protected void run() {
            int i2;
            List[] layersTmp = new List[HierarchicalLayout.this.layerCount];
            HierarchicalLayout.access$1902(HierarchicalLayout.this, layersTmp);
            for (int i3 = 0; i3 < HierarchicalLayout.this.layerCount; ++i3) {
                ((HierarchicalLayout)HierarchicalLayout.this).layers[i3] = new ArrayList();
            }
            HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
            for (LayoutNode n2 : HierarchicalLayout.this.nodes) {
                if (n2.layer == 0) {
                    HierarchicalLayout.this.layers[0].add(n2);
                    visited.add(n2);
                    continue;
                }
                if (n2.preds.size() != 0) continue;
                HierarchicalLayout.this.layers[n2.layer].add(n2);
                visited.add(n2);
            }
            for (i2 = 0; i2 < HierarchicalLayout.this.layers.length - 1; ++i2) {
                for (LayoutNode n3 : HierarchicalLayout.this.layers[i2]) {
                    for (LayoutEdge e2 : n3.succs) {
                        if (visited.contains(e2.to)) continue;
                        visited.add(e2.to);
                        HierarchicalLayout.this.layers[i2 + 1].add(e2.to);
                    }
                }
            }
            this.updatePositions();
            for (i2 = 0; i2 < 3; ++i2) {
                this.downSweep();
                this.upSweep();
            }
        }

        private void updatePositions() {
            for (int i2 = 0; i2 < HierarchicalLayout.this.layers.length; ++i2) {
                int z2 = 0;
                for (LayoutNode n2 : HierarchicalLayout.this.layers[i2]) {
                    n2.pos = z2++;
                }
            }
        }

        private void downSweep() {
            for (int i2 = 1; i2 < HierarchicalLayout.this.layerCount; ++i2) {
                for (LayoutNode n2 : HierarchicalLayout.this.layers[i2]) {
                    float sum = 0.0f;
                    for (LayoutEdge e2 : n2.preds) {
                        float cur = e2.from.pos;
                        if (e2.from.width != 0 && e2.relativeFrom != 0) {
                            cur += (float)e2.relativeFrom / (float)e2.from.width;
                        }
                        sum += cur;
                    }
                    if (n2.preds.size() <= 0) continue;
                    n2.crossingNumber = sum /= (float)n2.preds.size();
                }
                Collections.sort(HierarchicalLayout.this.layers[i2], HierarchicalLayout.this.crossingNodeComparator);
                int z2 = 0;
                for (LayoutNode n3 : HierarchicalLayout.this.layers[i2]) {
                    n3.pos = z2++;
                }
            }
        }

        private void upSweep() {
            for (int i2 = HierarchicalLayout.this.layerCount - 1; i2 >= 0; --i2) {
                for (LayoutNode n2 : HierarchicalLayout.this.layers[i2]) {
                    float sum = 0.0f;
                    for (LayoutEdge e2 : n2.succs) {
                        float cur = e2.to.pos;
                        if (e2.to.width != 0 && e2.relativeTo != 0) {
                            cur += (float)e2.relativeTo / (float)e2.to.width;
                        }
                        sum += cur;
                    }
                    if (n2.succs.size() <= 0) continue;
                    n2.crossingNumber = sum /= (float)n2.succs.size();
                }
                Collections.sort(HierarchicalLayout.this.layers[i2], HierarchicalLayout.this.crossingNodeComparator);
                int z2 = 0;
                for (LayoutNode n3 : HierarchicalLayout.this.layers[i2]) {
                    n3.pos = z2++;
                }
            }
        }

        private int evaluate() {
            return 0;
        }

        @Override
        public void postCheck() {
            HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
            for (int i2 = 0; i2 < HierarchicalLayout.this.layers.length; ++i2) {
                for (LayoutNode n2 : HierarchicalLayout.this.layers[i2]) {
                    assert (!visited.contains(n2));
                    assert (n2.layer == i2);
                    visited.add(n2);
                }
            }
        }
    }

    private class CreateDummyNodes
    extends AlgorithmPart {
        private int oldNodeCount;

        private CreateDummyNodes() {
        }

        @Override
        protected void preCheck() {
            for (LayoutNode n2 : HierarchicalLayout.this.nodes) {
                for (LayoutEdge e2 : n2.succs) {
                    assert (e2.from != null);
                    assert (e2.from == n2);
                    assert (e2.from.layer < e2.to.layer);
                }
                for (LayoutEdge e2 : n2.preds) {
                    assert (e2.to != null);
                    assert (e2.to == n2);
                }
            }
        }

        @Override
        protected void run() {
            this.oldNodeCount = HierarchicalLayout.this.nodes.size();
            ArrayList currentNodes = new ArrayList(HierarchicalLayout.this.nodes);
            for (LayoutNode n2 : currentNodes) {
                for (LayoutEdge e2 : n2.succs) {
                    this.processSingleEdge(e2);
                }
            }
        }

        private void processSingleEdge(LayoutEdge e2) {
            LayoutNode n2 = e2.from;
            if (e2.to.layer > n2.layer + 1) {
                LayoutEdge last = e2;
                for (int i2 = n2.layer + 1; i2 < last.to.layer; ++i2) {
                    last = this.addBetween(last, i2);
                }
            }
        }

        private LayoutEdge addBetween(LayoutEdge e2, int layer) {
            LayoutNode n2 = new LayoutNode();
            n2.width = HierarchicalLayout.this.dummyWidth;
            n2.height = 0;
            n2.layer = layer;
            n2.preds.add(e2);
            HierarchicalLayout.this.nodes.add(n2);
            LayoutEdge result = new LayoutEdge();
            n2.succs.add(result);
            result.from = n2;
            result.relativeFrom = n2.width / 2;
            result.to = e2.to;
            result.relativeTo = e2.relativeTo;
            e2.relativeTo = n2.width / 2;
            e2.to.preds.remove(e2);
            e2.to.preds.add(result);
            e2.to = n2;
            return result;
        }

        @Override
        public void printStatistics() {
            System.out.println("Dummy nodes created: " + (HierarchicalLayout.this.nodes.size() - this.oldNodeCount));
        }

        @Override
        public void postCheck() {
            ArrayList currentNodes = new ArrayList(HierarchicalLayout.this.nodes);
            for (LayoutNode n2 : currentNodes) {
                for (LayoutEdge e2 : n2.succs) {
                    assert (e2.from.layer == e2.to.layer - 1);
                }
            }
            for (int i2 = 0; i2 < HierarchicalLayout.this.layers.length; ++i2) {
                assert (HierarchicalLayout.this.layers[i2].size() > 0);
                for (LayoutNode n3 : HierarchicalLayout.this.layers[i2]) {
                    assert (n3.layer == i2);
                }
            }
        }
    }

    private class AssignLayers
    extends AlgorithmPart {
        private AssignLayers() {
        }

        @Override
        public void preCheck() {
            for (LayoutNode n2 : HierarchicalLayout.this.nodes) {
                assert (n2.layer == -1);
            }
        }

        @Override
        protected void run() {
            HashSet<LayoutNode> set = new HashSet<LayoutNode>();
            for (LayoutNode n2 : HierarchicalLayout.this.nodes) {
                if (n2.preds.size() != 0) continue;
                set.add(n2);
                n2.layer = 0;
            }
            int z2 = 1;
            HashSet<Object> newSet = new HashSet();
            HashSet<LayoutNode> failed = new HashSet<LayoutNode>();
            while (!set.isEmpty()) {
                newSet.clear();
                failed.clear();
                for (LayoutNode layoutNode : set) {
                    for (LayoutEdge se : layoutNode.succs) {
                        LayoutNode s2 = se.to;
                        if (newSet.contains(s2) || failed.contains(s2)) continue;
                        boolean ok = true;
                        for (LayoutEdge pe : s2.preds) {
                            LayoutNode p2 = pe.from;
                            if (p2.layer != -1) continue;
                            ok = false;
                            break;
                        }
                        if (ok) {
                            newSet.add(s2);
                            continue;
                        }
                        failed.add(s2);
                    }
                }
                for (LayoutNode layoutNode : newSet) {
                    layoutNode.layer = z2;
                }
                HashSet<LayoutNode> tmp = set;
                set = newSet;
                newSet = tmp;
                ++z2;
            }
            this.optimize(set);
            HierarchicalLayout.this.layerCount = z2 - 1;
        }

        public void optimize(HashSet<LayoutNode> set) {
            for (LayoutNode n2 : set) {
                if (n2.preds.size() != 0 || n2.succs.size() <= 0) continue;
                int minLayer = n2.succs.get((int)0).to.layer;
                for (LayoutEdge e2 : n2.succs) {
                    minLayer = Math.min(minLayer, e2.to.layer);
                }
                n2.layer = minLayer - 1;
            }
        }

        @Override
        public void printStatistics() {
        }

        @Override
        public void postCheck() {
            for (LayoutNode n2 : HierarchicalLayout.this.nodes) {
                assert (n2.layer >= 0);
                assert (n2.layer < HierarchicalLayout.this.layerCount);
                for (LayoutEdge e2 : n2.succs) {
                    assert (e2.from.layer < e2.to.layer);
                }
            }
        }
    }

    private class ReverseEdges
    extends AlgorithmPart {
        private HashSet<LayoutNode> visited;
        private HashSet<LayoutNode> active;

        private ReverseEdges() {
        }

        @Override
        protected void run() {
            for (LayoutNode node : HierarchicalLayout.this.nodes) {
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                for (LayoutEdge e2 : succs) {
                    assert (e2.from == node);
                    if (e2.to != node) continue;
                    node.succs.remove(e2);
                    node.preds.remove(e2);
                }
            }
            this.visited = new HashSet();
            this.active = new HashSet();
            for (LayoutNode node : HierarchicalLayout.this.nodes) {
                this.DFS(node);
            }
        }

        private void DFS(LayoutNode startNode) {
            if (this.visited.contains(startNode)) {
                return;
            }
            Stack<LayoutNode> stack = new Stack<LayoutNode>();
            stack.push(startNode);
            while (!stack.empty()) {
                LayoutNode node = (LayoutNode)stack.pop();
                if (this.visited.contains(node)) {
                    this.active.remove(node);
                    continue;
                }
                stack.push(node);
                this.visited.add(node);
                this.active.add(node);
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                for (LayoutEdge e2 : succs) {
                    if (this.active.contains(e2.to)) {
                        assert (this.visited.contains(e2.to));
                        this.reverseEdge(e2);
                        continue;
                    }
                    if (this.visited.contains(e2.to)) continue;
                    stack.push(e2.to);
                }
            }
        }

        private void reverseAllInputs(LayoutNode node) {
            for (LayoutEdge e2 : node.preds) {
                assert (!HierarchicalLayout.this.reversedLinks.contains(e2.link));
                HierarchicalLayout.this.reversedLinks.add(e2.link);
                node.succs.add(e2);
                e2.from.preds.add(e2);
                e2.from.succs.remove(e2);
                int oldRelativeFrom = e2.relativeFrom;
                int oldRelativeTo = e2.relativeTo;
                e2.to = e2.from;
                e2.from = node;
                e2.relativeFrom = oldRelativeTo;
                e2.relativeTo = oldRelativeFrom;
            }
            node.preds.clear();
        }

        private void reverseEdge(LayoutEdge e2) {
            assert (!HierarchicalLayout.this.reversedLinks.contains(e2.link));
            HierarchicalLayout.this.reversedLinks.add(e2.link);
            LayoutNode oldFrom = e2.from;
            LayoutNode oldTo = e2.to;
            int oldRelativeFrom = e2.relativeFrom;
            int oldRelativeTo = e2.relativeTo;
            e2.from = oldTo;
            e2.to = oldFrom;
            e2.relativeFrom = oldRelativeTo;
            e2.relativeTo = oldRelativeFrom;
            oldFrom.succs.remove(e2);
            oldFrom.preds.add(e2);
            oldTo.preds.remove(e2);
            oldTo.succs.add(e2);
        }

        @Override
        public void postCheck() {
            for (LayoutNode n2 : HierarchicalLayout.this.nodes) {
                LinkedList<LayoutNode> queue = new LinkedList<LayoutNode>();
                for (LayoutEdge e2 : n2.succs) {
                    LayoutNode s2 = e2.to;
                    queue.add(s2);
                    this.visited.add(s2);
                }
                HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
                while (!queue.isEmpty()) {
                    LayoutNode curNode = (LayoutNode)queue.remove();
                    for (LayoutEdge e3 : curNode.succs) {
                        assert (e3.to != n2);
                        if (visited.contains(e3.to)) continue;
                        queue.add(e3.to);
                        visited.add(e3.to);
                    }
                }
            }
        }
    }

    private class BuildDatastructure
    extends AlgorithmPart {
        private BuildDatastructure() {
        }

        @Override
        protected void run() {
            Collection vertices = HierarchicalLayout.this.nodesSubset == null ? HierarchicalLayout.this.graph.getNodes() : HierarchicalLayout.this.nodesSubset;
            for (Object v2 : vertices) {
                LayoutNode node = new LayoutNode();
                Widget w2 = HierarchicalLayout.this.graph.getScene().findWidget(v2);
                assert (w2 != null);
                Rectangle r2 = w2.getBounds();
                if (r2 == null) {
                    r2 = w2.getPreferredBounds();
                }
                Dimension size = r2.getSize();
                node.width = (int)size.getWidth();
                node.height = (int)size.getHeight();
                node.vertex = v2;
                HierarchicalLayout.this.nodes.add(node);
                HierarchicalLayout.this.vertexToLayoutNode.put(v2, node);
            }
            Collection links = HierarchicalLayout.this.graph.getEdges();
            for (Object l2 : links) {
                LayoutEdge edge = new LayoutEdge();
                assert (HierarchicalLayout.this.vertexToLayoutNode.containsKey(HierarchicalLayout.this.graph.getEdgeSource(l2)));
                assert (HierarchicalLayout.this.vertexToLayoutNode.containsKey(HierarchicalLayout.this.graph.getEdgeTarget(l2)));
                if (HierarchicalLayout.this.invert) {
                    edge.to = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeSource(l2));
                    edge.from = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeTarget(l2));
                } else {
                    edge.from = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeSource(l2));
                    edge.to = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeTarget(l2));
                }
                Widget w3 = HierarchicalLayout.this.graph.getScene().findWidget(HierarchicalLayout.this.graph.getEdgeSource(l2));
                assert (w3 != null);
                Rectangle r3 = w3.getBounds();
                if (r3 == null) {
                    r3 = w3.getPreferredBounds();
                }
                Dimension size = r3.getSize();
                edge.relativeFrom = size.width / 2;
                w3 = HierarchicalLayout.this.graph.getScene().findWidget(HierarchicalLayout.this.graph.getEdgeTarget(l2));
                assert (w3 != null);
                r3 = w3.getBounds();
                if (r3 == null) {
                    r3 = w3.getPreferredBounds();
                }
                size = r3.getSize();
                edge.relativeTo = size.width / 2;
                edge.link = l2;
                edge.from.succs.add(edge);
                edge.to.preds.add(edge);
            }
        }

        @Override
        public void postCheck() {
            assert (HierarchicalLayout.this.vertexToLayoutNode.keySet().size() == HierarchicalLayout.this.nodes.size());
            assert (HierarchicalLayout.this.nodes.size() == HierarchicalLayout.this.graph.getNodes().size());
            for (Object v2 : HierarchicalLayout.this.graph.getNodes()) {
                LayoutNode node = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(v2);
                assert (node != null);
                for (LayoutEdge e2 : node.succs) {
                    assert (e2.from == node);
                }
                for (LayoutEdge e2 : node.preds) {
                    assert (e2.to == node);
                }
            }
        }
    }

    private abstract class AlgorithmPart {
        private AlgorithmPart() {
        }

        public void start() {
            long start = 0L;
            this.run();
        }

        protected abstract void run();

        protected void printStatistics() {
        }

        protected void postCheck() {
        }

        protected void preCheck() {
        }
    }

    private class LayoutEdge {
        public LayoutNode from;
        public LayoutNode to;
        public int relativeFrom;
        public int relativeTo;
        public E link;

        private LayoutEdge() {
        }
    }

    private class LayoutNode {
        public int x;
        public int y;
        public int width;
        public int height;
        public int layer = -1;
        public int xOffset;
        public int yOffset;
        public int bottomYOffset;
        public N vertex;
        public List<LayoutEdge> preds = new ArrayList<LayoutEdge>();
        public List<LayoutEdge> succs = new ArrayList<LayoutEdge>();
        public int pos = -1;
        public float crossingNumber;

        private LayoutNode() {
        }

        public String toString() {
            return "Node " + this.vertex;
        }
    }
}

