/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.GTPlanarizer;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MinimumBendOrthogonalizer;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.RectangularCompactor;

public class OrthogonalLayout<N, E>
extends GraphLayout<N, E> {
    private MGraph<N, E> mGraph = null;
    private GraphScene<N, E> scene = null;
    private final boolean animate;
    public static final int gutter = 55;
    public final int halfGutter = 27;

    public OrthogonalLayout(GraphScene<N, E> scene, boolean animate) {
        this.scene = scene;
        this.animate = animate;
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> graph) {
        this.mGraph = MGraph.createGraph(graph, this.scene);
        GTPlanarizer<N, E> planarizer = new GTPlanarizer<N, E>();
        Collection epgs = planarizer.planarize(this.mGraph);
        MinimumBendOrthogonalizer orthogonalizer = new MinimumBendOrthogonalizer();
        Collection ors = orthogonalizer.orthogonalize(epgs);
        RectangularCompactor compactor = new RectangularCompactor();
        compactor.compact(ors);
        this.layoutNodes();
    }

    private void layoutNodes() {
        Collection<E> edges = this.scene.getEdges();
        for (E e2 : edges) {
            ConnectionWidget conn = (ConnectionWidget)this.scene.findWidget(e2);
            conn.setRouter(RouterFactory.createOrthogonalSearchRouter(new LayerWidget[0]));
        }
        ArrayList<Widget> singletons = new ArrayList<Widget>();
        Collection<MGraph.Vertex<N>> vertices = this.mGraph.getVertices();
        int maxX = -1;
        int maxY = -1;
        for (MGraph.Vertex<N> v2 : vertices) {
            N node = v2.getNodeDesignElement();
            if (node == null) continue;
            Widget w2 = this.scene.findWidget(node);
            int x2 = (int)v2.getX();
            int y2 = (int)v2.getY();
            Point p2 = new Point(x2, y2);
            if (p2.x == 0 && p2.y == 0) {
                singletons.add(w2);
                continue;
            }
            if (this.animate) {
                this.scene.getSceneAnimator().animatePreferredLocation(w2, p2);
            }
            Rectangle bounds = w2.getBounds();
            w2.resolveBounds(p2, bounds);
            if (x2 + bounds.width > maxX) {
                maxX = x2 + bounds.width;
            }
            if (y2 + bounds.height <= maxY) continue;
            maxY = y2 + bounds.height;
        }
        if (singletons == null || singletons.size() == 0) {
            return;
        }
        Rectangle sceneBounds = this.scene.getBounds();
        if (sceneBounds.width > maxX) {
            maxX = sceneBounds.width;
        }
        int x3 = 0;
        int y3 = maxY + 27;
        int maxHeight = -1;
        for (Widget w3 : singletons) {
            Rectangle bounds = w3.getBounds();
            if (x3 + bounds.width > maxX) {
                x3 = 0;
                y3 = y3 + maxHeight + 27;
                maxHeight = -1;
            }
            Point p3 = new Point(x3, y3);
            if (this.animate) {
                this.scene.getSceneAnimator().animatePreferredLocation(w3, p3);
            }
            w3.resolveBounds(p3, bounds);
            x3 = x3 + bounds.width + 27;
            if (bounds.height <= maxHeight) continue;
            maxHeight = bounds.height;
        }
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> graph, Collection<N> nodes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

