/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.LayeredGraph;

public class BarycenterCrossingMinimizer {
    public <N, E> LayeredGraph<N, E> minimizeCrossings(LayeredGraph<N, E> graph) {
        List<List<DirectedGraph.Vertex<N>>> layers = graph.getLayers();
        if (layers.size() > 1) {
            int maxIteration = 2;
            for (int i2 = 0; i2 < maxIteration; ++i2) {
                this.minimizeCrossingsPhaseI(graph);
            }
            this.minimizeCrossingsPhaseII(graph);
        }
        return graph;
    }

    private <N, E> void minimizeCrossingsPhaseI(LayeredGraph<N, E> graph) {
        int i2;
        List<List<DirectedGraph.Vertex<N>>> layers = graph.getLayers();
        int size = layers.size();
        for (i2 = 0; i2 < size - 1; ++i2) {
            float[] lowerBarycenters = graph.computeLowerBarycenters(i2);
            List<DirectedGraph.Vertex<N>> lowerLayer = layers.get(i2 + 1);
            this.sortVertices(lowerLayer, lowerBarycenters, false);
        }
        for (i2 = size - 2; i2 >= 0; --i2) {
            float[] upperBarycenters = graph.computeUpperBarycenters(i2);
            List<DirectedGraph.Vertex<N>> upperLayer = layers.get(i2);
            this.sortVertices(upperLayer, upperBarycenters, false);
        }
    }

    private <N, E> void minimizeCrossingsPhaseII(LayeredGraph<N, E> graph) {
        int i2;
        List<List<DirectedGraph.Vertex<N>>> layers = graph.getLayers();
        int size = layers.size();
        for (i2 = size - 2; i2 >= 0; --i2) {
            float[] upperBarycenters = graph.computeUpperBarycenters(i2);
            List<DirectedGraph.Vertex<N>> upperLayer = layers.get(i2);
            this.sortVertices(upperLayer, upperBarycenters, true);
            this.minimizeCrossingsPhaseI(graph);
        }
        for (i2 = 0; i2 < size - 1; ++i2) {
            float[] lowerBarycenters = graph.computeLowerBarycenters(i2);
            List<DirectedGraph.Vertex<N>> lowerLayer = layers.get(i2 + 1);
            this.sortVertices(lowerLayer, lowerBarycenters, true);
            this.minimizeCrossingsPhaseI(graph);
        }
    }

    private <N> boolean sortVertices(List<DirectedGraph.Vertex<N>> vertices, float[] barycenters, boolean reverseEqualBarycenters) {
        int size = vertices.size();
        boolean changed = false;
        for (int i2 = 0; i2 < size - 1; ++i2) {
            for (int j2 = i2 + 1; j2 < size; ++j2) {
                DirectedGraph.Vertex<N> jv = vertices.get(j2);
                DirectedGraph.Vertex<N> iv = vertices.get(i2);
                float jbc = barycenters[j2];
                float ibc = barycenters[i2];
                boolean swap = false;
                if (reverseEqualBarycenters) {
                    if (jbc <= ibc) {
                        swap = true;
                    }
                } else if (jbc < ibc) {
                    swap = true;
                }
                if (!swap) continue;
                vertices.set(j2, iv);
                vertices.set(i2, jv);
                barycenters[j2] = ibc;
                barycenters[i2] = jbc;
                iv.setX(j2 + 1);
                jv.setX(i2 + 1);
                changed = true;
            }
        }
        return changed;
    }
}

