/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.LayeredGraph;

public class BarycenterXCoordinateAssigner {
    public <N, E> LayeredGraph<N, E> assignCoordinates(LayeredGraph<N, E> graph) {
        List<List<DirectedGraph.Vertex<N>>> layers = graph.getLayers();
        int size = layers.size();
        int maxIteration = 1;
        for (int iteration = 0; iteration < maxIteration; ++iteration) {
            int i2;
            for (i2 = 0; i2 < size - 1; ++i2) {
                float[] lowerBarycenters = graph.computeLowerBarycenters(i2);
                List<DirectedGraph.Vertex<N>> lowerLayer = graph.getLayer(i2 + 1);
                int[] upPriorities = this.computeUpPriorities(lowerLayer);
                this.moveVertices(lowerLayer, lowerBarycenters, upPriorities);
            }
            for (i2 = size - 2; i2 >= 0; --i2) {
                float[] upperBarycenters = graph.computeUpperBarycenters(i2);
                List<DirectedGraph.Vertex<N>> upperLayer = graph.getLayer(i2);
                int[] downPriorities = this.computeDownPriorities(upperLayer);
                this.moveVertices(upperLayer, upperBarycenters, downPriorities);
            }
        }
        return graph;
    }

    private <N> void moveVertices(List<DirectedGraph.Vertex<N>> layer, float[] barycenters, int[] priorities) {
        int size = layer.size();
        for (int i2 = 0; i2 < size; ++i2) {
            for (int j2 = 0; j2 < size; ++j2) {
                DirectedGraph.Vertex<N> kv;
                float khd;
                DirectedGraph.Vertex<N> jv = layer.get(j2);
                int jp = priorities[j2];
                float jbc = barycenters[j2];
                float jhd = jv.getX();
                if (!(jhd < jbc)) continue;
                int hpIndex = -1;
                for (int k2 = j2 + 1; k2 < size; ++k2) {
                    if (priorities[k2] < jp) continue;
                    hpIndex = k2;
                    break;
                }
                float nhd = jbc;
                float lastIndex = size;
                if (hpIndex != -1) {
                    lastIndex = hpIndex;
                    DirectedGraph.Vertex<N> hv = layer.get(hpIndex);
                    float hhd = hv.getX();
                    float spacing = (hhd - jhd) / (float)(hpIndex - j2);
                    if (!(spacing > 1.0f)) continue;
                    nhd = jhd + (spacing - 1.0f);
                    if (nhd > jbc) {
                        nhd = jbc;
                    }
                }
                if (nhd <= jhd) continue;
                jv.setX((int)nhd);
                float chd = nhd;
                int k3 = j2 + 1;
                while ((float)k3 < lastIndex && (khd = (float)(kv = layer.get(k3)).getX()) <= chd + 1.0f) {
                    kv.setX((int)(chd += 1.0f));
                    ++k3;
                }
            }
        }
    }

    private <N> int[] computeUpPriorities(List<DirectedGraph.Vertex<N>> layer) {
        DirectedGraph.Vertex<N> v2;
        int i2;
        int size = layer.size();
        int[] upPriorities = new int[size];
        int maxUpPriority = -1;
        for (i2 = 0; i2 < size; ++i2) {
            int upPriority;
            v2 = layer.get(i2);
            if (v2 instanceof DirectedGraph.DummyVertex) continue;
            upPriorities[i2] = upPriority = v2.getUpperNeighbors().size();
            if (upPriority <= maxUpPriority) continue;
            maxUpPriority = upPriority;
        }
        ++maxUpPriority;
        for (i2 = 0; i2 < size; ++i2) {
            v2 = layer.get(i2);
            if (!(v2 instanceof DirectedGraph.DummyVertex)) continue;
            upPriorities[i2] = maxUpPriority;
        }
        return upPriorities;
    }

    private <N> int[] computeDownPriorities(List<DirectedGraph.Vertex<N>> layer) {
        DirectedGraph.Vertex<N> v2;
        int i2;
        int size = layer.size();
        int[] downPriorities = new int[size];
        int maxDownPriority = -1;
        for (i2 = 0; i2 < size; ++i2) {
            int downPriority;
            v2 = layer.get(i2);
            if (v2 instanceof DirectedGraph.DummyVertex) continue;
            downPriorities[i2] = downPriority = v2.getLowerNeighbors().size();
            if (downPriority <= maxDownPriority) continue;
            maxDownPriority = downPriority;
        }
        ++maxDownPriority;
        for (i2 = 0; i2 < size; ++i2) {
            v2 = layer.get(i2);
            if (!(v2 instanceof DirectedGraph.DummyVertex)) continue;
            downPriorities[i2] = maxDownPriority;
        }
        return downPriorities;
    }
}

