/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;

public class LayeredGraph<N, E> {
    private DirectedGraph<N, E> originalGraph;
    private List<List<DirectedGraph.Vertex<N>>> layers;

    protected LayeredGraph(DirectedGraph<N, E> originalGraph) {
        this.originalGraph = originalGraph;
        this.layers = new ArrayList<List<DirectedGraph.Vertex<N>>>();
    }

    public static <N, E> LayeredGraph<N, E> createGraph(DirectedGraph<N, E> originalGraph) {
        LayeredGraph<N, E> graph = new LayeredGraph<N, E>(originalGraph);
        graph.createGraph();
        return graph;
    }

    protected void createGraph() {
        Collection<DirectedGraph.Vertex<N>> rootVertices = this.originalGraph.getRootVertices();
        for (DirectedGraph.Vertex<N> rootVertex : rootVertices) {
            this.assignLayers(rootVertex, 0);
        }
    }

    public DirectedGraph<N, E> getOriginalGraph() {
        return this.originalGraph;
    }

    private void assignLayers(DirectedGraph.Vertex<N> vertex, int index) {
        this.assignLayer(vertex, index);
        Collection<DirectedGraph.Vertex<N>> vertices = vertex.getLowerNeighbors();
        for (DirectedGraph.Vertex<N> nv : vertices) {
            int nvIndex = nv.getNumber();
            if (nvIndex > index) continue;
            this.assignLayers(nv, index + 1);
        }
    }

    public void assignLayer(DirectedGraph.Vertex<N> vertex, int index) {
        List<DirectedGraph.Vertex<N>> layer;
        int prevIndex = vertex.getNumber();
        if (prevIndex != -1) {
            layer = this.getLayer(prevIndex);
            layer.remove(vertex);
        }
        layer = this.getLayer(index);
        layer.add(vertex);
        vertex.setNumber(index);
        vertex.setY(index);
        vertex.setX(layer.size());
    }

    public List<List<DirectedGraph.Vertex<N>>> getLayers() {
        return this.layers;
    }

    public List<DirectedGraph.Vertex<N>> getLayer(int index) {
        int size = this.layers.size();
        if (index >= size) {
            for (int i2 = size; i2 <= index; ++i2) {
                this.layers.add(new ArrayList());
            }
        }
        return this.layers.get(index);
    }

    public boolean[][] computeAdjacencyMatrix(int upperLayerIndex) {
        List<DirectedGraph.Vertex<N>> upperLayer = this.layers.get(upperLayerIndex);
        List<DirectedGraph.Vertex<N>> lowerLayer = this.layers.get(upperLayerIndex + 1);
        int upperLayerSize = upperLayer.size();
        int lowerLayerSize = lowerLayer.size();
        boolean[][] matrix = new boolean[upperLayerSize][lowerLayerSize];
        for (int j2 = 0; j2 < upperLayerSize; ++j2) {
            DirectedGraph.Vertex<N> v2 = upperLayer.get(j2);
            if (v2 == null) continue;
            Collection<DirectedGraph.Vertex<N>> vertices = v2.getLowerNeighbors();
            for (DirectedGraph.Vertex<N> nv : vertices) {
                int k2 = lowerLayer.indexOf(nv);
                if (k2 <= -1) continue;
                matrix[j2][k2] = true;
            }
        }
        return matrix;
    }

    public float[] computeLowerBarycenters(int upperLayerIndex) {
        boolean[][] matrix = this.computeAdjacencyMatrix(upperLayerIndex);
        List<DirectedGraph.Vertex<N>> upperLayer = this.layers.get(upperLayerIndex);
        List<DirectedGraph.Vertex<N>> lowerLayer = this.layers.get(upperLayerIndex + 1);
        int upperLayerSize = upperLayer.size();
        int lowerLayerSize = lowerLayer.size();
        float[] lowerBarycenters = new float[lowerLayerSize];
        float[] barycenters = new float[lowerLayerSize];
        for (int k2 = 0; k2 < lowerLayerSize; ++k2) {
            float sum = 0.0f;
            float count = 0.0f;
            for (int j2 = 0; j2 < upperLayerSize; ++j2) {
                if (!matrix[j2][k2]) continue;
                DirectedGraph.Vertex<N> jv = upperLayer.get(j2);
                sum += (float)jv.getX();
                count += 1.0f;
            }
            DirectedGraph.Vertex<N> kv = lowerLayer.get(k2);
            lowerBarycenters[k2] = sum / count;
        }
        return lowerBarycenters;
    }

    public float[] computeUpperBarycenters(int upperLayerIndex) {
        boolean[][] matrix = this.computeAdjacencyMatrix(upperLayerIndex);
        List<DirectedGraph.Vertex<N>> upperLayer = this.layers.get(upperLayerIndex);
        List<DirectedGraph.Vertex<N>> lowerLayer = this.layers.get(upperLayerIndex + 1);
        int upperLayerSize = upperLayer.size();
        int lowerLayerSize = lowerLayer.size();
        float[] upperBarycenters = new float[upperLayerSize];
        for (int j2 = 0; j2 < upperLayerSize; ++j2) {
            float sum = 0.0f;
            float count = 0.0f;
            for (int k2 = 0; k2 < lowerLayerSize; ++k2) {
                if (!matrix[j2][k2]) continue;
                DirectedGraph.Vertex<N> kv = lowerLayer.get(k2);
                sum += (float)kv.getX();
                count += 1.0f;
            }
            DirectedGraph.Vertex<N> jv = upperLayer.get(j2);
            upperBarycenters[j2] = sum / count;
        }
        return upperBarycenters;
    }
}

