/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.UniversalGraph;

public class MixedGraph<N, E> {
    private Collection<N> nodes;
    private Map<N, Vertex<N>> vertexMap;
    private GraphScene<N, E> scene;
    private UniversalGraph<N, E> uGraph;
    private Collection<E> edges;

    private MixedGraph(UniversalGraph<N, E> uGraph, GraphScene<N, E> scene) {
        this.uGraph = uGraph;
        this.scene = scene;
        this.nodes = uGraph.getNodes();
        this.edges = uGraph.getEdges();
        this.vertexMap = new HashMap<N, Vertex<N>>();
    }

    public static <N, E> MixedGraph<N, E> createGraph(UniversalGraph<N, E> uGraph, GraphScene<N, E> scene) {
        MixedGraph<N, E> graph = new MixedGraph<N, E>(uGraph, scene);
        graph.createGraph();
        return graph;
    }

    protected void createGraph() {
        for (E e2 : this.edges) {
            N source = this.uGraph.getEdgeSource(e2);
            N target = this.uGraph.getEdgeTarget(e2);
            Vertex<N> sourceVertex = this.getVertex(source);
            Vertex<N> targetVertex = this.getVertex(target);
            sourceVertex.addUpperNeighbor(targetVertex);
            targetVertex.addLowerNeighbor(sourceVertex);
            targetVertex.addNeighbor(sourceVertex);
        }
        for (Object node : this.nodes) {
            Vertex<Object> vertex = this.getVertex(node);
        }
    }

    public Collection<Vertex<N>> getVertices() {
        return this.vertexMap.values();
    }

    private Vertex<N> getVertex(N node) {
        Vertex<N> vertex = this.vertexMap.get(node);
        if (vertex == null) {
            vertex = new Vertex<N>(node);
            this.vertexMap.put(node, vertex);
        }
        return vertex;
    }

    private void printGraph() {
        for (Vertex<N> v2 : this.getVertices()) {
            System.out.println("vertex = " + v2);
            Collection<Vertex<?>> vertices = v2.getNeighbors();
            for (Vertex<?> nv : vertices) {
                System.out.println("\tneighbor = " + nv);
            }
        }
    }

    public static class Vertex<N> {
        private N node;
        private ArrayList<Vertex<?>> upperNeighbors;
        private ArrayList<Vertex<?>> lowerNeighbors;
        private ArrayList<Vertex<?>> neighbors;
        private Object vertexData;

        public Vertex(N node) {
            this.node = node;
            this.neighbors = new ArrayList();
        }

        public void addNeighbor(Vertex<?> vertex) {
            this.neighbors.add(vertex);
        }

        public void removeNeighbor(Vertex<?> vertex) {
            this.neighbors.remove(vertex);
        }

        public void addLowerNeighbor(Vertex<?> vertex) {
            if (!this.lowerNeighbors.contains(vertex)) {
                this.lowerNeighbors.add(vertex);
            }
        }

        public void removeLowerNeighbor(Vertex<?> vertex) {
            this.lowerNeighbors.remove(vertex);
        }

        public Collection<Vertex<?>> getLowerNeighbors() {
            return Collections.unmodifiableCollection(this.lowerNeighbors);
        }

        public void addUpperNeighbor(Vertex<?> vertex) {
            if (!this.upperNeighbors.contains(vertex)) {
                this.upperNeighbors.add(vertex);
            }
        }

        public void removeUpperNeighbor(Vertex<?> vertex) {
            this.upperNeighbors.remove(vertex);
        }

        public Collection<Vertex<?>> getUpperNeighbors() {
            return Collections.unmodifiableCollection(this.upperNeighbors);
        }

        public Collection<Vertex<?>> getNeighbors() {
            return this.neighbors;
        }

        public N getNodeDesignElement() {
            return this.node;
        }

        public int getDegree() {
            return this.neighbors.size();
        }

        public void setVertexData(Object data) {
            this.vertexData = data;
        }

        public Object getVertexData() {
            return this.vertexData;
        }

        public String toString() {
            return super.toString() + " : " + this.node;
        }
    }
}

