/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.OrthogonalRepresentation;

public class DirectionalGraph<N, E> {
    private OrthogonalRepresentation<N, E> or;
    private MGraph.Edge.Direction direction;
    private MGraph.Edge.Direction barDirection;
    private List<Bar> bars;
    private Map<MGraph.Vertex<?>, Bar> barMap;
    private Set<MGraph.Edge<?>> visitedEdges;
    private Map<MGraph.Vertex<?>, MGraph.Edge<?>> forwardEdges;
    private Map<MGraph.Vertex<?>, MGraph.Edge<?>> reverseEdges;

    public static <N, E> DirectionalGraph<N, E> createGraph(OrthogonalRepresentation<N, E> or, MGraph.Edge.Direction direction) {
        DirectionalGraph<N, E> graph = new DirectionalGraph<N, E>(or, direction);
        super.createGraph();
        return graph;
    }

    private DirectionalGraph(OrthogonalRepresentation<N, E> or, MGraph.Edge.Direction direction) {
        this.or = or;
        this.barMap = new HashMap();
        this.bars = new ArrayList<Bar>();
        this.visitedEdges = new HashSet();
        this.forwardEdges = new HashMap();
        this.reverseEdges = new HashMap();
        this.direction = direction;
        this.barDirection = direction == MGraph.Edge.Direction.HORIZONTAL ? MGraph.Edge.Direction.VERTICAL : MGraph.Edge.Direction.HORIZONTAL;
    }

    private void createGraph() {
        MGraph.Vertex<?> cornerVertex = this.getCornerVertex();
        Collection<MGraph.Vertex<?>> rootVertices = this.getRootVertices(cornerVertex);
        this.assignEdgeDirections(rootVertices, new HashSet());
        this.visitedEdges.clear();
        this.createBar(cornerVertex, null);
        this.computeTopologicalNumbering();
    }

    private void assignEdgeDirections(Collection<MGraph.Vertex<?>> vertices, Set<MGraph.Vertex<?>> skippedVertices) {
        ArrayList oppositeVertices = new ArrayList();
        for (MGraph.Vertex<?> v2 : vertices) {
            Collection<MGraph.Edge<?>> collection = v2.getEdges();
            for (MGraph.Edge<?> e2 : collection) {
                if (e2.getDirection() != this.direction || this.reverseEdges.get(v2) == e2) continue;
                this.forwardEdges.put(v2, e2);
                MGraph.Vertex<?> w2 = e2.getOppositeVertex(v2);
                this.reverseEdges.put(w2, e2);
                oppositeVertices.add(w2);
            }
        }
        if (!oppositeVertices.isEmpty()) {
            LinkedHashSet additionalVertices = new LinkedHashSet();
            block2: for (MGraph.Vertex vertex : oppositeVertices) {
                ArrayList prevVertices = new ArrayList();
                Set<MGraph.Vertex<?>> parentVertices = this.computeParentVertices(vertex);
                Collection<MGraph.Edge<?>> edges = vertex.getEdges();
                for (MGraph.Edge<?> e3 : edges) {
                    if (e3.getDirection() != this.barDirection) continue;
                    MGraph.Vertex<?> currentVertex = e3.getOppositeVertex(vertex);
                    MGraph.Edge<?> prevEdge = e3;
                    boolean terminate = false;
                    while (!(oppositeVertices.contains(currentVertex) || additionalVertices.contains(currentVertex) || skippedVertices.contains(currentVertex))) {
                        if (!this.containsReverseEdge(currentVertex, new HashSet()) && !this.reachableToParentVertex(currentVertex, parentVertices, new HashSet())) {
                            additionalVertices.add(currentVertex);
                            prevVertices.add(currentVertex);
                            boolean found = false;
                            Collection<MGraph.Edge<?>> nextEdges = currentVertex.getEdges();
                            for (MGraph.Edge<?> nextEdge : nextEdges) {
                                if (nextEdge == prevEdge || nextEdge.getDirection() != this.barDirection) continue;
                                currentVertex = nextEdge.getOppositeVertex(currentVertex);
                                prevEdge = nextEdge;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            break;
                        }
                        additionalVertices.removeAll(prevVertices);
                        skippedVertices.add(vertex);
                        terminate = true;
                        break;
                    }
                    if (!terminate) continue;
                    continue block2;
                }
            }
            oppositeVertices.addAll(additionalVertices);
            this.assignEdgeDirections(oppositeVertices, skippedVertices);
        }
    }

    private Set<MGraph.Vertex<?>> computeParentVertices(MGraph.Vertex<?> v2) {
        HashSet parentVertices = new HashSet();
        MGraph.Edge<?> reverseEdge = this.reverseEdges.get(v2);
        MGraph.Vertex<?> currentVertex = v2;
        while (reverseEdge != null) {
            MGraph.Vertex<?> parentVertex = reverseEdge.getOppositeVertex(currentVertex);
            parentVertices.add(parentVertex);
            currentVertex = parentVertex;
            reverseEdge = this.reverseEdges.get(currentVertex);
        }
        return parentVertices;
    }

    private boolean containsReverseEdge(MGraph.Vertex<?> v2, Set<MGraph.Edge<?>> visitedEdges) {
        Collection<MGraph.Edge<?>> edges = v2.getEdges();
        for (MGraph.Edge<?> e2 : edges) {
            if (e2.getDirection() != this.direction || visitedEdges.contains(e2)) continue;
            visitedEdges.add(e2);
            if (this.reverseEdges.get(v2) == e2) {
                return true;
            }
            if (!this.containsReverseEdge(e2.getOppositeVertex(v2), visitedEdges)) continue;
            return true;
        }
        return false;
    }

    private boolean reachableToParentVertex(MGraph.Vertex<?> v2, Set<MGraph.Vertex<?>> parentVertices, Set<MGraph.Edge<?>> visitedEdges) {
        Collection<MGraph.Edge<?>> edges = v2.getEdges();
        for (MGraph.Edge<?> e2 : edges) {
            if (e2.getDirection() != this.direction || visitedEdges.contains(e2)) continue;
            visitedEdges.add(e2);
            MGraph.Vertex<?> w2 = e2.getOppositeVertex(v2);
            if (!this.checkSideway(w2, parentVertices, visitedEdges) && !this.reachableToParentVertex(w2, parentVertices, visitedEdges)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSideway(MGraph.Vertex<?> v2, Set<MGraph.Vertex<?>> parentVertices, Set<MGraph.Edge<?>> visitedEdges) {
        Collection<MGraph.Edge<?>> edges = v2.getEdges();
        block0: for (MGraph.Edge<?> e2 : edges) {
            if (e2.getDirection() != this.barDirection || visitedEdges.contains(e2)) continue;
            visitedEdges.add(e2);
            MGraph.Vertex<?> currentVertex = e2.getOppositeVertex(v2);
            while (!parentVertices.contains(currentVertex)) {
                MGraph.Edge<?> nextEdge = null;
                Collection<MGraph.Edge<?>> edges2 = currentVertex.getEdges();
                for (MGraph.Edge<?> ce : edges2) {
                    if (ce.getDirection() != this.barDirection || visitedEdges.contains(ce)) continue;
                    visitedEdges.add(ce);
                    nextEdge = ce;
                    break;
                }
                if (nextEdge == null) continue block0;
                currentVertex = nextEdge.getOppositeVertex(currentVertex);
            }
            return true;
        }
        return false;
    }

    private Bar createBar(MGraph.Vertex<?> vertex, Bar parentBar) {
        Bar bar = this.barMap.get(vertex);
        if (bar == null) {
            bar = new Bar(this.barDirection);
            this.bars.add(bar);
            bar.addVertex(vertex);
            this.barMap.put(vertex, bar);
            Collection<MGraph.Edge<?>> edges = vertex.getEdges();
            block0: for (MGraph.Edge<?> edge : edges) {
                if (edge.getDirection() != this.barDirection) continue;
                MGraph.Vertex<?> currentVertex = edge.getOppositeVertex(vertex);
                MGraph.Edge<?> prevEdge = edge;
                while (true) {
                    bar.addVertex(currentVertex);
                    this.barMap.put(currentVertex, bar);
                    MGraph.Edge<?> foundEdge = null;
                    Collection<MGraph.Edge<?>> edges2 = currentVertex.getEdges();
                    for (MGraph.Edge<?> e2 : edges2) {
                        if (e2 == prevEdge || e2.getDirection() != this.barDirection) continue;
                        foundEdge = e2;
                        break;
                    }
                    if (foundEdge == null) continue block0;
                    prevEdge = foundEdge;
                    currentVertex = foundEdge.getOppositeVertex(currentVertex);
                }
            }
            for (MGraph.Vertex vertex2 : bar.getVertices()) {
                Collection<MGraph.Edge<?>> edges2 = vertex2.getEdges();
                for (MGraph.Edge<?> e3 : edges2) {
                    if (e3.getDirection() != this.direction || this.forwardEdges.get(vertex2) != e3 || this.visitedEdges.contains(e3)) continue;
                    this.visitedEdges.add(e3);
                    Bar neighbor = this.createBar(e3.getOppositeVertex(vertex2), bar);
                    if (neighbor == parentBar) continue;
                    bar.addNeighbor(neighbor);
                }
            }
        }
        return bar;
    }

    public Collection<Bar> getBars() {
        return this.bars;
    }

    private Collection<MGraph.Vertex<?>> getRootVertices(MGraph.Vertex<?> cornerVertex) {
        ArrayList rootVertices = new ArrayList();
        MGraph.Vertex<?> currentVertex = cornerVertex;
        MGraph.Edge<?> prevEdge = null;
        rootVertices.add(cornerVertex);
        while (true) {
            MGraph.Edge<?> foundEdge = null;
            Collection<MGraph.Edge<?>> edges = currentVertex.getEdges();
            for (MGraph.Edge<?> e2 : edges) {
                if (e2 == prevEdge || e2.getDirection() != this.barDirection) continue;
                foundEdge = e2;
                break;
            }
            if (foundEdge == null) break;
            prevEdge = foundEdge;
            currentVertex = foundEdge.getOppositeVertex(currentVertex);
            rootVertices.add(currentVertex);
        }
        return rootVertices;
    }

    private MGraph.Vertex<?> getCornerVertex() {
        MGraph.Vertex<N> cornerVertex = this.or.getCornerVertex();
        if (cornerVertex != null) {
            return cornerVertex;
        }
        EmbeddedPlanarGraph<N, E> epg = this.or.getOriginalGraph();
        Face outerFace = epg.getOuterFace();
        List<MGraph.Vertex<?>> vertices = outerFace.getVertices();
        MGraph.Vertex<?> candidate1 = null;
        MGraph.Vertex<?> candidate2 = null;
        MGraph.Vertex<?> candidate3 = null;
        for (MGraph.Vertex<?> v2 : vertices) {
            int hEdgeCount = 0;
            int vEdgeCount = 0;
            Collection<MGraph.Edge<?>> edges = v2.getEdges();
            for (MGraph.Edge<?> e2 : edges) {
                MGraph.Edge.Direction direction = e2.getDirection();
                if (direction == MGraph.Edge.Direction.HORIZONTAL) {
                    ++hEdgeCount;
                    continue;
                }
                ++vEdgeCount;
            }
            if (hEdgeCount == 1 && vEdgeCount == 1) {
                if (candidate1 != null) continue;
                candidate1 = v2;
                continue;
            }
            if (hEdgeCount == 1 && vEdgeCount == 0 && this.direction == MGraph.Edge.Direction.HORIZONTAL || hEdgeCount == 0 && vEdgeCount == 1 && this.direction == MGraph.Edge.Direction.VERTICAL) {
                if (candidate2 != null) continue;
                candidate2 = v2;
                continue;
            }
            if ((hEdgeCount != 1 || vEdgeCount != 0) && (hEdgeCount != 0 || vEdgeCount != 1)) continue;
            candidate3 = v2;
        }
        if (candidate1 != null) {
            return candidate1;
        }
        if (candidate2 != null) {
            return candidate2;
        }
        if (candidate3 != null) {
            return candidate3;
        }
        return null;
    }

    public void computeTopologicalNumbering() {
        int offset = 0;
        if (this.or.getCornerVertex() != null) {
            offset = -1;
        }
        Bar sourceBar = this.bars.get(0);
        sourceBar.setNumber(offset);
        for (Bar bar : this.bars) {
            if (bar == sourceBar) continue;
            int length = this.computeLongestPathLength(sourceBar, bar);
            bar.setNumber(length + offset);
        }
    }

    private int computeLongestPathLength(Bar sourceBar, Bar destinationBar) {
        if (sourceBar == destinationBar) {
            return 0;
        }
        int maxLength = -1;
        for (Bar n2 : sourceBar.getNeighbors()) {
            int length;
            if (n2.equals(sourceBar) || (length = this.computeLongestPathLength(n2, destinationBar)) == -1 || ++length <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    public String toString() {
        String s2 = (Object)((Object)this.direction) + " Graph:\n";
        for (Bar b2 : this.getBars()) {
            s2 = s2 + b2;
        }
        return s2;
    }

    public static class Bar
    implements Comparable<Object> {
        private Collection<MGraph.Vertex<?>> vertices;
        private Collection<Bar> neighbors;
        private MGraph.Edge.Direction direction;
        private int number;

        public Bar(MGraph.Edge.Direction direction) {
            this.direction = direction;
            this.vertices = new ArrayList();
            this.neighbors = new HashSet<Bar>();
        }

        public void addVertex(MGraph.Vertex<?> vertex) {
            this.vertices.add(vertex);
            Dimension d2 = vertex.getSize();
            this.checkMaximumSize(d2);
        }

        private void checkMaximumSize(Dimension d2) {
            if (this.direction.equals((Object)MGraph.Edge.Direction.HORIZONTAL)) {
                // empty if block
            }
        }

        public void resolveGrid() {
        }

        public Collection<MGraph.Vertex<?>> getVertices() {
            return this.vertices;
        }

        public void addNeighbor(Bar neighbor) {
            this.neighbors.add(neighbor);
        }

        public Collection<Bar> getNeighbors() {
            return this.neighbors;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }

        public String toString() {
            String s2 = "\t" + (Object)((Object)this.direction) + " Bar:\n";
            s2 = s2 + "\t\tNumber = " + this.number + "\n";
            s2 = s2 + "\t\tVertices:\n";
            for (MGraph.Vertex<?> v2 : this.vertices) {
                s2 = s2 + "\t\t\t" + v2 + "\n";
            }
            s2 = s2 + "\t\tNeighbors =" + this.neighbors.size() + "\n";
            for (Bar n2 : this.neighbors) {
                s2 = s2 + "\t\t\t Bar " + n2.getNumber() + "\n";
            }
            return s2;
        }

        @Override
        public int compareTo(Object o2) {
            if (!(o2 instanceof Bar)) {
                return 0;
            }
            Bar b2 = (Bar)o2;
            return this.number > b2.getNumber() ? 1 : -1;
        }
    }
}

