/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class DualGraph<N, E> {
    private EmbeddedPlanarGraph<N, E> originalGraph;
    private Map<Face, FaceVertex> vertexMap;
    private Collection<FaceVertex> vertices;
    private Map<MGraph.Edge<?>, FaceEdge> edgeMap;
    private Collection<FaceEdge> edges;
    private Collection<MGraph.Edge<?>> edgesToIgnore;
    private Collection<Face> facesToIgnore;

    public static <N, E> DualGraph<N, E> createGraph(EmbeddedPlanarGraph<N, E> graph, Collection<Face> facesToIgnore, Collection<MGraph.Edge<?>> edgesToIgnore) {
        DualGraph<N, E> dualGraph = new DualGraph<N, E>(graph, facesToIgnore, edgesToIgnore);
        super.createGraph();
        return dualGraph;
    }

    private DualGraph(EmbeddedPlanarGraph<N, E> graph, Collection<Face> facesToIgnore, Collection<MGraph.Edge<?>> edgesToIgnore) {
        this.originalGraph = graph;
        this.facesToIgnore = facesToIgnore;
        this.edgesToIgnore = edgesToIgnore;
        this.vertexMap = new HashMap<Face, FaceVertex>();
        this.vertices = new ArrayList<FaceVertex>();
        this.edgeMap = new HashMap();
        this.edges = new ArrayList<FaceEdge>();
    }

    private void createGraph() {
        this.createFaces();
        this.createEdges();
    }

    private void createFaces() {
        for (Face f2 : this.originalGraph.getFaces()) {
            if (this.facesToIgnore.contains(f2) && !f2.isOuterFace()) continue;
            this.getVertex(f2);
        }
    }

    private void createEdges() {
        for (FaceVertex fv : this.getVertices()) {
            for (FaceVertex gv : this.getVertices()) {
                if (fv == gv) continue;
                for (MGraph.Edge<?> e2 : fv.getFace().getEdges()) {
                    if (this.edgesToIgnore.contains(e2) || !gv.getFace().containsEdge(e2)) continue;
                    FaceEdge faceEdge = this.getEdge(fv, gv, e2);
                    fv.addEdge(faceEdge);
                }
            }
        }
    }

    public void updateFaces() {
        int vertexCount;
        int faceCount = this.originalGraph.getFaces().size();
        if (faceCount > (vertexCount = this.vertices.size())) {
            this.createFaces();
        } else if (faceCount < vertexCount) {
            this.vertices.clear();
            this.vertexMap.clear();
            this.createFaces();
        }
    }

    public void updateEdges() {
        this.edges.clear();
        this.edgeMap.clear();
        for (FaceVertex fv : this.getVertices()) {
            fv.getEdges().clear();
        }
        this.createEdges();
    }

    public EmbeddedPlanarGraph<N, E> getOriginalGraph() {
        return this.originalGraph;
    }

    public Collection<FaceVertex> getVertices() {
        return this.vertices;
    }

    public Collection<FaceEdge> getEdges() {
        return this.edges;
    }

    private FaceVertex getVertex(Face face) {
        FaceVertex vertex = this.vertexMap.get(face);
        if (vertex == null) {
            vertex = new FaceVertex(face);
            this.vertexMap.put(face, vertex);
            this.vertices.add(vertex);
        }
        return vertex;
    }

    private FaceEdge getEdge(FaceVertex f2, FaceVertex g2, MGraph.Edge<?> e2) {
        FaceEdge edge = this.edgeMap.get(e2);
        if (edge == null) {
            edge = new FaceEdge(f2, g2, e2);
            this.edgeMap.put(e2, edge);
            this.edges.add(edge);
        }
        return edge;
    }

    public Collection<FaceVertex> getVerticesBorderingEdge(MGraph.Edge<?> e2) {
        ArrayList<FaceVertex> result = new ArrayList<FaceVertex>();
        for (FaceVertex v2 : this.getVertices()) {
            if (!v2.getFace().containsEdge(e2)) continue;
            result.add(v2);
        }
        return result;
    }

    public String toString() {
        String s2 = "DualGraph:\n";
        s2 = s2 + "vertices:\n";
        for (FaceVertex fv : this.vertices) {
            s2 = s2 + "\t" + fv + "\n";
        }
        s2 = s2 + "edges\n";
        for (FaceEdge fe : this.edges) {
            s2 = s2 + "\t" + fe + "\n";
        }
        return s2;
    }

    public static class FaceEdge {
        private FaceVertex f;
        private FaceVertex g;
        private MGraph.Edge<?> edge;

        public FaceEdge(FaceVertex f2, FaceVertex g2, MGraph.Edge<?> e2) {
            this.f = f2;
            this.g = g2;
            this.edge = e2;
        }

        public FaceVertex getF() {
            return this.f;
        }

        public FaceVertex getG() {
            return this.g;
        }

        public MGraph.Edge<?> getEdge() {
            return this.edge;
        }

        public boolean contains(FaceVertex v2) {
            return this.f == v2 || this.g == v2;
        }

        public FaceVertex getOppositeVertex(FaceVertex v2) {
            if (v2 == this.f) {
                return this.g;
            }
            if (v2 == this.g) {
                return this.f;
            }
            return null;
        }

        public FaceVertex getVertex(MGraph.Vertex<?> v2) {
            if (this.f.face.containsVertex(v2)) {
                return this.f;
            }
            if (this.g.face.containsVertex(v2)) {
                return this.g;
            }
            return null;
        }

        public String toString() {
            String s2 = "FaceEdge:\n";
            s2 = s2 + "\t" + this.f + "\n";
            s2 = s2 + "\t" + this.g + "\n";
            s2 = s2 + "\t" + this.edge + "\n";
            return s2;
        }
    }

    public static class FaceVertex {
        private Face face;
        private Collection<FaceEdge> edges;

        public FaceVertex(Face face) {
            this.face = face;
            this.edges = new LinkedHashSet<FaceEdge>();
        }

        public Face getFace() {
            return this.face;
        }

        public Collection<FaceEdge> getEdges() {
            return this.edges;
        }

        public void addEdge(FaceEdge edge) {
            if (!this.edges.contains(edge)) {
                this.edges.add(edge);
            }
        }

        public String toString() {
            return "FaceVertex: " + this.face.toString();
        }
    }
}

