/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class EmbeddedPlanarGraph<N, E> {
    private MGraph<N, E> originalGraph;
    private ArrayList<Face> faces;

    public static <N, E> EmbeddedPlanarGraph<N, E> createGraph(MGraph<N, E> graph) {
        return new EmbeddedPlanarGraph<N, E>(graph);
    }

    private EmbeddedPlanarGraph(MGraph<N, E> graph) {
        this.originalGraph = graph;
        this.faces = new ArrayList();
    }

    public MGraph<N, E> getOriginalGraph() {
        return this.originalGraph;
    }

    public ArrayList<Face> getFaces() {
        return this.faces;
    }

    public void addFace(Face newFace) {
        if (!this.faces.contains(newFace)) {
            this.faces.add(newFace);
        }
    }

    public void addFaces(Collection<Face> newFaces) {
        this.faces.addAll(newFaces);
    }

    public void removeFace(Face faceToRemove) {
        this.faces.remove(faceToRemove);
    }

    public void removeFaces(Collection<Face> facesToRemove) {
        this.faces.removeAll(facesToRemove);
    }

    public Face getOppositeFace(Face face, Face.Dart dart) {
        for (Face f2 : this.faces) {
            if (f2 == face || !f2.containsEdge(dart.getEdge())) continue;
            return f2;
        }
        return null;
    }

    public Face getOuterFace() {
        for (Face face : this.faces) {
            if (!face.isOuterFace()) continue;
            return face;
        }
        return null;
    }
}

