/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class Face {
    private List<MGraph.Edge<?>> edges = new ArrayList();
    private Set<MGraph.Edge<?>> edgeMap = new HashSet();
    private List<Dart> darts = new ArrayList<Dart>();
    private Set<Dart> dartMap = new HashSet<Dart>();
    private Map<Dart, Integer> dartIndices = new HashMap<Dart, Integer>();
    private boolean isOuterFace;

    public int getDegree() {
        return this.edges.size();
    }

    public void setOuterFace(boolean flag) {
        this.isOuterFace = flag;
    }

    public boolean isOuterFace() {
        return this.isOuterFace;
    }

    public List<MGraph.Vertex<?>> getVertices() {
        ArrayList vertices = new ArrayList();
        List<Dart> _darts = this.getDarts();
        for (Dart dart : _darts) {
            vertices.add(dart.getV());
        }
        return vertices;
    }

    public void addEdge(MGraph.Edge<?> edge) {
        this.edgeMap.add(edge);
        this.edges.add(edge);
    }

    public void addEdges(Collection<MGraph.Edge<?>> newEdges) {
        this.edges.addAll(newEdges);
        this.edgeMap.addAll(newEdges);
    }

    private void addEdge(int index, MGraph.Edge<?> newEdge) {
        this.edges.add(index, newEdge);
        this.edgeMap.add(newEdge);
    }

    private void removeEdge(MGraph.Edge<?> edgeToRemove) {
        this.edges.remove(edgeToRemove);
        if (!this.edges.contains(edgeToRemove)) {
            this.edgeMap.remove(edgeToRemove);
        }
    }

    private void removeEdge(int index) {
        MGraph.Edge<?> removedEdge = this.edges.remove(index);
        if (!this.edges.contains(removedEdge)) {
            this.edgeMap.remove(removedEdge);
        }
    }

    public List<MGraph.Edge<?>> getEdges() {
        return Collections.unmodifiableList(this.edges);
    }

    public MGraph.Edge<?> getBorderingEdge(Face face) {
        for (MGraph.Edge<?> e2 : face.getEdges()) {
            if (!this.edgeMap.contains(e2)) continue;
            return e2;
        }
        return null;
    }

    public List<Dart> replaceEdge(MGraph.Edge<?> edgeToReplace, Collection<MGraph.Edge<?>> newEdges) {
        HashSet newEdgeSet = new HashSet(newEdges);
        ArrayList<Dart> newDarts = new ArrayList<Dart>();
        Dart dartToReplace = this.getDart(edgeToReplace);
        MGraph.Vertex<?> v2 = dartToReplace.getV();
        MGraph.Vertex<?> w2 = dartToReplace.getW();
        int index = this.getDartIndex(dartToReplace);
        this.removeEdge(index);
        this.removeDart(index);
        while (v2 != w2) {
            MGraph.Edge<?> newEdge = this.searchAndRemoveEdge(v2, newEdgeSet);
            MGraph.Vertex<?> ov = newEdge.getOppositeVertex(v2);
            Dart newDart = new Dart(v2, ov, newEdge);
            this.addEdge(index, newEdge);
            this.addDart(index, newDart);
            newDarts.add(newDart);
            ++index;
            v2 = ov;
        }
        return newDarts;
    }

    public List<Dart> replaceDart(Dart dartToReplace, Collection<MGraph.Edge<?>> newEdges) {
        HashSet newEdgeSet = new HashSet(newEdges);
        ArrayList<Dart> newDarts = new ArrayList<Dart>();
        MGraph.Vertex<?> v2 = dartToReplace.getV();
        MGraph.Vertex<?> w2 = dartToReplace.getW();
        int index = this.getDartIndex(dartToReplace);
        this.removeEdge(index);
        this.removeDart(index);
        while (v2 != w2) {
            MGraph.Edge<?> newEdge = this.searchAndRemoveEdge(v2, newEdgeSet);
            MGraph.Vertex<?> ov = newEdge.getOppositeVertex(v2);
            Dart newDart = new Dart(v2, ov, newEdge);
            this.addEdge(index, newEdge);
            this.addDart(index, newDart);
            newDarts.add(newDart);
            ++index;
            v2 = ov;
        }
        return newDarts;
    }

    public List<Dart> replaceDarts(MGraph.Edge<?> edgeToAdd) {
        return this.replaceDarts(edgeToAdd, null);
    }

    public List<Dart> replaceDarts(MGraph.Edge<?> edgeToAdd, MGraph.Vertex<?> startingVertex) {
        ArrayList<Dart> removedDarts = new ArrayList<Dart>();
        MGraph.Vertex<?> v2 = null;
        MGraph.Vertex<?> w2 = null;
        if (startingVertex == null) {
            v2 = edgeToAdd.getV();
            w2 = edgeToAdd.getW();
        } else {
            v2 = startingVertex;
            w2 = edgeToAdd.getOppositeVertex(v2);
        }
        List<Dart> dartsTo = this.getDartsTo(v2);
        if (dartsTo.isEmpty()) {
            return removedDarts;
        }
        Dart firstDart = dartsTo.get(dartsTo.size() - 1);
        if (firstDart == null) {
            return removedDarts;
        }
        Dart lastDart = this.getDartFrom(w2);
        Dart currentDart = this.getNextDart(firstDart);
        while (currentDart != lastDart) {
            int index = this.darts.indexOf(currentDart);
            currentDart = this.getNextDart(currentDart);
            this.removeEdge(index);
            removedDarts.add(this.darts.get(index));
            this.removeDart(index);
        }
        Dart newDart = new Dart(v2, w2, edgeToAdd);
        int index = this.getDartIndex(firstDart) + 1;
        this.addDart(index, newDart);
        this.addEdge(index, edgeToAdd);
        return removedDarts;
    }

    private MGraph.Edge<?> searchAndRemoveEdge(MGraph.Vertex<?> v2, Collection<MGraph.Edge<?>> edges) {
        MGraph.Edge<?> edge = null;
        for (MGraph.Edge<?> e2 : edges) {
            if (!e2.contains(v2)) continue;
            edge = e2;
            break;
        }
        edges.remove(edge);
        return edge;
    }

    public List<Dart> getDarts() {
        if (this.darts.size() != this.edges.size()) {
            this.createDarts();
        }
        return Collections.unmodifiableList(this.darts);
    }

    public void createDarts(MGraph.Vertex<?> startingVertex) {
        MGraph.Vertex<?> prevVertex = null;
        this.darts.clear();
        this.dartMap.clear();
        for (MGraph.Edge<?> e2 : this.edges) {
            if (prevVertex == null) {
                MGraph.Vertex<?> v2 = e2.getV();
                MGraph.Vertex<?> w2 = e2.getW();
                prevVertex = startingVertex == null ? (this.isOuterFace ? (v2.getNumber() < w2.getNumber() ? w2 : v2) : (v2.getNumber() < w2.getNumber() ? v2 : w2)) : startingVertex;
            }
            MGraph.Vertex<?> nextVertex = e2.getOppositeVertex(prevVertex);
            Dart dart = new Dart(prevVertex, nextVertex, e2);
            this.addDart(dart);
            prevVertex = nextVertex;
        }
    }

    public void createDarts() {
        this.createDarts(null);
    }

    private void addDart(Dart newDart) {
        this.darts.add(newDart);
        this.dartMap.add(newDart);
        this.updateDartIndices(this.darts.size() - 1, null);
    }

    private void addDart(int index, Dart newDart) {
        this.darts.add(index, newDart);
        this.dartMap.add(newDart);
        this.updateDartIndices(index, null);
    }

    private void removeDart(Dart dartToRemove) {
        int index = this.getDartIndex(dartToRemove);
        this.darts.remove(index);
        this.dartMap.remove(dartToRemove);
        this.updateDartIndices(index, dartToRemove);
    }

    private void removeDart(int index) {
        Dart removedDart = this.darts.remove(index);
        this.dartMap.remove(removedDart);
        this.updateDartIndices(index, removedDart);
    }

    private void updateDartIndices(int index, Dart removedDart) {
        if (removedDart != null) {
            this.dartIndices.remove(removedDart);
        }
        int size = this.darts.size();
        for (int i2 = index; i2 < size; ++i2) {
            this.dartIndices.put(this.darts.get(i2), i2);
        }
    }

    public List<Dart> getDartsFrom(MGraph.Vertex<?> v2) {
        ArrayList<Dart> darts = new ArrayList<Dart>();
        for (Dart d2 : this.getDarts()) {
            if (v2 != d2.getV()) continue;
            darts.add(d2);
        }
        return darts;
    }

    public Dart getDartFrom(MGraph.Vertex<?> v2) {
        for (Dart d2 : this.getDarts()) {
            if (v2 != d2.getV()) continue;
            return d2;
        }
        return null;
    }

    public List<Dart> getDartsTo(MGraph.Vertex<?> v2) {
        ArrayList<Dart> darts = new ArrayList<Dart>();
        for (Dart d2 : this.getDarts()) {
            if (v2 != d2.getW()) continue;
            darts.add(d2);
        }
        return darts;
    }

    public Dart getDartTo(MGraph.Vertex<?> v2) {
        for (Dart d2 : this.getDarts()) {
            if (v2 != d2.getW()) continue;
            return d2;
        }
        return null;
    }

    public Dart getDart(MGraph.Edge<?> edge) {
        for (Dart d2 : this.getDarts()) {
            if (d2.getEdge() != edge) continue;
            return d2;
        }
        return null;
    }

    public List<Dart> getDarts(MGraph.Edge<?> edge) {
        ArrayList<Dart> _darts = new ArrayList<Dart>();
        for (Dart d2 : this.getDarts()) {
            if (d2.getEdge() != edge) continue;
            _darts.add(d2);
        }
        return _darts;
    }

    public Dart getDart(MGraph.Edge<?> edge, MGraph.Vertex<?> sourceVertex) {
        for (Dart d2 : this.getDarts()) {
            if (d2.getEdge() != edge || d2.getV() != sourceVertex) continue;
            return d2;
        }
        return null;
    }

    public Dart getBorderingDart(Face face) {
        MGraph.Edge<?> edge = this.getBorderingEdge(face);
        for (Dart d2 : this.getDarts()) {
            if (d2.getEdge() != edge) continue;
            return d2;
        }
        return null;
    }

    public boolean containsEdge(MGraph.Edge<?> e2) {
        return this.edgeMap.contains(e2);
    }

    public boolean containsDart(Dart d2) {
        return this.dartMap.contains(d2);
    }

    public boolean containsVertex(MGraph.Vertex<?> v2) {
        for (MGraph.Edge<?> e2 : this.edges) {
            if (!e2.contains(v2)) continue;
            return true;
        }
        return false;
    }

    public boolean connects(Face face) {
        for (MGraph.Edge<?> e2 : this.getEdges()) {
            for (MGraph.Edge<?> ne : face.getEdges()) {
                if (!e2.shareVertex(ne)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean borders(Face face) {
        for (MGraph.Edge<?> e2 : face.edges) {
            if (!this.edgeMap.contains(e2)) continue;
            return true;
        }
        return false;
    }

    public MGraph.Vertex<?> getCornerVertex(MGraph.Edge<?> edge) {
        MGraph.Edge<?> nextEdge = this.getNextEdge(edge);
        MGraph.Vertex<?> v2 = edge.getV();
        MGraph.Vertex<?> w2 = edge.getW();
        MGraph.Vertex<?> nv = nextEdge.getV();
        MGraph.Vertex<?> nw = nextEdge.getW();
        if (v2 == nv || v2 == nw) {
            return v2;
        }
        if (w2 == nv || w2 == nw) {
            return w2;
        }
        return null;
    }

    public MGraph.Edge<?> getNextEdge(MGraph.Edge<?> e2) {
        int index = this.getEdgeIndex(e2);
        return this.edges.get((index + 1) % this.edges.size());
    }

    private int getEdgeIndex(MGraph.Edge<?> e2) {
        return this.edges.indexOf(e2);
    }

    public MGraph.Vertex<?> getCornerVertex(Dart dart) {
        Dart nextDart = this.getNextDart(dart);
        MGraph.Vertex<?> v2 = dart.getV();
        MGraph.Vertex<?> w2 = dart.getW();
        MGraph.Vertex<?> nv = nextDart.getV();
        MGraph.Vertex<?> nw = nextDart.getW();
        if (v2 == nv || v2 == nw) {
            return v2;
        }
        if (w2 == nv || w2 == nw) {
            return w2;
        }
        return null;
    }

    public Dart getNextDart(Dart dart) {
        int index = this.getDartIndex(dart);
        if (index == -1) {
            return null;
        }
        return this.darts.get((index + 1) % this.darts.size());
    }

    private int getDartIndex(Dart dart) {
        return this.dartIndices.get(dart);
    }

    public void reverseDirection() {
        ArrayList l2 = new ArrayList(this.edges);
        this.edges.clear();
        this.edgeMap.clear();
        for (int i2 = l2.size() - 1; i2 >= 0; --i2) {
            this.addEdge(l2.get(i2));
        }
        this.darts.clear();
        this.dartMap.clear();
    }

    public String toString() {
        String s2 = "Face:\n";
        if (this.isOuterFace) {
            s2 = "Outer Face:\n";
        }
        s2 = s2 + "Edges:\n";
        for (MGraph.Edge<?> e2 : this.edges) {
            s2 = s2 + "\t" + e2 + "\n";
        }
        s2 = s2 + "Darts:\n";
        for (Dart d2 : this.getDarts()) {
            s2 = s2 + "\t" + d2 + "\n";
        }
        return s2;
    }

    public static class Dart
    extends MGraph.Edge<Object> {
        private MGraph.Edge<?> e;

        public Dart(MGraph.Vertex<?> v2, MGraph.Vertex<?> w2, MGraph.Edge<?> e2) {
            super(v2, w2, null);
            this.e = e2;
        }

        public MGraph.Edge<?> getEdge() {
            return this.e;
        }

        @Override
        public MGraph.Edge.Direction getDirection() {
            return this.e.getDirection();
        }

        @Override
        public String toString() {
            return "dart : v = " + this.getV() + " w = " + this.getW() + " direction = " + (Object)((Object)this.getDirection());
        }
    }
}

