/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GeometryUtils {
    public static Point2D getIntersectionPoint(Line2D line1, Line2D line2, boolean extrapolate) {
        if (extrapolate || line1.intersectsLine(line2)) {
            float x1 = (float)line2.getX1();
            float y1 = (float)line2.getY1();
            float x2 = (float)line2.getX2();
            float y2 = (float)line2.getY2();
            float xp1 = (float)line1.getX1();
            float yp1 = (float)line1.getY1();
            float xp2 = (float)line1.getX2();
            float yp2 = (float)line1.getY2();
            float y3 = 0.0f;
            float x3 = 0.0f;
            float dy = y2 - y1;
            float s2 = (x2 - x1) / dy;
            float dpy = yp2 - yp1;
            float sp = (xp2 - xp1) / dpy;
            if (y1 == y2) {
                if (dpy == 0.0f) {
                    return null;
                }
                y3 = y1;
                x3 = xp1 + sp * (y3 - yp1);
            } else if (yp1 == yp2) {
                if (dy == 0.0f) {
                    return null;
                }
                y3 = yp1;
                x3 = x1 + s2 * (y3 - y1);
            } else {
                if (dy == 0.0f || dpy == 0.0f || s2 - sp == 0.0f) {
                    return null;
                }
                y3 = (xp1 - x1 + s2 * y1 - sp * yp1) / (s2 - sp);
                x3 = x1 + s2 * (y3 - y1);
            }
            return new Point2D.Float(x3, y3);
        }
        return null;
    }

    public static boolean isParallel(Line2D line1, Line2D line2) {
        float x1 = (float)line1.getX1();
        float y1 = (float)line1.getY1();
        float x2 = (float)line1.getX2();
        float y2 = (float)line1.getY2();
        float dx = x2 - x1;
        float dy = y1 - y2;
        float d2 = (float)Math.sqrt(dx * dx + dy * dy);
        float slope1 = Math.abs(dx / d2);
        x1 = (float)line2.getX1();
        y1 = (float)line2.getY1();
        x2 = (float)line2.getX2();
        dx = x2 - x1;
        float slope2 = Math.abs(dx / (d2 = (float)Math.sqrt(dx * dx + (dy = y1 - (y2 = (float)line2.getY2())) * dy)));
        return slope1 == slope2;
    }
}

