/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Logger;

public class MGraph<N, E> {
    private Collection<N> nodes;
    private Map<N, Vertex<N>> vertexMap;
    private Map<E, Edge<E>> edgeMap;
    private Collection<Vertex<N>> vertices;
    private UniversalGraph<N, E> uGraph = null;
    private GraphScene<N, E> scene = null;

    protected MGraph(UniversalGraph<N, E> uGraph, GraphScene<N, E> scene) {
        this.uGraph = uGraph;
        this.scene = scene;
        this.nodes = uGraph.getNodes();
        this.vertexMap = new HashMap<N, Vertex<N>>();
        this.edgeMap = new LinkedHashMap<E, Edge<E>>();
        this.vertices = new ArrayList<Vertex<N>>();
        DummyVertex.resetCounter();
    }

    public static <N, E> MGraph<N, E> createGraph(UniversalGraph<N, E> uGraph, GraphScene<N, E> scene) {
        MGraph<N, E> graph = new MGraph<N, E>(uGraph, scene);
        graph.createGraph();
        return graph;
    }

    protected void createGraph() {
        for (N node : this.nodes) {
            Edge<E> e2;
            Vertex<N> nv;
            N destNode;
            Vertex<N> v2 = this.getVertex(node);
            Widget widget = this.scene.findWidget(node);
            Rectangle bounds = widget.getBounds();
            Dimension size = new Dimension(bounds.width, bounds.height);
            v2.setSize(size);
            Collection<E> nodeEdges = this.uGraph.findNodeEdges(node, true, false);
            for (E edge : nodeEdges) {
                destNode = this.uGraph.getEdgeTarget(edge);
                nv = this.getVertex(destNode);
                e2 = this.getEdge(edge, v2, nv);
                v2.addNeighbor(nv);
                v2.addEdge(e2);
                nv.addEdge(e2);
            }
            nodeEdges = this.uGraph.findNodeEdges(node, false, true);
            for (E edge : nodeEdges) {
                destNode = this.uGraph.getEdgeSource(edge);
                nv = this.getVertex(destNode);
                e2 = this.getEdge(edge, nv, v2);
                v2.addNeighbor(nv);
                v2.addEdge(e2);
                nv.addEdge(e2);
            }
        }
    }

    public Collection<Vertex<N>> getVertices() {
        return Collections.unmodifiableCollection(this.vertices);
    }

    public Collection<Edge<E>> getEdges() {
        return Collections.unmodifiableCollection(this.edgeMap.values());
    }

    protected Vertex<N> getVertex(N node) {
        Vertex<N> vertex = this.vertexMap.get(node);
        if (vertex == null) {
            vertex = this.createVertex(node);
            this.vertexMap.put(node, vertex);
            this.vertices.add(vertex);
        }
        return vertex;
    }

    protected Vertex<N> createVertex(N node) {
        return new Vertex<N>(node);
    }

    protected Edge<E> getEdge(E edgeDE, Vertex<N> v2, Vertex<N> w2) {
        Edge<E> edge = this.edgeMap.get(edgeDE);
        if (edge == null) {
            edge = this.createEdge(v2, w2, edgeDE);
            this.edgeMap.put(edgeDE, edge);
        }
        return edge;
    }

    protected Edge<E> createEdge(Vertex<N> v2, Vertex<N> w2, E edgeDE) {
        return new Edge<E>(v2, w2, edgeDE);
    }

    public DummyVertex<N> insertDummyVertex(Edge<?> edge, DummyVertex.Type type) {
        Edge<?> tmp;
        Edge<?> originalEdge = edge instanceof DummyEdge ? (tmp = ((DummyEdge)edge).getOriginalEdge()) : (tmp = edge);
        DummyVertex<N> dv = this.createDummyVertex(originalEdge, type);
        this.vertices.add(dv);
        Vertex<Object> v2 = edge.getV();
        Vertex<Object> w2 = edge.getW();
        v2.removeEdge(edge);
        v2.removeNeighbor(w2);
        v2.addNeighbor(dv);
        dv.addNeighbor(v2);
        DummyEdge<?> de = this.createDummyEdge(v2, dv, originalEdge);
        v2.addEdge(de);
        dv.addEdge(de);
        w2.removeEdge(edge);
        w2.removeNeighbor(v2);
        w2.addNeighbor(dv);
        dv.addNeighbor(w2);
        de = this.createDummyEdge(dv, w2, originalEdge);
        w2.addEdge(de);
        dv.addEdge(de);
        return dv;
    }

    protected DummyVertex<N> createDummyVertex(Edge<?> originalEdge, DummyVertex.Type type) {
        return new DummyVertex(originalEdge, type);
    }

    public DummyEdge<E> addDummyEdge(Vertex<?> v2, Vertex<?> w2) {
        DummyEdge<E> de = this.createDummyEdge(v2, w2, null);
        v2.addEdge(de);
        w2.addEdge(de);
        v2.addNeighbor(w2);
        w2.addNeighbor(v2);
        return de;
    }

    protected DummyEdge<E> createDummyEdge(Vertex<?> v2, Vertex<?> w2, Edge<E> originalEdge) {
        return new DummyEdge<E>(v2, w2, originalEdge);
    }

    public DummyVertex<N> addDummyVertex(DummyVertex.Type type) {
        DummyVertex<N> dv = this.createDummyVertex(null, type);
        this.vertices.add(dv);
        return dv;
    }

    public void printGraph() {
        int count = 0;
        for (Vertex<N> vertex : this.getVertices()) {
            Logger.log(1, count + ") vertex = " + vertex + " (" + vertex.getX() + ", " + vertex.getY() + ")");
            ++count;
            N node = vertex.getNodeDesignElement();
            if (node == null) continue;
            Collection<E> nodeEdges = this.uGraph.findNodeEdges(node, true, false);
            Logger.log(1, "\toutgoing edges:");
            for (E edge : nodeEdges) {
                Logger.log(1, "\t\t" + edge);
            }
            nodeEdges = this.uGraph.findNodeEdges(node, false, true);
            Logger.log(1, "\tincoming edges:");
            for (E edge : nodeEdges) {
                Logger.log(1, "\t\t" + edge);
            }
            Logger.log(1, "\tneighbors:");
            Collection<Vertex<?>> neighbors = vertex.getNeighbors();
            for (Vertex<?> nv : neighbors) {
                Logger.log(1, "\t\t" + nv);
            }
        }
        Logger.log(1, "------------------\n------------------");
        count = 0;
        for (Edge edge : this.getEdges()) {
            Logger.log(1, count + ") edge = " + edge);
            ++count;
        }
    }

    public static class DummyEdge<E>
    extends Edge<E> {
        private Edge<?> originalEdge;

        public DummyEdge(Vertex<?> v2, Vertex<?> w2, Edge<E> originalEdge) {
            super(v2, w2, null);
            this.originalEdge = originalEdge;
        }

        public DummyEdge(Vertex<?> v2, Vertex<?> w2) {
            this(v2, w2, null);
        }

        public void setOriginalEdge(Edge<?> originalEdge) {
            this.originalEdge = originalEdge;
        }

        public Edge<?> getOriginalEdge() {
            return this.originalEdge;
        }

        @Override
        public String toString() {
            return "dummy " + super.toString();
        }
    }

    public static class DummyVertex<N>
    extends Vertex<N> {
        private static int counter = 0;
        private Edge<?> originalEdge;
        private Type type;
        private int index;

        public DummyVertex(Edge<?> originalEdge, Type type) {
            super(null);
            this.originalEdge = originalEdge;
            this.type = type;
            this.index = --counter;
        }

        public DummyVertex(Type type) {
            this(null, type);
        }

        public static void resetCounter() {
            counter = 0;
        }

        public void setOriginalEdge(Edge<?> originalEdge) {
            this.originalEdge = originalEdge;
        }

        public Edge<?> getOriginalEdge() {
            return this.originalEdge;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return "dummy vertex " + this.index;
        }

        public static enum Type {
            CROSSING,
            HYPEREDGE,
            BEND,
            TEMPORARY;

        }
    }

    public static class Edge<E> {
        private Vertex<?> v;
        private Vertex<?> w;
        private E edge;
        private Direction direction;
        private int weight;
        private Object edgeData;

        public Edge(Vertex<?> v2, Vertex<?> w2, E edge) {
            this.v = v2;
            this.w = w2;
            this.edge = edge;
        }

        public Vertex<?> getV() {
            return this.v;
        }

        public Vertex<?> getW() {
            return this.w;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public E getEdgeDesignElement() {
            return this.edge;
        }

        public void setEdgeData(Object data) {
            this.edgeData = data;
        }

        public Object getEdgeData() {
            return this.edgeData;
        }

        public boolean contains(Vertex<?> vertex) {
            return this.v == vertex || this.w == vertex;
        }

        public boolean shareVertex(Edge<?> edge) {
            return this.contains(edge.v) || this.contains(edge.w);
        }

        public Vertex<?> getOppositeVertex(Vertex<?> vertex) {
            if (this.v == vertex) {
                return this.w;
            }
            if (this.w == vertex) {
                return this.v;
            }
            return null;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String toString() {
            return "edge : " + this.edge + "\n  v = " + this.v + "\n  w = " + this.w;
        }

        public static enum Direction {
            HORIZONTAL,
            VERTICAL,
            UP,
            DOWN,
            LEFT,
            RIGHT;

        }
    }

    public static class Vertex<N> {
        private N node;
        private Collection<Vertex<?>> neighbors;
        private Collection<Edge<?>> edges;
        private int number = -1;
        private Object vertexData;
        private float x;
        private float y;
        private Dimension size = null;

        public Vertex(N node) {
            this.node = node;
            this.neighbors = new LinkedHashSet();
            this.edges = new LinkedHashSet();
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension dim) {
            this.size = dim;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x2) {
            this.x = x2;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y2) {
            this.y = y2;
        }

        public void addNeighbor(Vertex<?> vertex) {
            this.neighbors.add(vertex);
        }

        public void removeNeighbor(Vertex<?> vertex) {
            this.neighbors.remove(vertex);
        }

        public Collection<Vertex<?>> getNeighbors() {
            return this.neighbors;
        }

        public Edge<?> getEdge(Vertex<?> neighbor) {
            for (Edge<?> e2 : this.edges) {
                if (!e2.contains(neighbor)) continue;
                return e2;
            }
            return null;
        }

        public void addEdge(Edge<?> edge) {
            this.edges.add(edge);
        }

        public void removeEdge(Edge<?> edge) {
            this.edges.remove(edge);
        }

        public Collection<Edge<?>> getEdges() {
            return this.edges;
        }

        public N getNodeDesignElement() {
            return this.node;
        }

        public int getDegree() {
            return this.neighbors.size();
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public void setVertexData(Object data) {
            this.vertexData = data;
        }

        public Object getVertexData() {
            return this.vertexData;
        }

        public String toString() {
            return "vertex : " + this.node;
        }
    }
}

