/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.FlowNetwork;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.OrthogonalRepresentation;

public class MinimumBendOrthogonalizer {
    public <N, E> Collection<OrthogonalRepresentation<N, E>> orthogonalize(Collection<EmbeddedPlanarGraph<N, E>> epgs) {
        ArrayList<OrthogonalRepresentation<N, OrthogonalRepresentation<N, E>>> ors = new ArrayList<OrthogonalRepresentation<N, OrthogonalRepresentation<N, E>>>();
        for (EmbeddedPlanarGraph<N, E> epg : epgs) {
            FlowNetwork<N, E> network = FlowNetwork.createGraph(epg);
            this.computeMinimumCostFlowNetwork(network);
            network.removeSourceAndSink();
            OrthogonalRepresentation<N, E> or = this.computeOrthogonalRepresentation(network);
            ors.add(or);
        }
        return ors;
    }

    private <N, E> void computeMinimumCostFlowNetwork(FlowNetwork<N, E> network) {
        FlowNetwork.ResidualFlowNetwork<N, E> residualNetwork = new FlowNetwork.ResidualFlowNetwork<N, E>(network);
        int totalFlow = 0;
        int production = network.getSource().getProduction();
        while (totalFlow < production) {
            Collection<FlowNetwork.ResidualArc<N>> path = this.computeDijkstraShortestPath(residualNetwork);
            if (path == null) {
                return;
            }
            int minFlow = Integer.MAX_VALUE;
            for (FlowNetwork.Arc arc : path) {
                int capacity = arc.getCapacity();
                if (capacity >= minFlow) continue;
                minFlow = capacity;
            }
            totalFlow += minFlow;
            for (FlowNetwork.ResidualArc<N> residualArc : path) {
                FlowNetwork.Arc<N> arc = residualArc.getArc();
                FlowNetwork.ResidualArc<N> residualArc2 = null;
                FlowNetwork.ResidualArc<N> reverseResidualArc = null;
                int flow = minFlow;
                if (!residualArc.isReverse()) {
                    residualArc2 = residualArc;
                    reverseResidualArc = residualNetwork.getReverseResidualArcFromArc(arc);
                } else {
                    flow = -flow;
                    reverseResidualArc = residualArc;
                    residualArc2 = residualNetwork.getResidualArcFromArc(arc);
                }
                arc.addFlow(flow);
                residualArc2.substractCapacity(flow);
                reverseResidualArc.addCapacity(flow);
                reverseResidualArc.setFlow(arc.getFlow());
            }
        }
    }

    private <N, E> Collection<FlowNetwork.ResidualArc<N>> computeDijkstraShortestPath(FlowNetwork.ResidualFlowNetwork<N, E> network) {
        Collection nodes = network.getNodes();
        HashMap<FlowNetwork.Node<N>, FlowNetwork.ResidualArc<N>> paths = new HashMap<FlowNetwork.Node<N>, FlowNetwork.ResidualArc<N>>();
        HashMap<FlowNetwork.Node<N>, Integer> distances = new HashMap<FlowNetwork.Node<N>, Integer>();
        FlowNetwork.Node sourceNode = network.getSource();
        for (FlowNetwork.Node node : nodes) {
            distances.put(node, Integer.MAX_VALUE);
        }
        distances.put(sourceNode, 0);
        PriorityQueue<FlowNetwork.Node<N>> priorityQueue = this.createPriorityQueue(distances);
        for (FlowNetwork.Node node : nodes) {
            priorityQueue.offer(node);
        }
        HashSet hashSet = new HashSet();
        while (priorityQueue.size() > 0) {
            FlowNetwork.Node node;
            node = priorityQueue.poll();
            if ((Integer)distances.get(node) == Integer.MAX_VALUE || hashSet.contains(node)) continue;
            for (FlowNetwork.Arc arc : node.getOutputArcs()) {
                if (arc.getCapacity() <= 0) continue;
                this.computeRelaxation(arc, paths, distances, priorityQueue);
            }
            hashSet.add(node);
        }
        ArrayList<FlowNetwork.ResidualArc<N>> shortestPath = new ArrayList<FlowNetwork.ResidualArc<N>>();
        FlowNetwork.Node currentNode = network.getSink();
        while (currentNode != sourceNode) {
            FlowNetwork.Arc arc;
            arc = (FlowNetwork.Arc)paths.get(currentNode);
            if (arc == null) {
                return null;
            }
            shortestPath.add((FlowNetwork.ResidualArc)arc);
            currentNode = arc.getSourceNode();
        }
        return shortestPath;
    }

    private <N> void computeRelaxation(FlowNetwork.Arc<N> arc, Map<FlowNetwork.Node<N>, FlowNetwork.ResidualArc<N>> paths, Map<FlowNetwork.Node<N>, Integer> distances, PriorityQueue<FlowNetwork.Node<N>> queue) {
        int cost;
        FlowNetwork.Node<N> srcNode = arc.getSourceNode();
        FlowNetwork.Node<N> destNode = arc.getDestinationNode();
        int sd = distances.get(srcNode);
        int dd = distances.get(destNode);
        if (dd > sd + (cost = arc.getCost())) {
            distances.put(destNode, sd + cost);
            paths.put(destNode, (FlowNetwork.ResidualArc)arc);
            queue.offer(destNode);
        }
    }

    private <N> PriorityQueue<FlowNetwork.Node<N>> createPriorityQueue(final Map<FlowNetwork.Node<N>, Integer> distances) {
        return new PriorityQueue<FlowNetwork.Node<N>>(distances.size(), new Comparator<FlowNetwork.Node<?>>(){

            @Override
            public int compare(FlowNetwork.Node<?> o1, FlowNetwork.Node<?> o2) {
                int d2;
                int d1 = (Integer)distances.get(o1);
                if (d1 < (d2 = ((Integer)distances.get(o2)).intValue())) {
                    return -1;
                }
                if (d1 == d2) {
                    return 0;
                }
                return 1;
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        });
    }

    private <N, E> OrthogonalRepresentation<N, E> computeOrthogonalRepresentation(FlowNetwork<N, E> network) {
        OrthogonalRepresentation<N, E> or = OrthogonalRepresentation.createGraph(network.getOriginalGraph());
        for (FlowNetwork.Arc<N> arc : network.getArcs()) {
            int i2;
            int reverseFlow;
            if (arc.isVertexArc()) {
                MGraph.Vertex<N> v2 = arc.getSourceNode().getVertex();
                Face f2 = arc.getDestinationNode().getFace();
                OrthogonalRepresentation.OrthogonalShape shape = or.getShape(f2);
                Face.Dart d2 = arc.getDart();
                OrthogonalRepresentation.Tuple t2 = shape.getTuple(d2);
                t2.setAngles(arc.getFlow() + 1);
                continue;
            }
            if (!arc.isFaceArc()) continue;
            FlowNetwork.Node<N> srcNode = arc.getSourceNode();
            FlowNetwork.Node<N> destNode = arc.getDestinationNode();
            Face f3 = srcNode.getFace();
            FlowNetwork.Arc<N> reverseArc = destNode.getArcToVia(srcNode, arc.getDart());
            OrthogonalRepresentation.OrthogonalShape shape = or.getShape(f3);
            Face.Dart d3 = arc.getDart();
            OrthogonalRepresentation.Tuple t3 = shape.getTuple(d3);
            BitSet bends = t3.getBends();
            int forwardFlow = arc.getFlow();
            int sum = forwardFlow + (reverseFlow = reverseArc.getFlow());
            if (sum == 0) continue;
            for (i2 = 0; i2 < forwardFlow; ++i2) {
                bends.clear(i2);
            }
            for (i2 = forwardFlow; i2 < sum; ++i2) {
                bends.set(i2);
            }
            bends.set(sum);
        }
        return or;
    }
}

