/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class OrthogonalRepresentation<N, E> {
    private Map<Face, OrthogonalShape> shapes = new LinkedHashMap<Face, OrthogonalShape>();
    private EmbeddedPlanarGraph<N, E> originalGraph;
    private MGraph.Vertex<N> cornerVertex;

    public static <N, E> OrthogonalRepresentation<N, E> createGraph(EmbeddedPlanarGraph<N, E> graph) {
        return new OrthogonalRepresentation<N, E>(graph);
    }

    private OrthogonalRepresentation(EmbeddedPlanarGraph<N, E> graph) {
        this.originalGraph = graph;
    }

    public EmbeddedPlanarGraph<N, E> getOriginalGraph() {
        return this.originalGraph;
    }

    public OrthogonalShape getShape(Face face) {
        OrthogonalShape shape = this.shapes.get(face);
        if (shape == null) {
            shape = new OrthogonalShape(face);
            this.shapes.put(face, shape);
        }
        return shape;
    }

    public Collection<OrthogonalShape> getShapes() {
        return this.shapes.values();
    }

    public void setCornerVertex(MGraph.Vertex<N> cornerVertex) {
        this.cornerVertex = cornerVertex;
    }

    public MGraph.Vertex<N> getCornerVertex() {
        return this.cornerVertex;
    }

    public String toString() {
        String s2 = "Orthogonal Representation:\n";
        for (OrthogonalShape shape : this.shapes.values()) {
            s2 = s2 + shape;
        }
        return s2;
    }

    public static class Tuple {
        private Face.Dart dart;
        private BitSet bends;
        private int angles;

        public Tuple(Face.Dart dart) {
            this.dart = dart;
            this.bends = new BitSet();
        }

        public Face.Dart getDart() {
            return this.dart;
        }

        public BitSet getBends() {
            return this.bends;
        }

        public int getNumberOfBends() {
            int length = this.bends.length();
            if (length > 0) {
                --length;
            }
            return length;
        }

        public int getAngles() {
            return this.angles;
        }

        public void setAngles(int angles) {
            if (angles == 0) {
                new Exception().printStackTrace();
            }
            this.angles = angles;
        }

        public String toString() {
            String s2 = "Tuple:\n";
            s2 = s2 + this.dart + "\n";
            s2 = s2 + "angles = " + this.angles + "\n";
            s2 = s2 + "bends = " + this.bends + "\n";
            s2 = s2 + "# of bends = " + this.getNumberOfBends() + "\n";
            s2 = s2 + "direction = " + (Object)((Object)this.dart.getEdge().getDirection()) + "\n";
            return s2;
        }
    }

    public static class OrthogonalShape {
        private Map<Face.Dart, Tuple> tupleMap;
        private Face face;

        OrthogonalShape(Face face) {
            this.face = face;
            this.tupleMap = new LinkedHashMap<Face.Dart, Tuple>();
            for (Face.Dart d2 : face.getDarts()) {
                Tuple t2 = new Tuple(d2);
                this.tupleMap.put(d2, t2);
            }
        }

        public Face getFace() {
            return this.face;
        }

        public Tuple getTuple(Face.Dart dart) {
            return this.tupleMap.get(dart);
        }

        public void updateTuple(Tuple tuple, Collection<MGraph.Edge<?>> newEdges) {
            Face.Dart originalDart = tuple.getDart();
            MGraph.Edge<?> originalEdge = originalDart.getEdge();
            List<Face.Dart> newDarts = this.face.replaceDart(originalDart, newEdges);
            this.tupleMap.remove(originalDart);
            BitSet bends = tuple.getBends();
            int size = newDarts.size();
            for (int i2 = 0; i2 < size; ++i2) {
                Face.Dart newDart = newDarts.get(i2);
                Tuple newTuple = new Tuple(newDart);
                this.tupleMap.put(newDart, newTuple);
                if (i2 == 0) {
                    newTuple.setAngles(tuple.getAngles());
                    continue;
                }
                if (bends.length() > 0) {
                    boolean bit = bends.get(i2 - 1);
                    if (bit) {
                        newTuple.setAngles(3);
                        continue;
                    }
                    newTuple.setAngles(1);
                    continue;
                }
                newTuple.setAngles(2);
            }
            Face.Dart reverseDart = this.face.getDart(originalEdge);
            if (reverseDart != null) {
                Tuple reverseTuple = this.getTuple(reverseDart);
                this.updateTuple(reverseTuple, newEdges);
            }
        }

        public void insertEdge(MGraph.Edge<?> edge) {
            List<Face.Dart> removedDarts = this.face.replaceDarts(edge);
            if (removedDarts.isEmpty()) {
                return;
            }
            for (Face.Dart d2 : removedDarts) {
                this.tupleMap.remove(d2);
            }
            Face.Dart newDart = this.face.getDart(edge);
            Tuple newTuple = new Tuple(newDart);
            this.tupleMap.put(newDart, newTuple);
            newTuple.setAngles(1);
            Face.Dart nextDart = this.face.getNextDart(newDart);
            Tuple nextTuple = this.getTuple(nextDart);
            nextTuple.setAngles(2);
        }

        public String toString() {
            String s2 = "Shape:\n";
            s2 = s2 + this.face;
            return s2;
        }
    }
}

