/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import org.netbeans.api.visual.print.ScenePrinter;
import org.netbeans.api.visual.widget.Scene;

public class PageableScene
implements Pageable,
Printable {
    private double mScaleX = 1.0;
    private double mScaleY = 1.0;
    private final Scene scene;
    private int mNumPagesX;
    private int mNumPagesY;
    private int mNumPages;
    private PageFormat mFormat;
    private final boolean selectedOnly;
    private final boolean visibleOnly;
    private Rectangle region = null;

    public PageableScene(Scene scene, PageFormat format, ScenePrinter.ScaleStrategy scaleType, double scaleX, double scaleY, boolean selectedOnly, boolean visibleOnly, Rectangle region) {
        this.scene = scene;
        this.selectedOnly = selectedOnly;
        this.visibleOnly = visibleOnly;
        this.region = region;
        double zoomFactor = scene.getZoomFactor();
        if (format == null) {
            format = new PageFormat();
        }
        this.setPageFormat(format);
        if (visibleOnly || region != null) {
            if (region == null) {
                region = scene.getView().getVisibleRect();
            }
            this.setSize(region.width, region.height);
        } else if (scaleType.equals((Object)ScenePrinter.ScaleStrategy.SCALE_CURRENT_ZOOM)) {
            this.setScaledSize(1.0, 1.0);
        } else if (scaleType.equals((Object)ScenePrinter.ScaleStrategy.NO_SCALING)) {
            double z2 = zoomFactor > 1.0 ? 1.0 / zoomFactor : 1.0;
            this.setScaledSize(z2, z2);
            this.mScaleX = 1.0;
            this.mScaleY = 1.0;
        } else if (scaleType.equals((Object)ScenePrinter.ScaleStrategy.SCALE_TO_FIT_X)) {
            this.scaleToFitX();
        } else if (scaleType.equals((Object)ScenePrinter.ScaleStrategy.SCALE_TO_FIT_Y)) {
            this.scaleToFitY();
        } else if (scaleType.equals((Object)ScenePrinter.ScaleStrategy.SCALE_TO_FIT)) {
            this.scaleToFit(true);
        } else if (scaleType.equals((Object)ScenePrinter.ScaleStrategy.SCALE_PERCENT)) {
            this.setScaledSize(scaleX, scaleY);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.mNumPagesX == 0) {
            return 1;
        }
        double originX = (double)(pageIndex % this.mNumPagesX) * this.mFormat.getImageableWidth();
        double originY = (double)(pageIndex / this.mNumPagesX) * this.mFormat.getImageableHeight();
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2.translate(-originX, -originY);
        g2.scale(this.mScaleX, this.mScaleY);
        this.scene.paint(g2);
        return 0;
    }

    protected void setSize(float width, float height) {
        if (this.mFormat.getImageableWidth() * this.mFormat.getImageableHeight() == 0.0) {
            return;
        }
        this.mNumPagesX = (int)(((double)width + this.mFormat.getImageableWidth() - 1.0) / this.mFormat.getImageableWidth());
        this.mNumPagesY = (int)(((double)height + this.mFormat.getImageableHeight() - 1.0) / this.mFormat.getImageableHeight());
        this.mNumPages = this.mNumPagesX * this.mNumPagesY;
    }

    private void scaleToFit(boolean useSymmetricScaling) {
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.scene.getView().getBounds();
        if (componentBounds.width * componentBounds.height == 0) {
            return;
        }
        double scaleX = format.getImageableWidth() / (double)componentBounds.width;
        double scaleY = format.getImageableHeight() / (double)componentBounds.height;
        if (scaleX < 1.0 || scaleY < 1.0) {
            if (useSymmetricScaling) {
                if (scaleX < scaleY) {
                    scaleY = scaleX;
                } else {
                    scaleX = scaleY;
                }
            }
            this.setSize((float)((double)componentBounds.width * scaleX), (float)((double)componentBounds.height * scaleY));
            this.setScaledSize(scaleX, scaleY);
        }
    }

    private void scaleToFitX() {
        double scaleX;
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.scene.getBounds();
        if (componentBounds.width == 0) {
            return;
        }
        double scaleY = scaleX = format.getImageableWidth() / (double)componentBounds.width;
        if (scaleX < 1.0) {
            this.setSize((float)format.getImageableWidth(), (float)((double)componentBounds.height * scaleY));
            this.setScaledSize(scaleX, scaleY);
        }
    }

    private void scaleToFitY() {
        double scaleY;
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.scene.getBounds();
        if (componentBounds.height == 0) {
            return;
        }
        double scaleX = scaleY = format.getImageableHeight() / (double)componentBounds.height;
        if (scaleY < 1.0) {
            this.setSize((float)((double)componentBounds.width * scaleX), (float)format.getImageableHeight());
            this.setScaledSize(scaleX, scaleY);
        }
    }

    private void setScaledSize(double scaleX, double scaleY) {
        this.mScaleX = scaleX;
        this.mScaleY = scaleY;
        Rectangle componentBounds = this.scene.getView().getBounds();
        this.setSize((float)((double)componentBounds.width * scaleX), (float)((double)componentBounds.height * scaleY));
    }

    @Override
    public int getNumberOfPages() {
        return this.mNumPages;
    }

    private PageFormat getPageFormat() {
        return this.mFormat;
    }

    private void setPageFormat(PageFormat pageFormat) {
        this.mFormat = pageFormat;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this.getPageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }
}

