/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.router;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.visual.router.CollisionsCollector;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;

public class WidgetsCollisionCollector
implements CollisionsCollector {
    private LayerWidget[] layers;

    public WidgetsCollisionCollector(LayerWidget ... layers) {
        this.layers = layers;
    }

    @Override
    public void collectCollisions(List<Rectangle> verticalCollisions, List<Rectangle> horizontalCollisions) {
        for (Widget widget : this.getWidgets()) {
            if (!widget.isValidated()) continue;
            if (widget instanceof ConnectionWidget) {
                ConnectionWidget conn = (ConnectionWidget)widget;
                if (!conn.isRouted()) continue;
                List<Point> controlPoints = conn.getControlPoints();
                int last = controlPoints.size() - 1;
                for (int i2 = 0; i2 < last; ++i2) {
                    Rectangle rectangle;
                    Point point1 = controlPoints.get(i2);
                    Point point2 = controlPoints.get(i2 + 1);
                    if (point1.x == point2.x) {
                        rectangle = new Rectangle(point1.x, Math.min(point1.y, point2.y), 0, Math.abs(point2.y - point1.y));
                        rectangle.grow(8, 8);
                        verticalCollisions.add(rectangle);
                        continue;
                    }
                    if (point1.y != point2.y) continue;
                    rectangle = new Rectangle(Math.min(point1.x, point2.x), point1.y, Math.abs(point2.x - point1.x), 0);
                    rectangle.grow(8, 8);
                    horizontalCollisions.add(rectangle);
                }
                continue;
            }
            Rectangle bounds = widget.getBounds();
            Rectangle rectangle = widget.convertLocalToScene(bounds);
            rectangle.grow(16, 16);
            verticalCollisions.add(rectangle);
            horizontalCollisions.add(rectangle);
        }
    }

    protected Collection<Widget> getWidgets() {
        ArrayList<Widget> list = new ArrayList<Widget>();
        for (LayerWidget layer : this.layers) {
            list.addAll(layer.getChildren());
        }
        return list;
    }
}

