/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;

public abstract class ErrorManager {
    public static final int UNKNOWN = 0;
    public static final int INFORMATIONAL = 1;
    public static final int WARNING = 16;
    public static final int USER = 256;
    public static final int EXCEPTION = 4096;
    public static final int ERROR = 65536;
    private static DelegatingErrorManager current;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorManager getDefault() {
        Class<ErrorManager> clazz = ErrorManager.class;
        synchronized (ErrorManager.class) {
            if (current != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return current;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ErrorManager.getDefaultDelegate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DelegatingErrorManager getDefaultDelegate() {
        DelegatingErrorManager c2 = new DelegatingErrorManager("");
        try {
            c2.initialize();
            Class<ErrorManager> clazz = ErrorManager.class;
            synchronized (ErrorManager.class) {
                if (current == null) {
                    current = c2;
                    ErrorManager.current.r.addLookupListener(current);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (RuntimeException e2) {
            e2.printStackTrace();
            current = c2;
        }
        catch (LinkageError e3) {
            e3.printStackTrace();
            current = c2;
        }
        {
            return current;
        }
    }

    public abstract Throwable attachAnnotations(Throwable var1, Annotation[] var2);

    public abstract Annotation[] findAnnotations(Throwable var1);

    public abstract Throwable annotate(Throwable var1, int var2, String var3, String var4, Throwable var5, Date var6);

    public abstract void notify(int var1, Throwable var2);

    public final void notify(Throwable t2) {
        this.notify(0, t2);
    }

    public abstract void log(int var1, String var2);

    public final void log(String s2) {
        this.log(1, s2);
    }

    public boolean isLoggable(int severity) {
        return true;
    }

    public boolean isNotifiable(int severity) {
        return this.isLoggable(severity);
    }

    public abstract ErrorManager getInstance(String var1);

    public final Throwable annotate(Throwable t2, String localizedMessage) {
        return this.annotate(t2, 0, null, localizedMessage, null, null);
    }

    public final Throwable annotate(Throwable target, Throwable t2) {
        return this.annotate(target, 0, null, null, t2, null);
    }

    @Deprecated
    public final Throwable copyAnnotation(Throwable t2, Throwable copyFrom) {
        return this.annotate(t2, 0, null, null, copyFrom, null);
    }

    private static final class OwnLevel
    extends Level {
        public static final Level USER = new OwnLevel("USER", 1973);
        public static final Level UNKNOWN = new OwnLevel("SEVERE", Level.SEVERE.intValue() + 1);

        private OwnLevel(String s2, int i2) {
            super(s2, i2);
        }
    }

    private static final class AnnException
    extends Exception
    implements Callable<LogRecord[]> {
        private List<LogRecord> records;
        private static Map<Throwable, AnnException> extras = new WeakHashMap<Throwable, AnnException>();

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            List<LogRecord> arr = this.records;
            if (arr != null) {
                for (LogRecord r2 : arr) {
                    if (r2.getMessage() == null) continue;
                    sb.append(sep);
                    sb.append(r2.getMessage());
                    sep = "\n";
                }
            }
            return sb.toString();
        }

        static AnnException findOrCreate(Throwable t2, boolean create) {
            AnnException ann;
            block3: {
                try {
                    ann = AnnException.findOrCreate0(t2, create);
                }
                catch (IllegalStateException x2) {
                    assert (create);
                    ann = extras.get(t2);
                    if (ann != null) break block3;
                    ann = new AnnException();
                    ann.initCause(t2);
                    Logger.getLogger(ErrorManager.class.getName()).log(Level.FINE, "getCause was null yet initCause failed for " + t2, x2);
                    extras.put(t2, ann);
                }
            }
            return ann;
        }

        private static AnnException findOrCreate0(Throwable t2, boolean create) {
            if (t2 instanceof AnnException) {
                return (AnnException)t2;
            }
            if (t2.getCause() == null) {
                if (create) {
                    t2.initCause(new AnnException());
                }
                return (AnnException)t2.getCause();
            }
            return AnnException.findOrCreate0(t2.getCause(), create);
        }

        private AnnException() {
        }

        public synchronized void addRecord(LogRecord rec) {
            if (this.records == null) {
                this.records = new ArrayList<LogRecord>();
            }
            this.records.add(rec);
        }

        @Override
        public LogRecord[] call() {
            List<LogRecord> r2 = this.records;
            LogRecord[] empty = new LogRecord[]{};
            return r2 == null ? empty : r2.toArray(empty);
        }

        @Override
        public void printStackTrace(PrintStream s2) {
            super.printStackTrace(s2);
            this.logRecords(s2);
        }

        @Override
        public void printStackTrace(PrintWriter s2) {
            super.printStackTrace(s2);
            this.logRecords(s2);
        }

        @Override
        public void printStackTrace() {
            this.printStackTrace(System.err);
        }

        private void logRecords(Appendable a2) {
            List<LogRecord> r2 = this.records;
            if (r2 == null) {
                return;
            }
            try {
                for (LogRecord log : r2) {
                    if (log.getMessage() != null) {
                        a2.append(log.getMessage()).append("\n");
                    }
                    if (log.getThrown() == null) continue;
                    StringWriter w2 = new StringWriter();
                    log.getThrown().printStackTrace(new PrintWriter(w2));
                    a2.append(w2.toString()).append("\n");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class DelegatingErrorManager
    extends ErrorManager
    implements LookupListener {
        private String name = null;
        private Set<ErrorManager> delegates = new HashSet<ErrorManager>();
        private Logger logger;
        private WeakSet<DelegatingErrorManager> createdByMe = new WeakSet();
        Lookup.Result<ErrorManager> r;
        private static volatile Thread lastThread;

        public DelegatingErrorManager(String name) {
            this.name = name;
        }

        Logger logger() {
            if (this.logger == null) {
                this.logger = Logger.getLogger(this.name);
            }
            return this.logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ErrorManager getInstance(String name) {
            if (name == null || "".equals(name)) {
                return this;
            }
            DelegatingErrorManager dem = new DelegatingErrorManager(name);
            DelegatingErrorManager delegatingErrorManager = this;
            synchronized (delegatingErrorManager) {
                this.attachNewDelegates(dem, name);
                this.createdByMe.add(dem);
            }
            return dem;
        }

        @Override
        public Throwable attachAnnotations(Throwable t2, Annotation[] arr) {
            for (ErrorManager em : this.delegates) {
                em.attachAnnotations(t2, arr);
            }
            return t2;
        }

        @Override
        public Annotation[] findAnnotations(Throwable t2) {
            for (ErrorManager em : this.delegates) {
                Annotation[] res = em.findAnnotations(t2);
                if (res == null || res.length <= 0) continue;
                return res;
            }
            return new Annotation[0];
        }

        @Override
        public Throwable annotate(Throwable t2, int severity, String message, final String localizedMessage, Throwable stackTrace, Date date) {
            if (this.delegates.isEmpty()) {
                AnnException ann;
                LogRecord rec = new LogRecord(DelegatingErrorManager.convertSeverity(severity, true, Level.ALL), message);
                if (stackTrace != null) {
                    rec.setThrown(stackTrace);
                }
                if (date != null) {
                    rec.setMillis(date.getTime());
                }
                if (localizedMessage != null) {
                    ResourceBundle rb = new ResourceBundle(){

                        @Override
                        public Object handleGetObject(String key) {
                            if ("msg".equals(key)) {
                                return localizedMessage;
                            }
                            return null;
                        }

                        @Override
                        public Enumeration<String> getKeys() {
                            return Enumerations.singleton("msg");
                        }
                    };
                    rec.setResourceBundle(rb);
                    rec.setMessage("msg");
                }
                if ((ann = AnnException.findOrCreate(t2, true)) != null) {
                    ann.addRecord(rec);
                }
                return t2;
            }
            for (ErrorManager em : this.delegates) {
                em.annotate(t2, severity, message, localizedMessage, stackTrace, date);
            }
            return t2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(int severity, Throwable t2) {
            if (this.delegates.isEmpty()) {
                if (DelegatingErrorManager.enterLogger()) {
                    return;
                }
                try {
                    AnnException ext = (AnnException)AnnException.extras.get(t2);
                    if (ext != null) {
                        t2 = ext;
                    }
                    this.logger().log(DelegatingErrorManager.convertSeverity(severity, true, OwnLevel.UNKNOWN), t2.getMessage(), t2);
                }
                finally {
                    DelegatingErrorManager.exitLogger();
                }
                return;
            }
            try {
                for (ErrorManager em : this.delegates) {
                    em.notify(severity, t2);
                }
            }
            catch (RuntimeException e2) {
                e2.printStackTrace();
                t2.printStackTrace();
            }
            catch (LinkageError e3) {
                e3.printStackTrace();
                t2.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(int severity, String s2) {
            if (severity == 0) {
                throw new IllegalArgumentException("ErrorManager.log(UNKNOWN, ...) is not permitted");
            }
            if (this.delegates.isEmpty()) {
                Level sev = DelegatingErrorManager.convertSeverity(severity, false, Level.FINE);
                if (DelegatingErrorManager.enterLogger()) {
                    return;
                }
                try {
                    this.logger().log(sev, s2);
                }
                finally {
                    DelegatingErrorManager.exitLogger();
                }
                return;
            }
            for (ErrorManager em : this.delegates) {
                em.log(severity, s2);
            }
        }

        private static Level convertSeverity(int severity, boolean forException, Level def) {
            Level sev = def;
            if (severity >= 65536) {
                sev = Level.SEVERE;
            } else if (severity >= 4096) {
                sev = Level.SEVERE;
            } else if (severity >= 256) {
                sev = OwnLevel.USER;
            } else if (severity >= 16) {
                sev = Level.WARNING;
            } else if (severity >= 1) {
                sev = forException ? Level.INFO : Level.FINE;
            }
            return sev;
        }

        @Override
        public boolean isLoggable(int severity) {
            if (severity == 0) {
                throw new IllegalArgumentException("ErrorManager.isLoggable(UNKNOWN) is not permitted");
            }
            if (this.delegates.isEmpty()) {
                return this.logger().isLoggable(DelegatingErrorManager.convertSeverity(severity, false, null));
            }
            for (ErrorManager em : this.delegates) {
                if (!em.isLoggable(severity)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isNotifiable(int severity) {
            if (severity == 0) {
                throw new IllegalArgumentException("ErrorManager.isNotifiable(UNKNOWN) is not permitted");
            }
            if (this.delegates.isEmpty()) {
                return this.logger().isLoggable(DelegatingErrorManager.convertSeverity(severity, true, null));
            }
            for (ErrorManager em : this.delegates) {
                if (!em.isNotifiable(severity)) continue;
                return true;
            }
            return false;
        }

        public synchronized void setDelegates(Collection<? extends ErrorManager> newDelegates) {
            this.delegates = new LinkedHashSet<ErrorManager>(newDelegates);
            for (DelegatingErrorManager dem : this.createdByMe) {
                this.attachNewDelegates(dem, dem.getName());
            }
        }

        private String getName() {
            return this.name;
        }

        private void attachNewDelegates(DelegatingErrorManager dem, String name) {
            HashSet<ErrorManager> newDelegatesForDem = new HashSet<ErrorManager>();
            for (ErrorManager e2 : this.delegates) {
                newDelegatesForDem.add(e2.getInstance(name));
            }
            dem.setDelegates(newDelegatesForDem);
        }

        public void initialize() {
            this.r = Lookup.getDefault().lookupResult(ErrorManager.class);
            this.setDelegates(this.r.allInstances());
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            if (this.r != null) {
                this.setDelegates(this.r.allInstances());
            }
        }

        private static boolean enterLogger() {
            if (lastThread == Thread.currentThread()) {
                new Exception("using error manager from inside a logger").printStackTrace();
                return true;
            }
            lastThread = Thread.currentThread();
            return false;
        }

        private static void exitLogger() {
            lastThread = null;
        }
    }

    public static interface Annotation {
        public String getMessage();

        public String getLocalizedMessage();

        public Throwable getStackTrace();

        public Date getDate();

        public int getSeverity();
    }
}

