/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

final class ColorIcon
implements Icon {
    private final Color color;
    private final int size;

    public ColorIcon(Color color, int size) {
        this.color = color;
        this.size = size;
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        g2.setColor(Color.black);
        g2.drawRect(x2, y2, this.size - 1, this.size - 1);
        if (null == this.color) {
            g2.drawLine(x2, y2 + this.size - 1, x2 + this.size - 1, y2);
        } else {
            g2.setColor(this.color);
            g2.fillRect(x2 + 1, y2 + 1, this.size - 2, this.size - 2);
        }
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

