/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.ContextActionEnabler;
import org.openide.awt.ContextActionPerformer;
import org.openide.awt.ContextManager;
import org.openide.awt.ContextSelection;
import org.openide.awt.GeneralAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

class ContextAction<T>
implements Action,
ContextAwareAction,
ChangeListener,
Runnable {
    static final Logger LOG = Logger.getLogger(ContextAction.class.getName());
    final Class<T> type;
    final ContextSelection selectMode;
    final Performer<? super T> performer;
    final ContextManager global;
    private PropertyChangeSupport support;
    private boolean previousEnabled;
    protected final StatefulMonitor enableMonitor;
    private static final Reference<Object> NONE = new WeakReference<Object>(null);

    public ContextAction(Performer<? super T> performer, ContextSelection selectMode, Lookup actionContext, Class<T> type, boolean surviveFocusChange, StatefulMonitor enableMonitor) {
        if (performer == null) {
            throw new NullPointerException("Has to provide a key!");
        }
        this.type = type;
        this.selectMode = selectMode;
        this.performer = performer;
        this.global = ContextManager.findManager(actionContext, surviveFocusChange);
        this.enableMonitor = enableMonitor;
        if (enableMonitor != null) {
            LOG.log(Level.FINE, "Setting enable monitor {0}: {1}", new Object[]{this, enableMonitor});
        }
    }

    public String toString() {
        return super.toString() + "[type=" + this.type + ", performer=" + this.performer + "]";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.global.actionPerformed(e2, this.performer, this.type, this.selectMode);
    }

    @Override
    public boolean isEnabled() {
        assert (EventQueue.isDispatchThread());
        boolean r2 = this.enableMonitor != null ? this.fetchEnabledValue() : this.global.isEnabled(this.type, this.selectMode, this.performer);
        this.previousEnabled = r2;
        return r2;
    }

    private boolean fetchEnabledValue() {
        return this.global.runEnabled(this.type, this.selectMode, (all, everything) -> {
            Supplier<Action> af2 = () -> (Action)((Performer)this.performer).delegate0(everything, all, true);
            if (this.enableMonitor.getType() == Action.class) {
                Action dele = (Action)this.performer.delegate((Lookup.Provider)everything, (List<?>)all);
                return this.enableMonitor.enabled(Collections.singletonList(dele), () -> dele);
            }
            if (this.enableMonitor.getType() != this.type) {
                return this.global.runEnabled(this.enableMonitor.getType(), this.selectMode, (all2, everything2) -> this.enableMonitor.enabled(all2, af2));
            }
            return this.enableMonitor.enabled(all, af2);
        });
    }

    @Override
    public void stateChanged(ChangeEvent e2) {
        Mutex.EVENT.readAccess(this);
    }

    @Override
    public void run() {
        this.updateStateProperties();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        boolean first = false;
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
            first = true;
        }
        this.support.addPropertyChangeListener(listener);
        if (first) {
            this.startListeners();
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (null != this.support) {
            this.support.removePropertyChangeListener(listener);
            if (!this.support.hasListeners(null)) {
                this.stopListeners();
                this.support = null;
            }
        }
    }

    protected void startListeners() {
        this.performer.startListeners();
        this.global.registerListener(this.type, this);
        if (this.enableMonitor != null) {
            this.fetchEnabledValue();
            this.enableMonitor.addChangeListener(this);
        }
    }

    protected void stopListeners() {
        this.global.unregisterListener(this.type, this);
        this.performer.stopListeners();
        if (this.enableMonitor != null) {
            this.enableMonitor.removeChangeListener(this);
        }
    }

    @Override
    public void putValue(String key, Object o2) {
    }

    @Override
    public Object getValue(String key) {
        if ("enabler".equals(key)) {
            assert (EventQueue.isDispatchThread());
            this.updateState();
        } else if ("ActionCommandKey".equals(key)) {
            Object o2 = this.performer.delegate.get("ActionCommandKey");
            if (o2 == null) {
                o2 = this.performer.delegate.get("key");
            }
            if (o2 != null) {
                return o2.toString();
            }
        }
        return null;
    }

    @Override
    public void setEnabled(boolean b2) {
    }

    void clearState() {
        this.performer.clear();
        if (this.enableMonitor != null) {
            this.enableMonitor.clear();
        }
    }

    void updateState() {
        this.clearState();
        if (!this.isListening()) {
            return;
        }
        this.updateStateProperties();
    }

    void updateStateProperties() {
        boolean prev = this.previousEnabled;
        boolean now = this.isEnabled();
        if (prev != now) {
            this.updateEnabledState(now);
        }
    }

    boolean wasEnabled() {
        return this.previousEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isListening() {
        ContextAction contextAction = this;
        synchronized (contextAction) {
            return this.support != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChange(String property, Boolean old, Boolean current) {
        PropertyChangeSupport s2;
        ContextAction contextAction = this;
        synchronized (contextAction) {
            s2 = this.support;
            if (s2 == null) {
                return;
            }
        }
        s2.firePropertyChange(property, old, current);
    }

    protected void updateEnabledState(boolean enabled) {
        this.previousEnabled = enabled;
        this.firePropertyChange("enabled", !enabled, enabled);
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new ContextAction<T>(this.performer, this.selectMode, actionContext, this.type, this.global.isSurvive(), this.enableMonitor == null ? null : this.enableMonitor.createContextMonitor(actionContext));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.selectMode, this.performer, this.enableMonitor});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ContextAction) {
            ContextAction c2 = (ContextAction)obj;
            return this.type.equals(c2.type) && this.selectMode.equals((Object)c2.selectMode) && this.performer.equals(c2.performer) && Objects.equals(this.enableMonitor, c2.enableMonitor);
        }
        return false;
    }

    static interface StatefulMonitor<T> {
        public void clear();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public boolean enabled(List<? extends T> var1, Supplier<Action> var2);

        public Class<?> getType();

        public StatefulMonitor<T> createContextMonitor(Lookup var1);
    }

    static class Performer<Data>
    implements ChangeListener {
        final Map delegate;
        Reference<ContextAction> owner;
        Reference<Object> instDelegate = null;
        StatefulMonitor enabler = null;
        ChangeListener weakEnableListener;
        PropertyChangeListener weakActionListener;

        public Performer(Map delegate) {
            this.delegate = delegate;
        }

        public Performer(ContextActionPerformer<Data> p2, ContextActionEnabler<Data> e2) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("delegate", p2);
            map.put("enabler", e2);
            this.delegate = map;
        }

        void clear() {
            Object o2;
            this.stopListeners();
            Reference<Object> r2 = this.instDelegate;
            this.instDelegate = null;
            if (r2 != null && (o2 = r2.get()) instanceof Performer) {
                ((Performer)o2).clear();
            }
        }

        void attach(ContextAction a2) {
            this.owner = new WeakReference<ContextAction>(a2);
        }

        Object delegate(Lookup.Provider everything, List<?> data) {
            return this.delegate0(everything, data, true);
        }

        private Object delegate0(Lookup.Provider everything, List<?> data, boolean getAction) {
            Object d2;
            Object object = d2 = this.instDelegate != null ? this.instDelegate.get() : null;
            if (d2 != null) {
                if (getAction && d2 instanceof Performer) {
                    return ((Performer)d2).delegate0(everything, data, getAction);
                }
                return d2;
            }
            d2 = this.createDelegate(everything, data);
            if (d2 != null) {
                if (getAction && d2 instanceof Performer) {
                    final Object fd = d2;
                    this.instDelegate = new WeakReference<Object>(d2){
                        private Object hardRef;
                        {
                            super(arg0);
                            this.hardRef = fd;
                        }
                    };
                    return ((Performer)d2).delegate0(everything, data, getAction);
                }
                if (d2 instanceof ContextAwareAction) {
                    d2 = ((ContextAwareAction)d2).createContextAwareInstance(everything.getLookup());
                }
                this.instDelegate = new WeakReference<Object>(d2);
            } else {
                this.instDelegate = NONE;
            }
            return d2;
        }

        void stopListeners() {
            if (this.enabler != null) {
                this.enabler.removeChangeListener(this.weakEnableListener);
                this.weakEnableListener = null;
            }
        }

        void startListeners() {
            if (this.enabler != null) {
                this.weakEnableListener = WeakListeners.change(this, this.enabler);
                this.enabler.addChangeListener(this.weakEnableListener);
            }
        }

        void detach() {
            Object inst;
            this.stopListeners();
            Object object = inst = this.instDelegate != null ? this.instDelegate.get() : null;
            if (inst instanceof Action) {
                ((Action)inst).removePropertyChangeListener(this.weakActionListener);
            }
        }

        public boolean enabled(List<? extends Object> data, Lookup.Provider everything) {
            Object o2 = this.delegate.get("enabler");
            if (o2 == null) {
                return true;
            }
            if (o2 instanceof ContextActionEnabler) {
                ContextActionEnabler en = (ContextActionEnabler)o2;
                return en.enabled(data);
            }
            GeneralAction.LOG.warning("Wrong enabler for " + this.delegate + ":" + o2);
            return false;
        }

        protected Object createDelegate(Lookup.Provider everything, List<?> data) {
            Object obj = this.delegate.get("delegate");
            if (obj instanceof ContextActionPerformer) {
                return obj;
            }
            if (obj instanceof Performer) {
                return obj;
            }
            if (!(obj instanceof ActionListener)) {
                GeneralAction.LOG.warning("Wrong delegate for " + this.delegate + ":" + obj);
            }
            return obj;
        }

        public void actionPerformed(ActionEvent ev, List<? extends Data> data, Lookup.Provider everything) {
            Object obj = this.delegate0(everything, data, false);
            if (obj instanceof ContextActionPerformer) {
                ContextActionPerformer perf = (ContextActionPerformer)obj;
                perf.actionPerformed(ev, data);
                return;
            }
            if (obj instanceof Performer) {
                Performer perf = (Performer)obj;
                perf.actionPerformed(ev, data, everything);
                return;
            }
            if (obj instanceof ActionListener) {
                ((ActionListener)obj).actionPerformed(ev);
            }
        }

        public int hashCode() {
            return this.delegate.hashCode() + 117;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Performer) {
                Performer l2 = (Performer)obj;
                return this.delegate.equals(l2.delegate);
            }
            return false;
        }

        @Override
        public void stateChanged(ChangeEvent e2) {
            ContextAction a2 = this.owner.get();
            if (a2 != null) {
                a2.updateState();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Object o2 = this.delegate.get("ActionCommandKey");
            if (o2 == null) {
                o2 = this.delegate.get("key");
            }
            Object d2 = this.instDelegate == null ? null : this.instDelegate.get();
            sb.append("Performer{id = ").append(Objects.toString(o2)).append(", del = ").append(Objects.toString(d2)).append("}");
            return sb.toString();
        }
    }
}

