/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

public final class GraphicsUtils {
    private static final boolean antialias = Boolean.getBoolean("nb.cellrenderer.antialiasing") || Boolean.getBoolean("swing.aatext") || GraphicsUtils.isGTK() && GraphicsUtils.gtkShouldAntialias() || GraphicsUtils.isAqua();
    private static Boolean gtkAA;
    private static Map<Object, Object> hintsMap;

    private GraphicsUtils() {
    }

    private static boolean isAqua() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    private static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private static final boolean gtkShouldAntialias() {
        if (gtkAA == null) {
            Object o2 = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/Antialias");
            gtkAA = Integer.valueOf(1).equals(o2);
        }
        return gtkAA;
    }

    public static void configureDefaultRenderingHints(Graphics graphics) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).addRenderingHints(GraphicsUtils.getRenderingHints());
        }
    }

    private static final Map<?, ?> getRenderingHints() {
        HashMap<RenderingHints.Key, Object> ret = hintsMap;
        if (ret == null) {
            ret = (HashMap<RenderingHints.Key, Object>)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            if (ret == null) {
                ret = new HashMap<RenderingHints.Key, Object>();
                if (antialias) {
                    ret.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
            }
            if (antialias || !RenderingHints.VALUE_TEXT_ANTIALIAS_OFF.equals(ret.get(RenderingHints.KEY_TEXT_ANTIALIASING))) {
                ret.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            hintsMap = Collections.unmodifiableMap(ret);
        }
        return ret;
    }
}

