/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import org.openide.awt.GraphicsUtils;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.HtmlRendererImpl;
import org.openide.util.Exceptions;

class HtmlLabelUI
extends LabelUI {
    private static HtmlLabelUI uiInstance;
    private static int FIXED_HEIGHT;
    private static Color unfocusedSelBg;
    private static Color unfocusedSelFg;

    HtmlLabelUI() {
    }

    public static ComponentUI createUI(JComponent c2) {
        assert (c2 instanceof HtmlRendererImpl);
        if (uiInstance == null) {
            uiInstance = new HtmlLabelUI();
        }
        return uiInstance;
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        if (GraphicsEnvironment.isHeadless()) {
            return super.getPreferredSize(c2);
        }
        return this.calcPreferredSize((HtmlRendererImpl)c2);
    }

    private static int textWidth(String text, Graphics g2, Font f2, boolean html) {
        if (text != null) {
            if (html) {
                return (int)Math.ceil(HtmlRenderer.renderHTML(text, g2, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, f2, Color.BLACK, 0, false));
            }
            return (int)Math.ceil(HtmlRenderer.renderPlainString(text, g2, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, f2, Color.BLACK, 0, false));
        }
        return 0;
    }

    private static Font font(HtmlRendererImpl c2) {
        Font result = c2.getFont();
        if (result == null) {
            String key;
            switch (c2.type()) {
                case LIST: {
                    key = "List.font";
                    break;
                }
                case TABLE: {
                    key = "Table.font";
                    break;
                }
                case TREE: {
                    key = "Tree.font";
                    break;
                }
                default: {
                    key = "Label.font";
                }
            }
            result = UIManager.getFont(key);
        }
        if (result == null && (result = UIManager.getFont("controlFont")) == null) {
            result = new Font("SansSerif", 0, 12);
        }
        return result;
    }

    private Dimension calcPreferredSize(HtmlRendererImpl r2) {
        Insets ins = r2.getInsets();
        Dimension prefSize = new Dimension(ins.left + ins.right, ins.top + ins.bottom);
        String text = r2.getText();
        Graphics g2 = r2.getGraphics();
        Icon icon = r2.getIcon();
        Font font = HtmlLabelUI.font(r2);
        if (text != null) {
            FontMetrics fm = g2.getFontMetrics(font);
            prefSize.height += fm.getMaxAscent() + fm.getMaxDescent();
        }
        if (icon != null) {
            if (r2.isCentered()) {
                prefSize.height += icon.getIconHeight() + r2.getIconTextGap();
                prefSize.width += icon.getIconWidth();
            } else {
                prefSize.height = Math.max(icon.getIconHeight() + ins.top + ins.bottom, prefSize.height);
                prefSize.width += icon.getIconWidth() + r2.getIconTextGap();
            }
        }
        GraphicsUtils.configureDefaultRenderingHints(g2);
        int textwidth = HtmlLabelUI.textWidth(text, g2, font, r2.isHtml()) + 4;
        prefSize.width = r2.isCentered() ? Math.max(prefSize.width, textwidth + ins.right + ins.left) : (prefSize.width += textwidth + r2.getIndent());
        if (FIXED_HEIGHT > 0) {
            prefSize.height = FIXED_HEIGHT;
        }
        return prefSize;
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        Color bg = HtmlLabelUI.getBackgroundFor((HtmlRendererImpl)c2);
        HtmlRendererImpl h2 = (HtmlRendererImpl)c2;
        if (!(bg == null || HtmlLabelUI.isNimbus() && h2.getType() == HtmlRendererImpl.Type.TREE)) {
            int x2;
            if (h2.getType() == HtmlRendererImpl.Type.TABLE) {
                x2 = 0;
            } else {
                x2 = h2.isSelected() ? (h2.getIcon() == null ? 0 : h2.getIcon().getIconWidth() + h2.getIconTextGap()) : 0;
                x2 += h2.getIndent();
            }
            g2.setColor(bg);
            g2.fillRect(x2, 0, c2.getWidth() - x2, c2.getHeight());
        }
        if (h2.isLeadSelection()) {
            Color focus = UIManager.getColor("Tree.selectionBorderColor");
            if (focus == null || focus.equals(bg)) {
                focus = Color.BLUE;
            }
            if (!(HtmlLabelUI.isGTK() || HtmlLabelUI.isAqua() || HtmlLabelUI.isNimbus() || HtmlLabelUI.isFlatLaf())) {
                int x3 = h2.getType() == HtmlRendererImpl.Type.TABLE ? 0 : (h2.getIcon() == null ? 0 : h2.getIcon().getIconWidth() + h2.getIconTextGap());
                g2.setColor(focus);
                g2.drawRect(x3, 0, c2.getWidth() - (x3 + 1), c2.getHeight() - 1);
            }
        }
        this.paint(g2, c2);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        GraphicsUtils.configureDefaultRenderingHints(g2);
        HtmlRendererImpl r2 = (HtmlRendererImpl)c2;
        if (r2.isCentered()) {
            this.paintIconAndTextCentered(g2, r2);
        } else {
            this.paintIconAndText(g2, r2);
        }
    }

    private void paintIconAndText(Graphics g2, HtmlRendererImpl r2) {
        Font f2 = HtmlLabelUI.font(r2);
        g2.setFont(f2);
        FontMetrics fm = g2.getFontMetrics();
        int txtH = fm.getMaxAscent() + fm.getMaxDescent();
        Insets ins = r2.getInsets();
        int rHeight = r2.getHeight();
        int availH = rHeight - (ins.top + ins.bottom);
        int txtY = availH >= txtH ? txtH + ins.top + (availH / 2 - txtH / 2) - fm.getMaxDescent() : (r2.getHeight() > txtH ? txtH + (rHeight - txtH) / 2 - fm.getMaxDescent() : fm.getMaxAscent());
        int txtX = r2.getIndent();
        Icon icon = r2.getIcon();
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            int iconY = availH > icon.getIconHeight() ? ins.top + (availH / 2 - icon.getIconHeight() / 2) : (availH == icon.getIconHeight() ? ins.top : ins.top);
            int iconX = ins.left + r2.getIndent() + 1;
            try {
                icon.paintIcon(r2, g2, iconX, iconY);
            }
            catch (NullPointerException npe) {
                Exceptions.attachMessage(npe, "Probably an ImageIcon with a null source image: " + icon + " - " + r2.getText());
                Exceptions.printStackTrace(npe);
            }
            txtX = iconX + icon.getIconWidth() + r2.getIconTextGap();
        } else {
            txtX += ins.left;
        }
        String text = r2.getText();
        if (text == null) {
            return;
        }
        int txtW = icon != null ? r2.getWidth() - (ins.left + ins.right + icon.getIconWidth() + r2.getIconTextGap() + r2.getIndent()) : r2.getWidth() - (ins.left + ins.right + r2.getIndent());
        Color background = HtmlLabelUI.getBackgroundFor(r2);
        Color foreground = HtmlLabelUI.ensureContrastingColor(HtmlLabelUI.getForegroundFor(r2), background);
        if (r2.isHtml()) {
            HtmlRenderer._renderHTML(text, 0, g2, txtX, txtY, txtW, txtH, f2, foreground, r2.getRenderStyle(), true, background, r2.isSelected());
        } else {
            HtmlRenderer.renderPlainString(text, g2, txtX, txtY, txtW, txtH, f2, foreground, r2.getRenderStyle(), true);
        }
    }

    private void paintIconAndTextCentered(Graphics g2, HtmlRendererImpl r2) {
        int txtW;
        Insets ins = r2.getInsets();
        Icon ic = r2.getIcon();
        int w2 = r2.getWidth() - (ins.left + ins.right);
        int txtX = ins.left;
        int txtY = 0;
        if (ic != null && ic.getIconWidth() > 0 && ic.getIconHeight() > 0) {
            int iconx = w2 > ic.getIconWidth() ? w2 / 2 - ic.getIconWidth() / 2 : txtX;
            int icony = 0;
            ic.paintIcon(r2, g2, iconx, icony);
            txtY += ic.getIconHeight() + r2.getIconTextGap();
        }
        txtX = (txtW = r2.getPreferredSize().width) < r2.getWidth() ? r2.getWidth() / 2 - txtW / 2 : 0;
        int txtH = r2.getHeight() - txtY;
        Font f2 = HtmlLabelUI.font(r2);
        g2.setFont(f2);
        FontMetrics fm = g2.getFontMetrics(f2);
        txtY += fm.getMaxAscent();
        Color background = HtmlLabelUI.getBackgroundFor(r2);
        Color foreground = HtmlLabelUI.ensureContrastingColor(HtmlLabelUI.getForegroundFor(r2), background);
        if (r2.isHtml()) {
            HtmlRenderer._renderHTML(r2.getText(), 0, g2, txtX, txtY, txtW, txtH, f2, foreground, r2.getRenderStyle(), true, background, r2.isSelected());
        } else {
            HtmlRenderer.renderString(r2.getText(), g2, txtX, txtY, txtW, txtH, f2, foreground, r2.getRenderStyle(), true);
        }
    }

    static Color ensureContrastingColor(Color fg, Color bg) {
        if (bg == null) {
            if (HtmlLabelUI.isNimbus()) {
                bg = UIManager.getColor("Tree.background");
                if (null == bg) {
                    bg = Color.WHITE;
                }
            } else {
                bg = UIManager.getColor("text");
                if (bg == null) {
                    bg = Color.WHITE;
                }
            }
        }
        if (fg == null) {
            if (HtmlLabelUI.isNimbus()) {
                fg = UIManager.getColor("Tree.foreground");
                if (null == fg) {
                    fg = Color.BLACK;
                }
            } else {
                fg = UIManager.getColor("textText");
                if (fg == null) {
                    fg = Color.BLACK;
                }
            }
        }
        if (Color.BLACK.equals(fg) && Color.WHITE.equals(fg)) {
            return fg;
        }
        boolean replace = fg.equals(bg);
        int dif = 0;
        if (!replace) {
            dif = HtmlLabelUI.difference(fg, bg);
            boolean bl = replace = dif < 60;
        }
        if (replace) {
            int lum = HtmlLabelUI.luminance(bg);
            boolean darker = lum >= 128;
            fg = darker ? Color.BLACK : Color.WHITE;
        }
        return fg;
    }

    private static int difference(Color a2, Color b2) {
        return Math.abs(HtmlLabelUI.luminance(a2) - HtmlLabelUI.luminance(b2));
    }

    private static int luminance(Color c2) {
        return (299 * c2.getRed() + 587 * c2.getGreen() + 114 * c2.getBlue()) / 1000;
    }

    static Color getBackgroundFor(HtmlRendererImpl r2) {
        if (r2.isOpaque()) {
            return r2.getBackground();
        }
        if (r2.isSelected() && !r2.isParentFocused() && !HtmlLabelUI.isGTK() && !HtmlLabelUI.isNimbus()) {
            return HtmlLabelUI.getUnfocusedSelectionBackground();
        }
        Color result = null;
        if (r2.isSelected()) {
            switch (r2.getType()) {
                case LIST: {
                    result = UIManager.getColor("List.selectionBackground");
                    if (result != null) break;
                    result = UIManager.getColor("Tree.selectionBackground");
                    break;
                }
                case TABLE: {
                    result = UIManager.getColor("Table.selectionBackground");
                    break;
                }
                case TREE: {
                    return UIManager.getColor("Tree.selectionBackground");
                }
            }
            return result == null ? r2.getBackground() : result;
        }
        return null;
    }

    static Color getForegroundFor(HtmlRendererImpl r2) {
        if (r2.isSelected() && !r2.isParentFocused() && !HtmlLabelUI.isGTK() && !HtmlLabelUI.isNimbus()) {
            return HtmlLabelUI.getUnfocusedSelectionForeground();
        }
        if (!r2.isEnabled()) {
            return UIManager.getColor("textInactiveText");
        }
        Color result = null;
        if (r2.isSelected()) {
            switch (r2.getType()) {
                case LIST: {
                    result = UIManager.getColor("List.selectionForeground");
                    break;
                }
                case TABLE: {
                    result = UIManager.getColor("Table.selectionForeground");
                    break;
                }
                case TREE: {
                    result = UIManager.getColor("Tree.selectionForeground");
                }
            }
        }
        return result == null ? r2.getForeground() : result;
    }

    static boolean isAqua() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    static boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    static boolean isFlatLaf() {
        return UIManager.getLookAndFeel().getID().startsWith("FlatLaf");
    }

    private static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!Color.WHITE.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    private static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    static {
        String ht = System.getProperty("nb.cellrenderer.fixedheight");
        if (ht != null) {
            try {
                FIXED_HEIGHT = Integer.parseInt(ht);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

